/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.List;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IdUtil;

@JRubyClass(name={"Object"}, include={"Kernel"})
public class RubyObject
extends RubyBasicObject {
    public static final ObjectAllocator OBJECT_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyObject(runtime2, klass);
        }
    };

    public RubyObject(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, metaClass, useObjectSpace, canBeTainted);
    }

    protected RubyObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime2, metaClass, useObjectSpace);
    }

    public static RubyClass createObjectClass(Ruby runtime2, RubyClass objectClass) {
        objectClass.index = 14;
        objectClass.defineAnnotatedMethods(ObjectMethods.class);
        return objectClass;
    }

    public void attachToObjectSpace() {
        this.getRuntime().getObjectSpace().add(this);
    }

    public int getNativeTypeIndex() {
        return 14;
    }

    public static void puts(Object obj) {
        System.out.println(obj.toString());
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod(this.getRuntime().getCurrentContext(), "==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        RubyString rubyString = RuntimeHelpers.invoke(this.getRuntime().getCurrentContext(), this, "to_s").convertToString();
        return rubyString.getUnicodeValue();
    }

    protected void checkFrozen() {
        this.testFrozen();
    }

    private static void initCopy(IRubyObject clone, RubyObject original) {
        assert (!clone.isFrozen()) : "frozen object (" + clone.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone);
        if (original.hasVariables()) {
            clone.syncVariables(original.getVariableList());
        }
        if (original instanceof RubyModule) {
            ((RubyModule)clone).syncConstants((RubyModule)original);
        }
        clone.callMethod(clone.getRuntime().getCurrentContext(), "initialize_copy", original);
    }

    public final void callInit(IRubyObject[] args2, Block block) {
        this.callMethod(this.getRuntime().getCurrentContext(), "initialize", args2, block);
    }

    @Deprecated
    public final IRubyObject convertToType(RubyClass target, int convertMethodIndex) {
        throw new RuntimeException("Not supported; use the String versions");
    }

    @Deprecated
    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject[] args2, Block block) {
        int line;
        String file2;
        if (block.isGiven()) {
            if (args2.length > 0) {
                throw this.getRuntime().newArgumentError(args2.length, 0);
            }
            return this.yieldUnder(context, mod, block);
        }
        if (args2.length == 0) {
            throw this.getRuntime().newArgumentError("block not supplied");
        }
        if (args2.length > 3) {
            String lastFuncName = context.getFrameName();
            throw this.getRuntime().newArgumentError("wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyString evalStr = args2[0] instanceof RubyString ? (RubyString)args2[0] : args2[0].convertToString();
        if (args2.length > 1) {
            file2 = args2[1].convertToString().asJavaString();
            line = args2.length > 2 ? (int)(args2[2].convertToInteger().getLongValue() - 1L) : 0;
        } else {
            file2 = "(eval)";
            line = 0;
        }
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, mod, block);
        }
        throw context.getRuntime().newArgumentError("block not supplied");
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.convertToString();
        String file2 = "(eval)";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (block.isGiven()) {
            throw context.getRuntime().newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = (int)(arg2.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(context, mod, evalStr, file2, line);
    }

    public IRubyObject evalUnder(ThreadContext context, RubyModule under, IRubyObject src, IRubyObject file2, IRubyObject line) {
        return this.evalUnder(context, under, src.convertToString(), file2.convertToString().toString(), (int)(line.convertToInteger().getLongValue() - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line) {
        Visibility savedVisibility = context.getCurrentVisibility();
        context.setCurrentVisibility(Visibility.PUBLIC);
        context.preExecuteUnder(under, Block.NULL_BLOCK);
        try {
            IRubyObject iRubyObject = ASTInterpreter.evalSimple(context, (IRubyObject)this, src, file2, line);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
            context.setCurrentVisibility(savedVisibility);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            boolean aValue;
            IRubyObject valueInYield;
            if (args2.length == 1) {
                valueInYield = args2[0];
                aValue = false;
            } else {
                valueInYield = RubyArray.newArrayNoCopy(context.getRuntime(), args2);
                aValue = true;
            }
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            IRubyObject iRubyObject = block.yield(context, valueInYield, this, context.getRubyClass(), aValue);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block) {
        context.preExecuteUnder(under, block);
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            block = block.cloneBlock();
            block.getBinding().setSelf(this);
            block.getBinding().getFrame().setSelf(this);
            IRubyObject iRubyObject = block.yield(context, this, this, context.getRubyClass(), false);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            IRubyObject iRubyObject = (IRubyObject)bj.getValue();
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            context.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return super.op_equal(context, obj);
    }

    @JRubyMethod(name={"equal?"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return super.op_eqq(context, other);
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || that.callMethod(context, "==", other).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that.callMethod(context, "eql?", other).isTrue();
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject mname) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
    }

    @JRubyMethod(name={"respond_to?"})
    public RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    @JRubyMethod(name={"object_id", "__id__"})
    public synchronized IRubyObject id() {
        return super.id();
    }

    @JRubyMethod(name={"id"})
    public synchronized IRubyObject id_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#id will be deprecated; use Object#object_id", "Object#id", "Object#object_id");
        return this.id();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public int hashCode() {
        IRubyObject hashValue = this.callMethod(this.getRuntime().getCurrentContext(), "hash");
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return super.hashCode();
    }

    @JRubyMethod(name={"class"})
    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    @JRubyMethod(name={"type"})
    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class", "Object#type", "Object#class");
        return this.type();
    }

    @JRubyMethod(name={"clone"}, frame=true)
    public IRubyObject rbClone() {
        return super.rbClone();
    }

    @JRubyMethod(name={"dup"})
    public IRubyObject dup() {
        return super.dup();
    }

    @JRubyMethod(name={"display"}, optional=1)
    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.getRuntime().getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"tainted?"})
    public RubyBoolean tainted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isTaint());
    }

    @JRubyMethod(name={"taint"})
    public IRubyObject taint(ThreadContext context) {
        this.taint(context.getRuntime());
        return this;
    }

    @JRubyMethod(name={"untaint"})
    public IRubyObject untaint(ThreadContext context) {
        context.getRuntime().secure(3);
        if (this.isTaint()) {
            this.testFrozen();
            this.setTaint(false);
        }
        return this;
    }

    @JRubyMethod(name={"freeze"})
    public IRubyObject freeze(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if ((this.flags & 4) == 0 && (runtime2.is1_9() || !this.isImmediate())) {
            if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
                throw runtime2.newSecurityError("Insecure: can't freeze object");
            }
            this.flags |= 4;
        }
        return this;
    }

    @JRubyMethod(name={"frozen?"})
    public RubyBoolean frozen_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isFrozen());
    }

    @JRubyMethod(name={"untrusted?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean untrusted_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isUntrusted());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject untrust(ThreadContext context) {
        if (!this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags |= 0x10;
        }
        return this;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject trust(ThreadContext context) {
        if (this.isUntrusted() && !this.isImmediate()) {
            this.checkFrozen();
            this.flags &= 0xFFFFFFEF;
        }
        return this;
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, object.callMethod(context, "inspect"));
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return super.inspect();
    }

    @JRubyMethod(name={"instance_of?"}, required=1)
    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.getRuntime().getTrue();
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"kind_of?", "is_a?"}, required=1)
    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.getRuntime().newTypeError("class or module required");
        }
        return context.getRuntime().newBoolean(((RubyModule)type2).isInstance(this));
    }

    @JRubyMethod(name={"methods"}, optional=1)
    public IRubyObject methods(ThreadContext context, IRubyObject[] args2) {
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        Ruby runtime2 = this.getRuntime();
        RubyArray singletonMethods = runtime2.newArray();
        HashSet<String> seen = new HashSet<String>();
        if (this.getMetaClass().isSingleton()) {
            this.getMetaClass().populateInstanceMethodNames(seen, singletonMethods, Visibility.PRIVATE, true, false, false);
            if (all) {
                this.getMetaClass().getSuperClass().populateInstanceMethodNames(seen, singletonMethods, Visibility.PRIVATE, true, false, true);
            }
        } else if (all) {
            this.getMetaClass().populateInstanceMethodNames(seen, singletonMethods, Visibility.PRIVATE, true, false, true);
        }
        return singletonMethods;
    }

    @JRubyMethod(name={"public_methods"}, optional=1)
    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().public_instance_methods(args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1)
    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().protected_instance_methods(args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1)
    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 0) {
            args2 = new IRubyObject[]{context.getRuntime().getTrue()};
        }
        return this.getMetaClass().private_instance_methods(args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, false);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray singleton_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.singletonMethods(context, args2, true);
    }

    public RubyArray singletonMethods(ThreadContext context, IRubyObject[] args2, boolean asSymbols) {
        RubyArray singletonMethods;
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        if (this.getMetaClass().isSingleton()) {
            singletonMethods = asSymbols ? this.getMetaClass().instance_methods19(new IRubyObject[]{context.getRuntime().getFalse()}) : this.getMetaClass().instance_methods(new IRubyObject[]{context.getRuntime().getFalse()});
            if (all) {
                RubyClass superClass = this.getMetaClass().getSuperClass();
                while (superClass.isIncluded()) {
                    singletonMethods.concat(superClass.instance_methods(new IRubyObject[]{context.getRuntime().getFalse()}));
                    superClass = superClass.getSuperClass();
                }
            }
        } else {
            singletonMethods = context.getRuntime().newEmptyArray();
        }
        return singletonMethods;
    }

    @JRubyMethod(name={"method"}, required=1)
    public IRubyObject method(IRubyObject symbol) {
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.anyToString();
    }

    @JRubyMethod(name={"to_a"}, visibility=Visibility.PUBLIC)
    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete", "to_a");
        return this.getRuntime().newArray((IRubyObject)this);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block);
    }

    @JRubyMethod(name={"instance_eval"}, frame=true)
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject instance_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.specificEval(context, (RubyModule)klazz, args2, block);
    }

    private RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, frame=true)
    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.getRuntime().newArgumentError("block not supplied");
        }
        RubyClass klazz = this.isImmediate() ? context.getRuntime().getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true)
    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime2 = this.getRuntime();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].isModule()) continue;
            throw runtime2.newTypeError(args2[i], runtime2.getModule());
        }
        ThreadContext context = runtime2.getCurrentContext();
        for (int i = args2.length - 1; i >= 0; --i) {
            args2[i].callMethod(context, "extend_object", this);
            args2[i].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, Block block) {
        throw context.getRuntime().newArgumentError(0, 1);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    @JRubyMethod(name={"send", "__send__"})
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = arg0.asJavaString();
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"send", "__send__"}, rest=true)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject[] newArgs;
        String name2 = args2[0].asJavaString();
        int newArgsLength = args2.length - 1;
        if (newArgsLength == 0) {
            newArgs = IRubyObject.NULL_ARRAY;
        } else {
            newArgs = new IRubyObject[newArgsLength];
            System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        }
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, newArgs, block);
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p(ThreadContext context) {
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"=~"}, required=1)
    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.getRuntime().getFalse();
    }

    public IRubyObject to_java() {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    public IRubyObject as(Class javaClass) {
        throw this.getRuntime().newTypeError(this.getMetaClass().getBaseName() + " cannot coerce to a Java type.");
    }

    @JRubyMethod(name={"instance_variable_defined?"}, required=1)
    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        if (this.variableTableContains(this.validateInstanceVariable(name2.asJavaString()))) {
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"instance_variable_get"}, required=1)
    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        IRubyObject value2 = this.variableTableFetch(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"instance_variable_set"}, required=2)
    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2.asJavaString()), value2);
    }

    @JRubyMethod(name={"remove_instance_variable"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(this.validateInstanceVariable(name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        throw context.getRuntime().newNameError("instance variable " + name2.asJavaString() + " not defined", name2.asJavaString());
    }

    @JRubyMethod(name={"instance_variables"})
    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        List<String> nameList = this.getInstanceVariableNameList();
        RubyArray array = runtime2.newArray(nameList.size());
        for (String name2 : nameList) {
            array.append(runtime2.newString(name2));
        }
        return array;
    }

    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowable as an instance variable name", name2);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        List<String> names2 = this.getInstanceVariableNameList();
        out.writeInt(names2.size());
        for (String name2 : names2) {
            out.writeObject(name2);
            out.writeObject(this.getInstanceVariables().getInstanceVariable(name2));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int ivarCount = in.readInt();
        for (int i = 0; i < ivarCount; ++i) {
            this.setInstanceVariable((String)in.readObject(), (IRubyObject)in.readObject());
        }
    }

    public static class ObjectMethods {
        @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
        public static IRubyObject intialize(IRubyObject self) {
            return self.getRuntime().getNil();
        }
    }
}

