/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.IArityNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZSuperNode
extends Node
implements IArityNode,
BlockAcceptingNode {
    private Node iterNode;

    public ZSuperNode(ISourcePosition position) {
        super(position);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ZSUPERNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitZSuperNode(this);
    }

    @Override
    public Arity getArity() {
        return Arity.optional();
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? ZSuperNode.createList(this.iterNode) : EMPTY_LIST;
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        Block block = ASTInterpreter.getBlock(runtime2, context, self, aBlock, this.iterNode);
        return RuntimeHelpers.callZSuper(runtime2, context, block, self);
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        String name2 = context.getFrameName();
        RubyModule klazz = context.getFrameKlazz();
        if (name2 != null && klazz != null && klazz.getSuperClass().isMethodBound(name2, false)) {
            return "super";
        }
        return null;
    }
}

