/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor.rewriter.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.utils.BooleanStateStack;
import org.jruby.ast.visitor.rewriter.utils.CallDepth;
import org.jruby.ast.visitor.rewriter.utils.HereDocument;
import org.jruby.ast.visitor.rewriter.utils.Indentor;
import org.jruby.ast.visitor.rewriter.utils.LocalVariables;
import org.jruby.lexer.yacc.ISourcePosition;

public class ReWriterContext {
    private final String source;
    private final CallDepth callDepth = new CallDepth();
    private final LocalVariables localVariables = new LocalVariables();
    private final BooleanStateStack printQuotesInString = new BooleanStateStack(true, true);
    private HereDocument hereDocument;
    private boolean skipNextNewline = true;
    private PrintWriter output;
    private FormatHelper formatHelper;
    private ISourcePosition lastPosition;

    public LocalVariables getLocalVariables() {
        return this.localVariables;
    }

    public ReWriterContext(PrintWriter output, String source2, FormatHelper formatHelper) {
        this.output = output;
        this.source = source2;
        this.formatHelper = formatHelper;
    }

    public ReWriterContext(StringWriter output, String source2, FormatHelper formatHelper) {
        this(new PrintWriter(output), source2, formatHelper);
    }

    public CallDepth getCallDepth() {
        return this.callDepth;
    }

    public String getSource() {
        return this.source;
    }

    public Indentor getIndentor() {
        return this.formatHelper.getIndentor();
    }

    public ISourcePosition getLastPosition() {
        return this.lastPosition;
    }

    public void setLastPosition(ISourcePosition lastPosition) {
        this.lastPosition = lastPosition;
    }

    public BooleanStateStack getPrintQuotesInString() {
        return this.printQuotesInString;
    }

    public boolean hasHereDocument() {
        return this.hereDocument != null;
    }

    public HereDocument fetchHereDocument() {
        HereDocument hd = this.hereDocument;
        this.hereDocument = null;
        return hd;
    }

    public void depositHereDocument(String hereDocument) {
        this.hereDocument = new HereDocument(hereDocument, this);
    }

    public boolean isSkipNextNewline() {
        return this.skipNextNewline;
    }

    public void setSkipNextNewline(boolean skipNextNewline) {
        this.skipNextNewline = skipNextNewline;
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public void setOutput(PrintWriter output) {
        this.output = output;
    }

    public FormatHelper getFormatHelper() {
        return this.formatHelper;
    }
}

