/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jline.CandidateListCompletionHandler;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.History;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyModule(name={"Readline"})
public class Readline {
    public static final char ESC_KEY_CODE = '\u001b';
    private static final boolean DEBUG = false;

    public static void createReadline(Ruby runtime2) throws IOException {
        ConsoleHolder holder = new ConsoleHolder();
        holder.history = new ReadlineHistory();
        holder.currentCompletor = null;
        RubyModule mReadline = runtime2.defineModule("Readline");
        mReadline.dataWrapStruct(holder);
        mReadline.defineAnnotatedMethods(Readline.class);
        IRubyObject hist = runtime2.getObject().callMethod(runtime2.getCurrentContext(), "new");
        mReadline.fastSetConstant("HISTORY", hist);
        hist.getSingletonClass().includeModule(runtime2.getEnumerable());
        hist.getSingletonClass().defineAnnotatedMethods(HistoryMethods.class);
        mReadline.fastSetConstant("VERSION", runtime2.newString("JLine wrapper"));
    }

    protected static void initReadline(Ruby runtime2, final ConsoleHolder holder) throws IOException {
        holder.readline = new ConsoleReader();
        holder.readline.setUseHistory(false);
        holder.readline.setUsePagination(true);
        holder.readline.setBellEnabled(true);
        ((CandidateListCompletionHandler)holder.readline.getCompletionHandler()).setAlwaysIncludeNewline(false);
        if (holder.currentCompletor == null) {
            holder.currentCompletor = new RubyFileNameCompletor();
        }
        holder.readline.addCompletor(holder.currentCompletor);
        holder.readline.setHistory(holder.history);
        holder.readline.addTriggeredAction('\u001b', new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    holder.readline.beep();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static History getHistory(ConsoleHolder holder) {
        return holder.history;
    }

    public static ConsoleHolder getHolder(Ruby runtime2) {
        return (ConsoleHolder)runtime2.fastGetModule("Readline").dataGetStruct();
    }

    public static void setCompletor(ConsoleHolder holder, Completor completor) {
        if (holder.readline != null) {
            holder.readline.removeCompletor(holder.currentCompletor);
        }
        holder.currentCompletor = completor;
        if (holder.readline != null) {
            holder.readline.addCompletor(holder.currentCompletor);
        }
    }

    public static Completor getCompletor(ConsoleHolder holder) {
        return holder.currentCompletor;
    }

    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) throws IOException {
        return Readline.s_readline(recv2.getRuntime().getCurrentContext(), recv2, prompt, add_to_hist);
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(ThreadContext context, IRubyObject recv2, IRubyObject prompt, IRubyObject add_to_hist) throws IOException {
        Ruby runtime2 = context.getRuntime();
        ConsoleHolder holder = Readline.getHolder(runtime2);
        if (holder.readline == null) {
            Readline.initReadline(runtime2, holder);
        }
        IRubyObject line = runtime2.getNil();
        String v = null;
        while (true) {
            try {
                holder.readline.getTerminal().disableEcho();
                v = holder.readline.readLine(prompt.toString());
            }
            catch (IOException ioe) {
                if (RubyIO.restartSystemCall(ioe)) {
                    try {
                        holder.readline.getTerminal().initializeTerminal();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
                throw runtime2.newIOErrorFromException(ioe);
            }
            finally {
                holder.readline.getTerminal().enableEcho();
                continue;
            }
            break;
        }
        if (null != v) {
            if (add_to_hist.isTrue()) {
                holder.readline.getHistory().addToHistory(v);
            }
            line = RubyString.newUnicodeString(recv2.getRuntime(), v);
        }
        return line;
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2, IRubyObject prompt) throws IOException {
        return Readline.s_readline(recv2, prompt, recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"readline"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_readline(IRubyObject recv2) throws IOException {
        return Readline.s_readline(recv2, RubyString.newEmptyString(recv2.getRuntime()), recv2.getRuntime().getFalse());
    }

    @JRubyMethod(name={"basic_word_break_characters="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_basic_word_break_character(IRubyObject recv2, IRubyObject achar) throws Exception {
        Ruby runtime2 = recv2.getRuntime();
        if (!achar.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + achar.getMetaClass() + " into String");
        }
        ProcCompletor.setDelimiter(achar.convertToString().toString());
        return achar;
    }

    @JRubyMethod(name={"basic_word_break_characters"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_get_basic_word_break_character(IRubyObject recv2) throws Exception {
        return recv2.getRuntime().newString(ProcCompletor.getDelimiter());
    }

    @JRubyMethod(name={"completion_append_character="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_append_character(IRubyObject recv2, IRubyObject achar) throws Exception {
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"completion_proc="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject s_set_completion_proc(IRubyObject recv2, IRubyObject proc2) throws Exception {
        if (!proc2.respondsTo("call")) {
            throw recv2.getRuntime().newArgumentError("argument must respond to call");
        }
        Readline.setCompletor(Readline.getHolder(recv2.getRuntime()), new ProcCompletor(proc2));
        return recv2.getRuntime().getNil();
    }

    public static class RubyFileNameCompletor
    extends FileNameCompletor {
        public int complete(String buffer, int cursor, List candidates) {
            int index2 = (buffer = buffer.substring(0, cursor)).lastIndexOf(" ");
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            return index2 + 1 + super.complete(buffer, cursor, candidates);
        }
    }

    public static class ProcCompletor
    implements Completor {
        IRubyObject procCompletor;
        private static String[] delimiters = new String[]{" ", "\t", "\n", "\"", "\\", "'", "`", "@", "$", ">", "<", "=", ";", "|", "&", "{", "("};

        public ProcCompletor(IRubyObject procCompletor) {
            this.procCompletor = procCompletor;
        }

        public static String getDelimiter() {
            StringBuilder result = new StringBuilder(delimiters.length);
            for (String delimiter : delimiters) {
                result.append(delimiter);
            }
            return result.toString();
        }

        public static void setDelimiter(String delimiter) {
            ArrayList<String> l = new ArrayList<String>();
            CharBuffer buf = CharBuffer.wrap(delimiter);
            while (buf.hasRemaining()) {
                l.add(String.valueOf(buf.get()));
            }
            delimiters = l.toArray(new String[l.size()]);
        }

        private int wordIndexOf(String buffer) {
            int index2 = 0;
            for (String c : delimiters) {
                index2 = buffer.lastIndexOf(c);
                if (index2 == -1) continue;
                return index2;
            }
            return index2;
        }

        public int complete(String buffer, int cursor, List candidates) {
            ThreadContext context;
            IRubyObject comps;
            int index2 = this.wordIndexOf(buffer = buffer.substring(0, cursor));
            if (index2 != -1) {
                buffer = buffer.substring(index2 + 1);
            }
            if ((comps = RuntimeHelpers.invoke(context = this.procCompletor.getRuntime().getCurrentContext(), this.procCompletor, "call", this.procCompletor.getRuntime().newString(buffer)).callMethod(context, "to_a")) instanceof List) {
                for (Object obj : (List)((Object)comps)) {
                    if (obj == null) continue;
                    candidates.add(obj.toString());
                }
                Collections.sort(candidates);
            }
            return cursor - buffer.length();
        }
    }

    public static class HistoryMethods {
        @JRubyMethod(name={"push", "<<"}, rest=true)
        public static IRubyObject s_push(IRubyObject recv2, IRubyObject[] lines2) throws Exception {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            for (int i = 0; i < lines2.length; ++i) {
                RubyString line = lines2[i].convertToString();
                holder.history.addToHistory(line.getUnicodeValue());
            }
            return recv2.getRuntime().getNil();
        }

        @JRubyMethod(name={"pop"})
        public static IRubyObject s_pop(IRubyObject recv2) throws Exception {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            if (holder.history.size() == 0) {
                return runtime2.getNil();
            }
            RubyString output = runtime2.newString(holder.history.pop());
            output.taint(runtime2.getCurrentContext());
            return output;
        }

        @JRubyMethod(name={"to_a"})
        public static IRubyObject s_hist_to_a(IRubyObject recv2) throws Exception {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            RubyArray histList = recv2.getRuntime().newArray();
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                histList.append(recv2.getRuntime().newString((String)i.next()));
            }
            return histList;
        }

        @JRubyMethod(name={"to_s"})
        public static IRubyObject s_hist_to_s(IRubyObject recv2) {
            return recv2.getRuntime().newString("HISTORY");
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject s_hist_get(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = (int)index2.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                RubyString output = runtime2.newString((String)holder.history.getHistoryList().get(i));
                output.taint(runtime2.getCurrentContext());
                return output;
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"[]="})
        public static IRubyObject s_hist_set(IRubyObject recv2, IRubyObject index2, IRubyObject val) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(runtime2);
            int i = (int)index2.convertToInteger().getLongValue();
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                holder.history.set(i, val.asJavaString());
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
            return runtime2.getNil();
        }

        @JRubyMethod(name={"shift"})
        public static IRubyObject s_hist_shift(IRubyObject recv2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            if (holder.history.size() == 0) {
                return runtime2.getNil();
            }
            try {
                RubyString output = runtime2.newString(holder.history.remove(0));
                output.taint(runtime2.getCurrentContext());
                return output;
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("history shift error");
            }
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject s_hist_length(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newFixnum(holder.history.size());
        }

        @JRubyMethod(name={"empty?"})
        public static IRubyObject s_hist_empty_p(IRubyObject recv2) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            return recv2.getRuntime().newBoolean(holder.history.size() == 0);
        }

        @JRubyMethod(name={"delete_at"})
        public static IRubyObject s_hist_delete_at(IRubyObject recv2, IRubyObject index2) {
            Ruby runtime2 = recv2.getRuntime();
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            int i = RubyNumeric.num2int(index2);
            if (i < 0) {
                i += holder.history.size();
            }
            try {
                RubyString output = runtime2.newString(holder.history.remove(i));
                output.taint(runtime2.getCurrentContext());
                return output;
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw runtime2.newIndexError("invalid history index: " + i);
            }
        }

        @JRubyMethod(name={"each"})
        public static IRubyObject s_hist_each(IRubyObject recv2, Block block) {
            ConsoleHolder holder = Readline.getHolder(recv2.getRuntime());
            Iterator i = holder.history.getHistoryList().iterator();
            while (i.hasNext()) {
                RubyString output = recv2.getRuntime().newString((String)i.next());
                output.taint(recv2.getRuntime().getCurrentContext());
                block.yield(recv2.getRuntime().getCurrentContext(), output);
            }
            return recv2;
        }
    }

    public static class ConsoleHolder {
        public ConsoleReader readline;
        public Completor currentCompletor;
        public ReadlineHistory history;
    }

    public static class ReadlineHistory
    extends History {
        ArrayList historyList = null;
        Field index = null;

        public ReadlineHistory() {
            try {
                Field list2 = History.class.getDeclaredField("history");
                list2.setAccessible(true);
                this.historyList = (ArrayList)list2.get(this);
                this.index = History.class.getDeclaredField("currentIndex");
                this.index.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        public void setCurrentIndex(int i) {
            try {
                this.index.setInt(this, i);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }

        public void set(int i, String s) {
            this.historyList.set(i, s);
        }

        public String pop() {
            return this.remove(this.historyList.size() - 1);
        }

        public String remove(int i) {
            this.setCurrentIndex(this.historyList.size() - 2);
            return (String)this.historyList.remove(i);
        }
    }

    public static class Service
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            Readline.createReadline(runtime2);
        }
    }
}

