/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

@JRubyClass(name={"WeakRef"}, parent="Delegator")
public class WeakRef
extends RubyObject {
    private WeakReference<IRubyObject> ref;
    private static final ObjectAllocator WEAKREF_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new WeakRef(runtime2, klazz);
        }
    };

    public WeakRef(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    @JRubyMethod(name={"__getobj__"})
    public IRubyObject getobj() {
        IRubyObject obj = (IRubyObject)this.ref.get();
        if (obj == null) {
            throw this.newRefError("Illegal Reference - probably recycled");
        }
        return obj;
    }

    @JRubyMethod(name={"new"}, required=1, meta=true)
    public static IRubyObject newInstance(IRubyObject clazz, IRubyObject arg2) {
        WeakRef weakRef = (WeakRef)((RubyClass)clazz).allocate();
        weakRef.callInit(new IRubyObject[]{arg2}, Block.NULL_BLOCK);
        return weakRef;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject obj) {
        this.ref = new WeakReference<IRubyObject>(obj);
        return RuntimeHelpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"weakref_alive?"})
    public IRubyObject weakref_alive_p() {
        return this.ref.get() != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    private RaiseException newRefError(String message2) {
        RubyException exception2 = (RubyException)this.getRuntime().getClass("RefError").newInstance(this.getRuntime().getCurrentContext(), new IRubyObject[]{this.getRuntime().newString(message2)}, Block.NULL_BLOCK);
        return new RaiseException(exception2);
    }

    @JRubyClass(name={"RefError"}, parent="StandardError")
    public static class RefError {
    }

    public static class WeakRefLibrary
    implements Library {
        public void load(Ruby runtime2, boolean wrap2) throws IOException {
            RubyKernel.require(runtime2.getKernel(), runtime2.newString("delegate"), Block.NULL_BLOCK);
            RubyClass delegatorClass = (RubyClass)runtime2.getClassFromPath("Delegator");
            RubyClass weakrefClass = runtime2.defineClass("WeakRef", delegatorClass, WEAKREF_ALLOCATOR);
            weakrefClass.defineAnnotatedMethods(WeakRef.class);
            runtime2.defineClass("RefError", runtime2.getStandardError(), runtime2.getStandardError().getAllocator());
        }
    }
}

