/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.libraries;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.threading.DaemonThreadFactory;

public class FiberLibrary
implements Library {
    private Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory());

    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyClass cFiber = runtime2.defineClass("Fiber", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new Fiber(runtime2, klazz);
            }
        });
        cFiber.defineAnnotatedMethods(Fiber.class);
        cFiber.defineAnnotatedMethods(FiberMeta.class);
    }

    public static class FiberMeta {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) throws InterruptedException {
            Fiber fiber = context.getFiber();
            fiber.result = value2;
            Object object = fiber.yieldLock;
            synchronized (object) {
                fiber.yieldLock.notify();
                fiber.yieldLock.wait();
            }
            return context.getRuntime().getNil();
        }

        @JRubyMethod(compat=CompatVersion.RUBY1_9, meta=true)
        public static IRubyObject current(ThreadContext context, IRubyObject recv2) {
            return context.getRuntime().getCurrentContext().getFiber();
        }
    }

    @JRubyClass(name={"Fiber"})
    public class Fiber
    extends RubyObject {
        private final Object yieldLock;
        private Block block;
        private IRubyObject result;
        private Runnable runnable;
        private boolean alive;

        @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
            this.block = block;
            final Ruby runtime2 = context.getRuntime();
            this.result = runtime2.getNil();
            this.runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = Fiber.this.yieldLock;
                    synchronized (object) {
                        Fiber.this.alive = true;
                        ThreadContext context = runtime2.getCurrentContext();
                        context.setFiber(Fiber.this);
                        try {
                            Fiber.this.result = Fiber.this.block.yield(runtime2.getCurrentContext(), Fiber.this.result, null, null, true);
                        }
                        finally {
                            Fiber.this.yieldLock.notify();
                        }
                    }
                }
            };
            return this;
        }

        public Fiber(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            this.yieldLock = new Object();
            this.alive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject resume(ThreadContext context, IRubyObject[] args2) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.result = args2.length == 1 ? args2[0] : context.getRuntime().newArrayNoCopyLight(args2);
                if (!this.alive) {
                    FiberLibrary.this.executor.execute(this.runnable);
                    this.yieldLock.wait();
                } else {
                    this.yieldLock.notify();
                    this.yieldLock.wait();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
        public IRubyObject transfer(IRubyObject[] args2) throws InterruptedException {
            Object object = this.yieldLock;
            synchronized (object) {
                this.yieldLock.notify();
                this.yieldLock.wait();
            }
            return this.result;
        }

        @JRubyMethod(name={"alive?"}, compat=CompatVersion.RUBY1_9)
        public IRubyObject alive_p(ThreadContext context) {
            return context.getRuntime().newBoolean(this.alive);
        }
    }
}

