/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb.util;

public class IntStack {
    private int[] values;
    private int capacity;
    private int index;

    public IntStack() {
        this(27);
    }

    public IntStack(int size2) {
        this.values = new int[size2];
        this.capacity = size2 - 1;
        this.index = -1;
    }

    public boolean isEmpty() {
        return this.index == -1;
    }

    public int size() {
        return this.index + 1;
    }

    public int get(int ix) {
        if (ix < 0 || ix > this.index) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + ix);
        }
        return this.values[ix];
    }

    public int pop() {
        if (this.index == -1) {
            throw new IllegalStateException("Can't pop from an empty stack");
        }
        return this.values[this.index--];
    }

    public void push(int value2) {
        this.values[++this.index] = value2;
        if (this.index == this.capacity) {
            int[] newValues = new int[this.values.length * 2];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.capacity = newValues.length - 1;
            this.values = newValues;
        }
    }
}

