/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.j2ee.deployment.config.AbstractFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ConfigurationFilesListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.openide.filesystems.FileObject;

public class ConfigFilesListener
extends AbstractFilesListener {
    List consumers;

    public ConfigFilesListener(J2eeModuleProvider j2eeModuleProvider, List list) {
        super(j2eeModuleProvider);
        this.consumers = list;
    }

    protected File[] getTargetFiles() {
        Collection<Server> collection = ServerRegistry.getInstance().getServers();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Server server : collection) {
            String[] stringArray = server.getDeploymentPlanFiles(this.provider.getJ2eeModule().getModuleType());
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = this.provider.getJ2eeModule().getDeploymentConfigurationFile(stringArray[i]);
                if (file == null) continue;
                arrayList.add(file);
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    protected void targetDeleted(FileObject fileObject) {
        this.fireConfigurationFilesChanged(false, fileObject);
    }

    protected void targetCreated(FileObject fileObject) {
        this.fireConfigurationFilesChanged(true, fileObject);
    }

    protected void targetChanged(FileObject fileObject) {
    }

    private void fireConfigurationFilesChanged(boolean bl, FileObject fileObject) {
        for (ConfigurationFilesListener configurationFilesListener : this.consumers) {
            if (bl) {
                configurationFilesListener.fileCreated(fileObject);
                continue;
            }
            configurationFilesListener.fileDeleted(fileObject);
        }
    }

    protected boolean isTarget(FileObject fileObject) {
        return this.isTarget(fileObject.getNameExt());
    }

    protected boolean isTarget(String string) {
        return ServerRegistry.getInstance().isConfigFileName(string, this.provider.getJ2eeModule().getModuleType());
    }
}

