/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.sharability;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.deployment.impl.sharability.ServerVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ServerLibraryTypeProvider
implements LibraryTypeProvider {
    public static final String LIBRARY_TYPE = "serverlibrary";
    public static final String VOLUME_CLASSPATH = "classpath";
    public static final String VOLUME_WS_COMPILE_CLASSPATH = "wscompile";
    public static final String VOLUME_WS_GENERATE_CLASSPATH = "wsgenerate";
    public static final String VOLUME_WS_IMPORT_CLASSPATH = "wsimport";
    public static final String VOLUME_WS_INTEROP_CLASSPATH = "wsinterop";
    public static final String VOLUME_WS_JWSDP_CLASSPATH = "wsjwsdp";
    public static final String VOLUME_JAVADOC = "javadoc";
    public static final String VOLUME_SOURCE = "src";
    private static final String LIB_PREFIX = "libs.";
    private static final String[] VOLUME_TYPES = new String[]{"classpath", "wscompile", "wsgenerate", "wsimport", "wsinterop", "wsjwsdp", "javadoc", "src"};

    private ServerLibraryTypeProvider() {
    }

    public static LibraryTypeProvider create() {
        return new ServerLibraryTypeProvider();
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public Customizer getCustomizer(String string) {
        if (VOLUME_CLASSPATH.equals(string) || VOLUME_JAVADOC.equals(string) || VOLUME_SOURCE.equals(string)) {
            return new ServerVolumeCustomizer(string);
        }
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ServerLibraryTypeProvider.class, (String)"ServerLibraryTypeProvider.typeName");
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String[] getSupportedVolumeTypes() {
        return (String[])VOLUME_TYPES.clone();
    }

    public void libraryCreated(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    boolean bl = ServerLibraryTypeProvider.addLibraryIntoBuild(libraryImplementation, editableProperties);
                    if (bl) {
                        PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImplementation) {
        assert (libraryImplementation != null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String string = ServerLibraryTypeProvider.LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
                        editableProperties.remove((Object)string);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        });
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation libraryImplementation, EditableProperties editableProperties) {
        boolean bl = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            Object object2;
            String string = LIB_PREFIX + libraryImplementation.getName() + '.' + VOLUME_TYPES[i];
            List list = libraryImplementation.getContent(VOLUME_TYPES[i]);
            if (list == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = true;
            for (Object object2 : list) {
                URI uRI;
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile((URL)object2);
                }
                File file = null;
                FileObject fileObject = URLMapper.findFileObject((URL)object2);
                if (fileObject != null) {
                    file = FileUtil.toFile((FileObject)fileObject);
                } else if ("file".equals(((URL)object2).getProtocol()) && (uRI = URI.create(((URL)object2).toExternalForm())) != null) {
                    file = new File(uRI);
                }
                if (file != null) {
                    if (!bl2) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    bl2 = false;
                    file = FileUtil.normalizeFile((File)file);
                    stringBuffer.append(file.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("ServerLibraryTypeProvider: Can not resolve URL: " + object2);
            }
            String string2 = editableProperties.getProperty(string);
            object2 = stringBuffer.toString();
            if (((String)object2).equals(string2)) continue;
            editableProperties.setProperty(string, (String)object2);
            bl = true;
        }
        return bl;
    }
}

