/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;

public final class DeleteActionFactory
extends AbstractComposerActionFactory
implements SceneManager.SelectionListener {
    private final AbstractSVGAction m_deleteAction = new AbstractSVGAction("svg_delete"){

        public void actionPerformed(ActionEvent actionEvent) {
            SVGObject[] sVGObjectArray = DeleteActionFactory.this.m_sceneMgr.getSelected();
            assert (sVGObjectArray != null) : "No selection, button should be disabled";
            if (sVGObjectArray != null) {
                assert (sVGObjectArray.length > 0);
                assert (sVGObjectArray[0] != null);
                SVGObject sVGObject = sVGObjectArray[0];
                sVGObject.repaint();
                DeleteActionFactory.this.m_sceneMgr.deleteObject(sVGObject);
            }
        }
    };

    public DeleteActionFactory(SceneManager sceneManager) {
        super(sceneManager);
        this.m_deleteAction.setEnabled(false);
        sceneManager.addSelectionListener(this);
    }

    public Action[] getMenuActions() {
        return new Action[]{this.m_deleteAction};
    }

    public void selectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2, boolean bl) {
        this.m_deleteAction.setEnabled(sVGObjectArray != null && !bl);
    }

    public void updateActionState() {
        this.m_deleteAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_sceneMgr.getSelected() != null);
    }
}

