/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.ScaleActionFactory;

public final class ScaleXActionFactory
extends ScaleActionFactory {
    private static final ActionMouseCursor SCALE_E_MOUSE_CURSOR = new ActionMouseCursor(11, 2);
    private static final ActionMouseCursor SCALE_W_MOUSE_CURSOR = new ActionMouseCursor(10, 2);

    public ScaleXActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        MouseEvent mouseEvent;
        SVGObject sVGObject;
        if (!bl && !this.m_sceneMgr.isReadOnly() && aWTEvent.getID() == 501 && (sVGObject = this.getObjectToScaleAt(mouseEvent = (MouseEvent)aWTEvent)) != null) {
            return new ScaleXAction(this, sVGObject, mouseEvent);
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        SVGObject sVGObject = this.getSelectedObject();
        if (!bl && sVGObject != null) {
            if (this.isEScalePoint(sVGObject, mouseEvent)) {
                return SCALE_E_MOUSE_CURSOR;
            }
            if (this.isWScalePoint(sVGObject, mouseEvent)) {
                return SCALE_W_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent mouseEvent) {
        SVGObject sVGObject = this.getSelectedObject();
        if (sVGObject != null && (this.isEScalePoint(sVGObject, mouseEvent) || this.isWScalePoint(sVGObject, mouseEvent))) {
            return sVGObject;
        }
        return null;
    }

    private boolean isEScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleEHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isWScalePoint(SVGObject sVGObject, MouseEvent mouseEvent) {
        return sVGObject.getOutline().isAtScaleWHandlePoint(mouseEvent.getX(), mouseEvent.getY());
    }

    private static class ScaleXAction
    extends ScaleActionFactory.ScaleAction {
        public ScaleXAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, MouseEvent mouseEvent) {
            super(composerActionFactory, sVGObject, mouseEvent);
        }

        public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
            if (!bl && aWTEvent.getID() == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Rectangle rectangle = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(this.calculateScaleX(mouseEvent.getX()), 1.0f, this.m_scalePtIdx);
                rectangle.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
            } else if (aWTEvent.getID() == 502) {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        public ActionMouseCursor getMouseCursor(boolean bl) {
            return bl ? null : SCALE_E_MOUSE_CURSOR;
        }
    }
}

