/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectActionFactory;

public final class SelectAction
extends AbstractComposerAction {
    private static final Color SELECTION_BODY_COLOR = new Color(64, 64, 255, 64);
    private static final Color SELECTION_OUTLINE_COLOR = new Color(64, 64, 255, 128);
    private final SVGObject m_selected;

    public SelectAction(SelectActionFactory selectActionFactory, SVGObject sVGObject) {
        super(selectActionFactory);
        this.m_selected = sVGObject;
        assert (this.m_selected != null) : "The selected object cannot be null";
        this.m_selected.repaint(5);
    }

    public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
        SceneManager sceneManager = this.m_factory.getSceneManager();
        assert (sceneManager.containsAction(SelectAction.class));
        MouseEvent mouseEvent = SelectActionFactory.getSelectionEvent(aWTEvent);
        if (mouseEvent != null) {
            SVGObject[] sVGObjectArray = null;
            if (!bl) {
                sVGObjectArray = sceneManager.getPerseusController().getObjectsAt(mouseEvent.getX(), mouseEvent.getY());
            }
            if (sVGObjectArray == null || sVGObjectArray.length == 0 || sVGObjectArray[0] != this.m_selected) {
                this.actionCompleted();
            }
        }
        return false;
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        if (!this.m_isCompleted && !this.m_selected.isDeleted()) {
            if (bl) {
                if (this.getScreenManager().getHighlightObject()) {
                    SVGObjectOutline sVGObjectOutline = this.m_selected.getOutline();
                    sVGObjectOutline.highlight(graphics, n, n2, SELECTION_BODY_COLOR);
                    sVGObjectOutline.draw(graphics, n, n2, SELECTION_OUTLINE_COLOR, false);
                }
            } else {
                this.m_selected.getOutline().draw(graphics, n, n2, SVGObjectOutline.SELECTOR_BODY, true);
            }
        }
    }

    public SVGObject getSelected() {
        if (this.m_isCompleted) {
            return null;
        }
        if (this.m_selected.isDeleted()) {
            this.actionCompleted();
            return null;
        }
        return this.m_selected;
    }

    public void actionCompleted() {
        this.m_selected.repaint(5);
        super.actionCompleted();
    }
}

