/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateActionFactory;

public final class TranslateAction
extends AbstractComposerAction {
    private final SVGObject m_translated;
    private int m_x;
    private int m_y;
    private boolean m_changed = false;

    public TranslateAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, MouseEvent mouseEvent) {
        super(composerActionFactory);
        this.m_translated = sVGObject;
        assert (this.m_translated != null) : "The translated object cannot be null";
        this.m_x = mouseEvent.getX();
        this.m_y = mouseEvent.getY();
    }

    public TranslateAction(ComposerActionFactory composerActionFactory, SVGObject sVGObject, KeyEvent keyEvent) {
        super(composerActionFactory);
        this.m_translated = sVGObject;
        assert (this.m_translated != null) : "The translated object cannot be null";
        int[] nArray = TranslateActionFactory.getCoordDiff(keyEvent);
        this.m_x = nArray[0];
        this.m_y = nArray[1];
        this.translate(this.m_x, this.m_y, true);
    }

    public boolean consumeEvent(AWTEvent aWTEvent, boolean bl) {
        if (!bl) {
            if (aWTEvent instanceof MouseEvent) {
                if (aWTEvent.getID() == 506) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    int n = mouseEvent.getX() - this.m_x;
                    int n2 = mouseEvent.getY() - this.m_y;
                    float f = this.m_translated.getScreenManager().getZoomRatio();
                    this.translate((float)n / f, (float)n2 / f, false);
                } else if (aWTEvent.getID() == 502) {
                    this.actionCompleted();
                    this.m_translated.commitChanges();
                }
            } else {
                int[] nArray = TranslateActionFactory.getCoordDiff(aWTEvent);
                if (nArray != null) {
                    this.translate(this.m_x, this.m_y, true);
                    return true;
                }
                this.actionCompleted();
                this.m_translated.commitChanges();
            }
        }
        return false;
    }

    private void translate(float f, float f2, boolean bl) {
        Rectangle rectangle = this.m_translated.getScreenBBox();
        this.m_translated.translate(f, f2, bl);
        rectangle.add(this.m_translated.getScreenBBox());
        this.m_factory.getSceneManager().getScreenManager().repaint(rectangle, 5);
        this.m_changed = true;
    }

    public void actionCompleted() {
        if (this.m_changed) {
            this.m_translated.applyTextChanges();
            this.m_translated.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
        }
        super.actionCompleted();
    }
}

