/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateAction;

public final class TranslateActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor TRANSLATE_MOUSE_CURSOR = new ActionMouseCursor(13, 1);
    private static int[] DIFF_LEFT = new int[]{-1, 0};
    private static int[] DIFF_RIGHT = new int[]{1, 0};
    private static int[] DIFF_DOWN = new int[]{0, 1};
    private static int[] DIFF_UP = new int[]{0, -1};

    public TranslateActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        if (!bl && !this.m_sceneMgr.isReadOnly()) {
            SVGObject sVGObject;
            if (aWTEvent.getID() == 501) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                SVGObject sVGObject2 = this.getSelectedObjectAt(mouseEvent);
                if (sVGObject2 != null) {
                    return new TranslateAction((ComposerActionFactory)this, sVGObject2, mouseEvent);
                }
            } else if (TranslateActionFactory.getCoordDiff(aWTEvent) != null && (sVGObject = this.getSelectedObject()) != null) {
                return new TranslateAction((ComposerActionFactory)this, sVGObject, (KeyEvent)aWTEvent);
            }
        }
        return null;
    }

    public ActionMouseCursor getMouseCursor(MouseEvent mouseEvent, boolean bl) {
        if (!bl && this.getSelectedObjectAt(mouseEvent) != null) {
            return TRANSLATE_MOUSE_CURSOR;
        }
        return null;
    }

    private SVGObject getSelectedObjectAt(MouseEvent mouseEvent) {
        SVGObject sVGObject;
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0 && (sVGObject = sVGObjectArray[0]).getScreenBBox().contains(mouseEvent.getPoint())) {
            return sVGObject;
        }
        return null;
    }

    private SVGObject getSelectedObject() {
        SVGObject[] sVGObjectArray = this.m_sceneMgr.getSelected();
        if (sVGObjectArray != null && sVGObjectArray.length > 0) {
            return sVGObjectArray[0];
        }
        return null;
    }

    static int[] getCoordDiff(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        if (aWTEvent.getID() == 401 && (keyEvent = (KeyEvent)aWTEvent).getModifiers() == 0) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    return DIFF_DOWN;
                }
                case 37: {
                    return DIFF_LEFT;
                }
                case 39: {
                    return DIFF_RIGHT;
                }
                case 38: {
                    return DIFF_UP;
                }
            }
        }
        return null;
    }
}

