/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import java.awt.Dimension;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;

public class ScreenSizeHelper {
    public static Dimension getCurrentDeviceScreenSize(FileObject fileObject, String string) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null || !(project instanceof J2MEProject)) {
            return new Dimension(320, 240);
        }
        Dimension dimension = ScreenSizeHelper.getDeviceScreenSizeFromProject((J2MEProject)project, string);
        if (dimension == null || dimension.getHeight() < 10.0 || dimension.getWidth() < 10.0) {
            return new Dimension(320, 240);
        }
        return dimension;
    }

    private static Dimension getDeviceScreenSizeFromProject(J2MEProject j2MEProject, String string) {
        AntProjectHelper antProjectHelper = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper projectConfigurationsHelper = j2MEProject.getConfigurationHelper();
        String string2 = string;
        String string3 = ScreenSizeHelper.evaluateProperty(editableProperties, "platform.active", string2);
        String string4 = ScreenSizeHelper.evaluateProperty(editableProperties, "platform.device", string2);
        if (string3 != null && string4 != null) {
            J2MEPlatform.Device[] deviceArray;
            JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            J2MEPlatform j2MEPlatform = null;
            if (javaPlatformArray != null) {
                for (int i = 0; i < javaPlatformArray.length; ++i) {
                    JavaPlatform javaPlatform = javaPlatformArray[i];
                    if (!(javaPlatform instanceof J2MEPlatform) || !string3.equals(((J2MEPlatform)javaPlatform).getName())) continue;
                    j2MEPlatform = (J2MEPlatform)javaPlatform;
                    break;
                }
            }
            if (j2MEPlatform != null && (deviceArray = j2MEPlatform.getDevices()) != null) {
                for (int i = 0; i < deviceArray.length; ++i) {
                    J2MEPlatform.Screen screen;
                    J2MEPlatform.Device device = deviceArray[i];
                    if (!string4.equals(device.getName()) || (screen = device.getScreen()) == null) continue;
                    Integer n = screen.getHeight();
                    Integer n2 = screen.getWidth();
                    if (n == null || n2 == null) continue;
                    return new Dimension(n2, n);
                }
            }
        }
        return null;
    }

    private static String evaluateProperty(EditableProperties editableProperties, String string, String string2) {
        if (string2 == null) {
            return editableProperties.getProperty(string);
        }
        String string3 = editableProperties.getProperty("configs." + string2 + "." + string);
        return string3 != null ? string3 : ScreenSizeHelper.evaluateProperty(editableProperties, string, null);
    }
}

