/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.items.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.openide.text.ActiveEditorDrop;

public abstract class SVGComponentDrop
implements ActiveEditorDrop {
    protected static final String PATTERN = "%%";
    private static final String X_COORDINATE_PATTERN = "%%COORDINATE_X%%";
    private static final String Y_COORDINATE_PATTERN = "%%COORDINATE_Y%%";
    private SVGDataObject mySvgDataObject;
    private float[] myPoint;

    protected abstract boolean doTransfer(SVGDataObject var1);

    protected abstract boolean doTransfer(JTextComponent var1);

    public static SVGComponentDrop getDefault(String string) {
        return new Default(string);
    }

    protected static String loadSnippetString(Class clazz, String string) throws IOException {
        String string2;
        InputStream inputStream = clazz.getResourceAsStream(string);
        assert (inputStream != null) : string + " resource Input Stream is null";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected static void insertToTextComponent(String string, JTextComponent jTextComponent) {
        SVGPaletteItemDataObject.insertToTextComponent(string, jTextComponent);
    }

    public boolean handleTransfer(SVGDataObject sVGDataObject, float[] fArray) {
        if (sVGDataObject == null) {
            SceneManager.log(Level.INFO, "SVGDataObject not found.");
            return false;
        }
        this.mySvgDataObject = sVGDataObject;
        this.myPoint = fArray;
        return this.doTransfer(sVGDataObject);
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        this.myPoint = new float[]{0.0f, 0.0f};
        return this.doTransfer(jTextComponent);
    }

    protected float[] getDropPoint() {
        return this.myPoint;
    }

    protected void setSelection(String string) {
        if (this.mySvgDataObject != null) {
            this.mySvgDataObject.getSceneManager().setSelection(string, true);
        }
    }

    protected String replaceCoordinates(String string) {
        return string.replace(X_COORDINATE_PATTERN, String.valueOf(this.myPoint[0])).replace(Y_COORDINATE_PATTERN, String.valueOf(this.myPoint[1]));
    }

    private static class Default
    extends SVGComponentDrop {
        private String mySnippet;

        public Default(String string) {
            this.mySnippet = string;
        }

        protected boolean doTransfer(SVGDataObject sVGDataObject) {
            try {
                if (this.mySnippet != null) {
                    String string = this.replaceCoordinates(this.mySnippet);
                    String string2 = sVGDataObject.getModel().mergeImage(string, false);
                    this.setSelection(string2);
                }
                return true;
            }
            catch (Exception exception) {
                SceneManager.error("Error during image merge", exception);
                return false;
            }
        }

        protected boolean doTransfer(JTextComponent jTextComponent) {
            if (this.mySnippet != null) {
                String string = this.replaceCoordinates(this.mySnippet);
                Default.insertToTextComponent(string, jTextComponent);
            }
            return true;
        }
    }
}

