/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteFactory;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.netbeans.modules.xml.multiview.AbstractMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SVGViewMultiViewElement
extends AbstractMultiViewElement {
    private static final long serialVersionUID = 7526471457562007148L;
    private static final Logger LOG = Logger.getLogger(SVGViewMultiViewElement.class.getName());
    private transient SVGViewTopComponent svgView = null;

    public SVGViewMultiViewElement(SVGDataObject sVGDataObject) {
        super((XmlMultiViewDataObject)sVGDataObject);
    }

    public void componentActivated() {
        if (this.svgView != null) {
            this.svgView.componentActivated();
        }
    }

    public void componentDeactivated() {
        if (this.svgView != null) {
            this.svgView.componentDeactivated();
        }
    }

    public void componentClosed() {
        super.componentClosed();
        if (this.svgView != null) {
            this.svgView.componentClosed();
        }
    }

    public void componentHidden() {
        if (this.svgView != null) {
            this.svgView.componentHidden();
            this.getDataObject().setMultiViewElement(null);
        }
    }

    public void componentOpened() {
        super.componentOpened();
        SVGFileModel sVGFileModel = this.getDataObject().getModel();
        if (sVGFileModel.getModel() != null) {
            sVGFileModel.attachToOpenedDocument();
            if (this.svgView != null) {
                this.svgView.componentOpened();
            }
        } else {
            LOG.log(Level.WARNING, "Can not attachToOpenedDocument. document model is not loaded.");
        }
    }

    public void componentShowing() {
        this.svgView.onShow();
        this.getDataObject().setMultiViewElement((MultiViewElement)this);
        this.dObj.setLastOpenView(1);
    }

    public Lookup getLookup() {
        Lookup lookup = null;
        try {
            lookup = Lookups.singleton((Object)SVGPaletteFactory.getPalette());
        }
        catch (IOException iOException) {
            SceneManager.error("Palette could not be created.", iOException);
        }
        Lookup[] lookupArray = lookup == null ? new Lookup[]{this.svgView.getLookup(), this.dObj.getNodeDelegate().getLookup()} : new Lookup[]{this.svgView.getLookup(), lookup, this.dObj.getNodeDelegate().getLookup()};
        return new ProxyLookup(lookupArray);
    }

    public JComponent getToolbarRepresentation() {
        this.getVisualRepresentation();
        return this.svgView.getToolbar();
    }

    public synchronized JComponent getVisualRepresentation() {
        if (this.svgView == null) {
            this.svgView = new SVGViewTopComponent((SVGDataObject)this.dObj);
        }
        return this.svgView;
    }

    private SceneManager getSceneManager() {
        return this.getDataObject().getSceneManager();
    }

    private SVGDataObject getDataObject() {
        return (SVGDataObject)this.dObj;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
            this.getSceneManager().deserialize(objectInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        try {
            objectOutputStream.defaultWriteObject();
            this.getSceneManager().serialize(objectOutputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

