/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbrefactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbrefactoring.EjbRefactoringPlugin;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        FileObject fileObject = this.getRefactoringSource(abstractRefactoring);
        if (fileObject == null) {
            return null;
        }
        List<EjbJar> list = this.getEjbJars(fileObject);
        if (list.isEmpty()) {
            return null;
        }
        String string = this.getEjbJarPaths(list);
        String string2 = null;
        string2 = abstractRefactoring instanceof RenameRefactoring ? "TXT_EjbJarRenameWarning" : (abstractRefactoring instanceof SafeDeleteRefactoring ? "TXT_EjbJarSafeDeleteWarning" : (abstractRefactoring instanceof MoveRefactoring ? "TXT_EjbJarMoveClassWarning" : (abstractRefactoring instanceof WhereUsedQuery ? "TXT_EjbJarWhereUsedWarning" : "TXT_EjbJarGeneralWarning")));
        return new EjbRefactoringPlugin(NbBundle.getMessage(EjbRefactoringFactory.class, (String)string2, (Object)string));
    }

    private String getEjbJarPaths(List<EjbJar> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EjbJar> iterator = list.iterator();
        while (iterator.hasNext()) {
            EjbJar ejbJar = iterator.next();
            String string = FileUtil.getFileDisplayName((FileObject)ejbJar.getDeploymentDescriptor());
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private FileObject getRefactoringSource(AbstractRefactoring abstractRefactoring) {
        FileObject fileObject = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject != null) {
            return fileObject;
        }
        TreePathHandle treePathHandle = (TreePathHandle)abstractRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return treePathHandle.getFileObject();
        }
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)abstractRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            return nonRecursiveFolder.getFolder();
        }
        return null;
    }

    private List<EjbJar> getEjbJars(FileObject fileObject) {
        ArrayList<EjbJar> arrayList = new ArrayList<EjbJar>();
        for (EjbJar ejbJar : EjbRefactoringFactory.getRelevantEjbModules(fileObject)) {
            FileObject fileObject2 = ejbJar.getDeploymentDescriptor();
            if (fileObject2 == null) continue;
            arrayList.add(ejbJar);
        }
        return arrayList;
    }

    private static Collection<EjbJar> getRelevantEjbModules(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ArrayList<EjbJar> arrayList = new ArrayList<EjbJar>();
        ArrayList<Project> arrayList2 = new ArrayList<Project>();
        if (project != null) {
            EjbJar ejbJar = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
            if (ejbJar == null) {
                return Collections.EMPTY_SET;
            }
            arrayList2.add(project);
            for (Project project2 : OpenProjects.getDefault().getOpenProjects()) {
                J2eeModuleProvider j2eeModuleProvider;
                Object object;
                Object object2;
                Object object3 = project2.getLookup().lookup(J2eeApplicationProvider.class);
                if (object3 != null && (object2 = (object = (J2eeApplicationProvider)object3).getChildModuleProviders()) != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(object2).contains(j2eeModuleProvider)) {
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        FileObject fileObject2;
                        Project project3;
                        FileObject[] fileObjectArray = object2[i].getSourceRoots();
                        if (fileObjectArray == null || fileObjectArray.length <= 0 || (project3 = FileOwnerQuery.getOwner((FileObject)(fileObject2 = fileObjectArray[0]))) == null || arrayList2.contains(project3)) continue;
                        arrayList2.add(project3);
                    }
                }
                if ((object = project2.getLookup().lookup(SubprojectProvider.class)) == null || !(object instanceof SubprojectProvider) || !(object2 = ((SubprojectProvider)object).getSubprojects()).contains(project) || (j2eeModuleProvider = EjbJar.getEjbJar((FileObject)project2.getProjectDirectory())) == null || arrayList2.contains(project2)) continue;
                arrayList2.add(project2);
            }
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            Project[] projectArray = (Project[])arrayList2.get(i);
            EjbJar ejbJar = EjbJar.getEjbJar((FileObject)projectArray.getProjectDirectory());
            if (ejbJar == null) continue;
            arrayList.add(ejbJar);
        }
        return arrayList;
    }
}

