/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.disk.FilesAccessStrategy;
import org.netbeans.modules.cnd.repository.disk.RepositoryCacheMap;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.sfs.BufferedRWAccess;
import org.netbeans.modules.cnd.repository.sfs.statistics.BaseStatistics;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesAccessStrategyImpl
implements FilesAccessStrategy {
    private final Object cacheLock = new String("Repository file cache lock");
    private RepositoryCacheMap<String, ConcurrentFileRWAccess> nameToFileCache = new RepositoryCacheMap(OPEN_FILES_LIMIT);
    private static final int OPEN_FILES_LIMIT = Integer.getInteger("cnd.repository.files.cache", 20);
    private static final FilesAccessStrategyImpl instance = new FilesAccessStrategyImpl();
    private static final boolean TRACE_CONFLICTS = Boolean.getBoolean("cnd.repository.trace.conflicts");
    private int readCnt = 0;
    private int readHitCnt = 0;
    private int writeCnt = 0;
    private int writeHitCnt = 0;
    BaseStatistics<String> writeStatistics;
    BaseStatistics<String> readStatistics;
    private static final char SEPARATOR_CHAR = '-';

    private FilesAccessStrategyImpl() {
        if (Stats.multyFileStatistics) {
            this.resetStatistics();
        }
    }

    public static final FilesAccessStrategy getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Persistent read(Key key) throws IOException {
        ++this.readCnt;
        if (Stats.multyFileStatistics) {
            this.readStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        ConcurrentFileRWAccess concurrentFileRWAccess = null;
        try {
            concurrentFileRWAccess = this.getFile(key, true);
            if (concurrentFileRWAccess != null) {
                PersistentFactory persistentFactory = key.getPersistentFactory();
                assert (persistentFactory != null);
                long l = concurrentFileRWAccess.size();
                Persistent persistent = concurrentFileRWAccess.read(persistentFactory, 0L, (int)l);
                return persistent;
            }
        }
        finally {
            if (concurrentFileRWAccess != null) {
                concurrentFileRWAccess.lock.readLock().unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Key key, Persistent persistent) throws IOException {
        ++this.writeCnt;
        if (Stats.multyFileStatistics) {
            this.writeStatistics.consume(FilesAccessStrategyImpl.getBriefClassName(key), 1);
        }
        ConcurrentFileRWAccess concurrentFileRWAccess = null;
        try {
            concurrentFileRWAccess = this.getFile(key, false);
            assert (concurrentFileRWAccess != null);
            if (concurrentFileRWAccess != null) {
                PersistentFactory persistentFactory = key.getPersistentFactory();
                assert (persistentFactory != null);
                int n = concurrentFileRWAccess.write(persistentFactory, persistent, 0L);
                concurrentFileRWAccess.truncate(n);
            }
        }
        finally {
            if (concurrentFileRWAccess != null) {
                concurrentFileRWAccess.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentFileRWAccess getFile(Key key, boolean bl) throws IOException {
        assert (key != null);
        String string = FilesAccessStrategyImpl.resolveFileName(key);
        assert (string != null);
        ConcurrentFileRWAccess concurrentFileRWAccess = null;
        boolean bl2 = false;
        while (true) {
            Object object = this.cacheLock;
            synchronized (object) {
                concurrentFileRWAccess = this.nameToFileCache.get(string);
                if (concurrentFileRWAccess == null) {
                    String string2;
                    File file;
                    File file2 = new File(string);
                    String string3 = ((Object)key.getUnit()).toString();
                    if (file2.exists()) {
                        concurrentFileRWAccess = new ConcurrentFileRWAccess(file2, string3);
                        this.putFile(string, concurrentFileRWAccess);
                    } else if (!bl && ((file = new File(string2 = file2.getParent())).exists() || file.mkdirs())) {
                        concurrentFileRWAccess = new ConcurrentFileRWAccess(file2, string3);
                        this.putFile(string, concurrentFileRWAccess);
                    }
                } else if (bl) {
                    ++this.readHitCnt;
                } else {
                    ++this.writeHitCnt;
                }
            }
            if (concurrentFileRWAccess == null) break;
            try {
                if (bl) {
                    concurrentFileRWAccess.lock.readLock().lock();
                } else {
                    concurrentFileRWAccess.lock.writeLock().lock();
                }
                if (concurrentFileRWAccess.getFD().valid()) {
                    bl2 = true;
                    break;
                }
                if (!TRACE_CONFLICTS) continue;
                System.out.printf("invalid file descriptir when %s %s\n", bl ? "reading" : "writing", string);
                continue;
            }
            finally {
                if (bl2) continue;
                if (bl) {
                    concurrentFileRWAccess.lock.readLock().unlock();
                    continue;
                }
                concurrentFileRWAccess.lock.writeLock().unlock();
                continue;
            }
            break;
        }
        return concurrentFileRWAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFile(String string, ConcurrentFileRWAccess concurrentFileRWAccess) throws IOException {
        ConcurrentFileRWAccess concurrentFileRWAccess2 = null;
        Object object = this.cacheLock;
        synchronized (object) {
            concurrentFileRWAccess2 = this.nameToFileCache.put(string, concurrentFileRWAccess);
        }
        if (concurrentFileRWAccess2 != null) {
            try {
                concurrentFileRWAccess2.lock.writeLock().lock();
                if (concurrentFileRWAccess2.getFD().valid()) {
                    concurrentFileRWAccess2.close();
                }
            }
            finally {
                concurrentFileRWAccess2.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Key key) throws IOException {
        String string = FilesAccessStrategyImpl.resolveFileName(key);
        assert (string != null);
        ConcurrentFileRWAccess concurrentFileRWAccess = null;
        Object object = this.cacheLock;
        synchronized (object) {
            concurrentFileRWAccess = this.nameToFileCache.remove(string);
        }
        if (concurrentFileRWAccess != null) {
            try {
                concurrentFileRWAccess.lock.writeLock().lock();
                if (concurrentFileRWAccess.getFD().valid()) {
                    concurrentFileRWAccess.close();
                }
            }
            finally {
                concurrentFileRWAccess.lock.writeLock().unlock();
            }
        }
        object = new File(string);
        ((File)object).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeUnit(final String string) throws IOException {
        Collection<ConcurrentFileRWAccess> collection;
        Filter<ConcurrentFileRWAccess> filter = new Filter<ConcurrentFileRWAccess>(){

            @Override
            public boolean accept(ConcurrentFileRWAccess concurrentFileRWAccess) {
                return concurrentFileRWAccess.unit.equals(string);
            }
        };
        Iterator<ConcurrentFileRWAccess> iterator = this.cacheLock;
        synchronized (iterator) {
            collection = this.nameToFileCache.remove(filter);
        }
        if (collection != null) {
            for (ConcurrentFileRWAccess concurrentFileRWAccess : collection) {
                try {
                    concurrentFileRWAccess.lock.writeLock().lock();
                    if (!concurrentFileRWAccess.getFD().valid()) continue;
                    concurrentFileRWAccess.close();
                }
                finally {
                    concurrentFileRWAccess.lock.writeLock().unlock();
                }
            }
        }
        if (Stats.multyFileStatistics) {
            this.printStatistics();
            this.resetStatistics();
        }
    }

    void printStatistics() {
        System.out.printf("\nFileAccessStrategy statistics: reads %d hits %d (%d%%) writes %d hits %d (%d%%)\n", this.readCnt, this.readHitCnt, FilesAccessStrategyImpl.percentage(this.readHitCnt, this.readCnt), this.writeCnt, this.writeHitCnt, FilesAccessStrategyImpl.percentage(this.writeHitCnt, this.writeCnt));
        if (this.writeStatistics != null) {
            this.readStatistics.print(System.out);
        }
        if (this.writeStatistics != null) {
            this.writeStatistics.print(System.out);
        }
    }

    private static int percentage(int n, int n2) {
        return n2 == 0 ? 0 : n * 100 / n2;
    }

    private void resetStatistics() {
        this.writeStatistics = new BaseStatistics("Writes", 2);
        this.readStatistics = new BaseStatistics("Reads", 2);
        this.writeHitCnt = 0;
        this.writeCnt = 0;
        this.readHitCnt = 0;
        this.readCnt = 0;
    }

    private static String resolveFileName(Key key) throws IOException {
        int n;
        assert (key != null);
        int n2 = key.getDepth();
        StringBuffer stringBuffer = new StringBuffer("");
        if (n2 == 0) {
            stringBuffer.append(key.getUnit());
        } else {
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(key.getAt(n));
                stringBuffer.append('-');
            }
        }
        for (n = 0; n < key.getSecondaryDepth(); ++n) {
            stringBuffer.append(key.getSecondaryAt(n) + 45);
        }
        String string = stringBuffer.toString();
        string = URLEncoder.encode(string, Stats.ENCODING);
        string = StorageAllocator.getInstance().getUnitStorageName(((Object)key.getUnit()).toString()) + StorageAllocator.getInstance().reduceString(string);
        return string;
    }

    private static String getBriefClassName(Object object) {
        if (object == null) {
            return "null";
        }
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<String> testGetCacheFileNames() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.nameToFileCache.keys();
        }
    }

    int getReadHitCnt() {
        return this.readHitCnt;
    }

    int getReadHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.readHitCnt, this.readCnt);
    }

    int getWriteHitCnt() {
        return this.writeHitCnt;
    }

    int getWriteHitPercentage() {
        return FilesAccessStrategyImpl.percentage(this.writeHitCnt, this.writeCnt);
    }

    int getCacheSize() {
        return this.nameToFileCache.size();
    }

    private static class ConcurrentFileRWAccess
    extends BufferedRWAccess {
        public final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        public final String unit;

        public ConcurrentFileRWAccess(File file, String string) throws IOException {
            super(file);
            this.unit = string;
        }
    }
}

