/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryCache {
    private static final boolean STATISTIC = false;
    private static final int SLICE_SIZE = 19;
    private final SlicedMap cache = new SlicedMap();
    private final Lock refQueueLock = new ReentrantLock();
    private final ReferenceQueue<Persistent> refQueue = new ReferenceQueue();
    private int readCnt = 0;
    private int readHitCnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hang(Key key, Persistent persistent) {
        Slice slice = this.cache.getSilce(key);
        slice.w.lock();
        try {
            slice.storage.put(key, persistent);
        }
        finally {
            slice.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Key key, Persistent persistent) {
        Slice slice = this.cache.getSilce(key);
        SoftValue softValue = new SoftValue(persistent, key, this.refQueue);
        slice.w.lock();
        try {
            slice.storage.put(key, softValue);
        }
        finally {
            slice.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent putIfAbsent(Key key, Persistent persistent) {
        Persistent persistent2 = null;
        Slice slice = this.cache.getSilce(key);
        SoftValue softValue = new SoftValue(persistent, key, this.refQueue);
        slice.w.lock();
        try {
            Object v = slice.storage.get(key);
            if (v instanceof SoftReference) {
                persistent2 = (Persistent)((SoftReference)v).get();
            } else if (v instanceof Persistent) {
                persistent2 = (Persistent)v;
            } else if (v != null) {
                System.err.println("unexpected value " + v + " for key " + key);
            }
            if (persistent2 == null) {
                slice.storage.put(key, softValue);
            }
        }
        finally {
            slice.w.unlock();
        }
        this.processQueue();
        return persistent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent get(Key key) {
        Object v;
        Slice slice = this.cache.getSilce(key);
        slice.r.lock();
        try {
            v = slice.storage.get(key);
        }
        finally {
            slice.r.unlock();
        }
        if (v instanceof Persistent) {
            return (Persistent)v;
        }
        if (v instanceof SoftReference) {
            Persistent persistent = (Persistent)((SoftReference)v).get();
            return persistent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) {
        Slice slice = this.cache.getSilce(key);
        slice.w.lock();
        try {
            slice.storage.remove(key);
        }
        finally {
            slice.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSoftRefs() {
        this.processQueue();
        for (int i = 0; i < 19; ++i) {
            HashSet hashSet;
            Slice slice = this.cache.getSilce(i);
            slice.r.lock();
            try {
                hashSet = new HashSet(slice.storage.keySet());
            }
            finally {
                slice.r.unlock();
            }
            for (Key key : hashSet) {
                slice.w.lock();
                try {
                    Object v = slice.storage.get(key);
                    if (v == null || v instanceof Persistent) continue;
                    slice.storage.remove(key);
                }
                finally {
                    slice.w.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        if (this.refQueueLock.tryLock()) {
            try {
                SoftValue softValue;
                while ((softValue = (SoftValue)this.refQueue.poll()) != null) {
                    Slice slice = this.cache.getSilce(softValue.key);
                    slice.w.lock();
                    try {
                        Object v = slice.storage.get(softValue.key);
                        if (v == null || !(v instanceof SoftReference) || ((SoftReference)v).get() != null) continue;
                        Object v2 = slice.storage.remove(softValue.key);
                        assert (v == v2);
                    }
                    finally {
                        slice.w.unlock();
                    }
                }
            }
            finally {
                this.refQueueLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<Key, Persistent>> clearHungObjects() {
        this.processQueue();
        ArrayList<Pair<Key, Persistent>> arrayList = new ArrayList<Pair<Key, Persistent>>();
        for (int i = 0; i < 19; ++i) {
            HashSet hashSet;
            Slice slice = this.cache.getSilce(i);
            slice.r.lock();
            try {
                hashSet = new HashSet(slice.storage.keySet());
            }
            finally {
                slice.r.unlock();
            }
            for (Key key : hashSet) {
                Object v;
                slice.r.lock();
                try {
                    v = slice.storage.get(key);
                }
                finally {
                    slice.r.unlock();
                }
                if (!(v instanceof Persistent)) continue;
                arrayList.add(new Pair<Key, Persistent>(key, (Persistent)v));
                slice.w.lock();
                try {
                    slice.storage.remove(key);
                }
                finally {
                    slice.w.unlock();
                }
            }
        }
        return arrayList;
    }

    private void printStatistics(String string) {
        int n = this.readCnt == 0 ? 0 : this.readHitCnt * 100 / this.readCnt;
        System.out.printf("\n\nMemory cache statistics %s: %d reads,  %d hits (%d%%)\n\n", string, this.readCnt, this.readHitCnt, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printDistribution() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        TreeMap<String, Integer> treeMap2 = new TreeMap<String, Integer>();
        int n = 0;
        int n2 = 0;
        for (Slice slice : this.cache.slices) {
            slice.r.lock();
            try {
                n += slice.storage.size();
                for (Map.Entry entry : slice.storage.entrySet()) {
                    Key key = (Key)entry.getKey();
                    Object object = entry.getValue();
                    boolean bl = false;
                    if (object != null && object instanceof SoftReference) {
                        bl = true;
                        object = ((SoftReference)object).get();
                    }
                    String string = key.getClass().getName();
                    if (object == null) {
                        string = bl ? string + "-soft null" : string + "-null";
                        ++n2;
                    } else {
                        string = bl ? string + "-soft " + object.getClass().getName() : string + "-" + object.getClass().getName();
                    }
                    Integer n3 = bl ? (Integer)treeMap2.get(string) : (Integer)treeMap.get(string);
                    n3 = n3 == null ? Integer.valueOf(1) : Integer.valueOf(n3 + 1);
                    if (bl) {
                        treeMap2.put(string, n3);
                        continue;
                    }
                    treeMap.put(string, n3);
                }
            }
            finally {
                slice.r.unlock();
            }
        }
        System.err.println("\tMemCache of size " + n + " with null " + n2 + " objects");
        System.err.println("\tSoft memory cache");
        for (Map.Entry entry : treeMap2.entrySet()) {
            System.err.println("\t" + (String)entry.getKey() + "=" + entry.getValue());
        }
        System.err.println("\tHard memory cache");
        for (Map.Entry entry : treeMap.entrySet()) {
            System.err.println("\t" + (String)entry.getKey() + "=" + entry.getValue());
        }
    }

    private static final class SlicedMap {
        private final Slice[] slices = new Slice[19];

        private SlicedMap() {
            for (int i = 0; i < 19; ++i) {
                this.slices[i] = new Slice();
            }
        }

        private Slice getSilce(Key key) {
            int n = key.hashCode() % 19;
            if (n < 0) {
                n += 19;
            }
            return this.slices[n];
        }

        private Slice getSilce(int n) {
            return this.slices[n];
        }
    }

    private static final class Slice {
        private final Map<Key, Object> storage = new HashMap<Key, Object>(256);
        private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
        private final Lock w = this.cacheLock.writeLock();
        private final Lock r = this.cacheLock.readLock();

        private Slice() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValue<T>
    extends SoftReference<T> {
        private final Key key;

        private SoftValue(T t, Key key, ReferenceQueue<T> referenceQueue) {
            super(t, referenceQueue);
            this.key = key;
        }
    }
}

