/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryQueue
extends KeyValueQueue<Key, Persistent> {
    @Override
    protected boolean needsTiming() {
        return Stats.queueTiming;
    }

    @Override
    protected boolean needsTrace() {
        return Stats.queueTrace;
    }

    @Override
    protected String getTraceName() {
        return "RepositoryQueue@" + this.hashCode();
    }

    @Override
    protected void doReplaceAddLast(Key key, Persistent persistent, KeyValueQueue.Entry entry) {
        super.doReplaceAddLast(key, persistent, entry);
        this.queue.remove(entry);
        this.queue.addLast(entry);
    }

    public void onIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyValueQueue.Entry> clearQueue(Filter filter) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<KeyValueQueue.Entry> arrayList = new ArrayList<KeyValueQueue.Entry>();
            for (KeyValueQueue.Entry entry : this.map.values()) {
                if (!filter.accept((Key)entry.getKey(), (Persistent)entry.getValue())) continue;
                arrayList.add(entry);
            }
            for (KeyValueQueue.Entry entry : arrayList) {
                this.remove(entry.getKey());
            }
            return arrayList;
        }
    }

    public static interface Filter {
        public boolean accept(Key var1, Persistent var2);
    }
}

