/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.statistics;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class FileStatistics {
    private Map<Key, ChunkStatistics> map;

    public FileStatistics() {
        if (Stats.fileStatisticsLevel > 0) {
            this.map = new HashMap<Key, ChunkStatistics>();
        }
    }

    private ChunkStatistics getStat(Key key) {
        ChunkStatistics chunkStatistics = this.map.get(key);
        if (chunkStatistics == null) {
            chunkStatistics = new ChunkStatistics();
            this.map.put(key, chunkStatistics);
        }
        return chunkStatistics;
    }

    public int getReadCount(Key key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((Key)key).readCount;
    }

    public void incrementReadCount(Key key) {
        if (Stats.fileStatisticsLevel > 0) {
            ++this.getStat((Key)key).readCount;
        }
    }

    public int getWriteCount(Key key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((Key)key).writeCount;
    }

    public void incrementWriteCount(Key key, int n, int n2) {
        if (Stats.fileStatisticsLevel > 0) {
            ChunkStatistics chunkStatistics = this.getStat(key);
            ++chunkStatistics.writeCount;
            if (n > 0 && n2 != n) {
                ++chunkStatistics.resized;
            }
        }
    }

    public void removeNotify(Key key) {
        if (Stats.fileStatisticsLevel > 0) {
            this.map.remove(key);
        }
    }

    private static class ChunkStatistics {
        public int readCount;
        public int writeCount;
        public int resized;

        private ChunkStatistics() {
        }
    }
}

