/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Evaluator;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.queries.AccessibilityQueryImpl;
import org.netbeans.modules.apisupport.project.queries.AntArtifactProviderImpl;
import org.netbeans.modules.apisupport.project.queries.ClassPathProviderImpl;
import org.netbeans.modules.apisupport.project.queries.FileEncodingQueryImpl;
import org.netbeans.modules.apisupport.project.queries.JavadocForBinaryImpl;
import org.netbeans.modules.apisupport.project.queries.ModuleProjectClassPathExtender;
import org.netbeans.modules.apisupport.project.queries.SourceForBinaryImpl;
import org.netbeans.modules.apisupport.project.queries.SourceLevelQueryImpl;
import org.netbeans.modules.apisupport.project.queries.SubprojectProviderImpl;
import org.netbeans.modules.apisupport.project.queries.TemplateAttributesProvider;
import org.netbeans.modules.apisupport.project.queries.UnitTestForSourceQueryImpl;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.modules.apisupport.project.ui.ModuleOperations;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbModuleProject
implements Project {
    public static final String NB_PROJECT_ICON_PATH = "org/netbeans/modules/apisupport/project/resources/module.png";
    private static final Icon NB_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/apisupport/project/resources/module.png", (boolean)false);
    public static final String SOURCES_TYPE_JAVAHELP = "javahelp";
    static final String[] COMMON_TEST_TYPES = new String[]{"unit", "qa-functional"};
    private final AntProjectHelper helper;
    private final Evaluator eval;
    private final Lookup lookup;
    private final InstanceContent ic;
    private Map<FileObject, Element> extraCompilationUnits;
    private final GeneratedFilesHelper genFilesHelper;
    private final NbModuleProviderImpl typeProvider;
    private final Map<String, FileObject> directoryCache = new WeakHashMap<String, FileObject>();
    private ClassPath[] boot;
    private ClassPath[] source;
    private ClassPath[] compile;

    public NbModuleProject(AntProjectHelper antProjectHelper) throws IOException {
        String string22;
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        for (int i = 4; i < 10; ++i) {
            if (auxiliaryConfiguration.getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/" + i, true) == null) continue;
            throw (IOException)Exceptions.attachLocalizedMessage((Throwable)new IOException("too new"), (String)NbBundle.getMessage(NbModuleProject.class, (String)"NbModuleProject.too_new", (Object)FileUtil.getFileDisplayName((FileObject)antProjectHelper.getProjectDirectory())));
        }
        this.helper = antProjectHelper;
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        Util.err.log("Loading project in " + this.getProjectDirectory());
        if (this.getCodeNameBase() == null) {
            throw new IOException("Misconfigured project in " + FileUtil.getFileDisplayName((FileObject)this.getProjectDirectory()) + " has no defined <code-name-base>");
        }
        this.typeProvider = new NbModuleProviderImpl();
        if (this.typeProvider.getModuleType() == NbModuleProvider.NETBEANS_ORG && ModuleList.findNetBeansOrg(this.getProjectDirectoryFile()) == null) {
            throw new IOException("netbeans.org-type module requires at least nbbuild: " + FileUtil.getFileDisplayName((FileObject)antProjectHelper.getProjectDirectory()));
        }
        this.eval = new Evaluator(this, this.typeProvider);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add("${src.dir}/*.java");
        arrayList2.add("${build.classes.dir}/*.class");
        for (String string22 : this.supportedTestTypes()) {
            arrayList.add("${test." + string22 + ".src.dir}/*.java");
            arrayList2.add("${build.test." + string22 + ".classes.dir}/*.class");
        }
        FileBuiltQueryImplementation fileBuiltQueryImplementation = antProjectHelper.createGlobFileBuiltQuery((PropertyEvaluator)this.eval, arrayList.toArray(new String[0]), arrayList2.toArray(new String[0]));
        string22 = new SourcesHelper((Project)this, antProjectHelper, (PropertyEvaluator)this.eval);
        string22.addPrincipalSourceRoot("${src.dir}", NbBundle.getMessage(NbModuleProject.class, (String)"LBL_source_packages"), null, null);
        for (String object : this.supportedTestTypes()) {
            string22.addPrincipalSourceRoot("${test." + object + ".src.dir}", NbBundle.getMessage(NbModuleProject.class, (String)("LBL_" + object + "_test_packages")), null, null);
        }
        string22.addTypedSourceRoot("${src.dir}", "java", NbBundle.getMessage(NbModuleProject.class, (String)"LBL_source_packages"), null, null);
        for (String string : this.supportedTestTypes()) {
            string22.addTypedSourceRoot("${test." + string + ".src.dir}", "java", NbBundle.getMessage(NbModuleProject.class, (String)("LBL_" + string + "_test_packages")), null, null);
        }
        if (antProjectHelper.resolveFileObject("javahelp/manifest.mf") == null) {
            string22.addTypedSourceRoot(SOURCES_TYPE_JAVAHELP, SOURCES_TYPE_JAVAHELP, NbBundle.getMessage(NbModuleProject.class, (String)"LBL_javahelp_packages"), null, null);
        }
        for (Map.Entry entry : this.getExtraCompilationUnits().entrySet()) {
            Element element = Util.findElement((Element)entry.getValue(), "package-root", "http://www.netbeans.org/ns/nb-module-project/3");
            String string = Util.findText(element);
            string22.addTypedSourceRoot(string, "java", ((FileObject)entry.getKey()).getNameExt(), null, null);
        }
        string22.registerExternalRoots(0);
        this.ic = new InstanceContent();
        this.lookup = this.createLookup(new Info(), auxiliaryConfiguration, antProjectHelper, fileBuiltQueryImplementation, (SourcesHelper)string22);
    }

    public String toString() {
        return "NbModuleProject[" + this.getProjectDirectory() + "]";
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void refreshLookup() {
        if (this.getModuleType() == NbModuleProvider.NbModuleType.SUITE_COMPONENT) {
            if (this.lookup.lookup(SuiteProvider.class) == null) {
                this.ic.add((Object)new SuiteProviderImpl());
            }
        } else {
            SuiteProvider suiteProvider = (SuiteProvider)this.lookup.lookup(SuiteProvider.class);
            if (suiteProvider != null) {
                this.ic.remove((Object)suiteProvider);
            }
        }
    }

    private Lookup createLookup(ProjectInformation projectInformation, AuxiliaryConfiguration auxiliaryConfiguration, AntProjectHelper antProjectHelper, FileBuiltQueryImplementation fileBuiltQueryImplementation, SourcesHelper sourcesHelper) {
        this.ic.add((Object)this);
        this.ic.add((Object)projectInformation);
        this.ic.add((Object)auxiliaryConfiguration);
        this.ic.add((Object)antProjectHelper.createCacheDirectoryProvider());
        this.ic.add((Object)antProjectHelper.createAuxiliaryProperties());
        this.ic.add((Object)new SavedHook());
        this.ic.add((Object)UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new OpenedHook()));
        this.ic.add((Object)new ModuleActions(this));
        this.ic.add((Object)new ClassPathProviderImpl(this));
        this.ic.add((Object)new SourceForBinaryImpl(this));
        this.ic.add((Object)new JavadocForBinaryImpl(this));
        this.ic.add((Object)new UnitTestForSourceQueryImpl(this));
        this.ic.add((Object)new ModuleLogicalView(this));
        this.ic.add((Object)new SubprojectProviderImpl(this));
        this.ic.add((Object)fileBuiltQueryImplementation);
        this.ic.add((Object)new AccessibilityQueryImpl(this));
        this.ic.add((Object)new SourceLevelQueryImpl(this));
        this.ic.add((Object)antProjectHelper.createSharabilityQuery(this.evaluator(), new String[0], new String[]{"build"}));
        this.ic.add((Object)sourcesHelper.createSources());
        this.ic.add((Object)new AntArtifactProviderImpl(this, antProjectHelper, this.evaluator()));
        this.ic.add((Object)new CustomizerProviderImpl(this, this.getHelper(), this.evaluator()));
        this.ic.add((Object)this.typeProvider);
        this.ic.add((Object)new PrivilegedTemplatesImpl());
        this.ic.add((Object)new ModuleProjectClassPathExtender(this));
        this.ic.add((Object)new LocalizedBundleInfoProvider());
        this.ic.add((Object)new ModuleOperations(this));
        this.ic.add((Object)LookupProviderSupport.createSourcesMerger());
        this.ic.add((Object)UILookupMergerSupport.createPrivilegedTemplatesMerger());
        this.ic.add((Object)UILookupMergerSupport.createRecommendedTemplatesMerger());
        this.ic.add((Object)new TemplateAttributesProvider(this.getHelper(), this.getModuleType() == NbModuleProvider.NbModuleType.NETBEANS_ORG));
        this.ic.add((Object)new FileEncodingQueryImpl());
        if (this.getModuleType() == NbModuleProvider.NbModuleType.SUITE_COMPONENT) {
            this.ic.add((Object)new SuiteProviderImpl());
        }
        AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        return LookupProviderSupport.createCompositeLookup((Lookup)abstractLookup, (String)"Projects/org-netbeans-modules-apisupport-project/Lookup");
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public File getProjectDirectoryFile() {
        return FileUtil.toFile((FileObject)this.getProjectDirectory());
    }

    public int getMinimumHarnessVersion() {
        if (this.helper.createAuxiliaryConfiguration().getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/2", true) != null) {
            return 1;
        }
        return 3;
    }

    public Element getPrimaryConfigurationData() {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                AuxiliaryConfiguration auxiliaryConfiguration = NbModuleProject.this.helper.createAuxiliaryConfiguration();
                Element element = auxiliaryConfiguration.getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/2", true);
                if (element != null) {
                    return Util.translateXML(element, "http://www.netbeans.org/ns/nb-module-project/3");
                }
                return NbModuleProject.this.helper.getPrimaryConfigurationData(true);
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                AuxiliaryConfiguration auxiliaryConfiguration = NbModuleProject.this.helper.createAuxiliaryConfiguration();
                if (auxiliaryConfiguration.getConfigurationFragment("data", "http://www.netbeans.org/ns/nb-module-project/2", true) != null) {
                    auxiliaryConfiguration.putConfigurationFragment(Util.translateXML(element, "http://www.netbeans.org/ns/nb-module-project/2"), true);
                } else {
                    NbModuleProject.this.helper.putPrimaryConfigurationData(element, true);
                }
                return null;
            }
        });
    }

    public String getSourceDirectoryPath() {
        return this.evaluator().getProperty("src.dir");
    }

    private NbModuleProvider.NbModuleType getModuleType() {
        Element element = this.getPrimaryConfigurationData();
        if (Util.findElement(element, "suite-component", "http://www.netbeans.org/ns/nb-module-project/3") != null) {
            return NbModuleProvider.SUITE_COMPONENT;
        }
        if (Util.findElement(element, "standalone", "http://www.netbeans.org/ns/nb-module-project/3") != null) {
            return NbModuleProvider.STANDALONE;
        }
        return NbModuleProvider.NETBEANS_ORG;
    }

    public FileObject getManifestFile() {
        return this.helper.resolveFileObject(this.evaluator().getProperty("manifest.mf"));
    }

    public Manifest getManifest() {
        return Util.getManifest(this.getManifestFile());
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    private FileObject getDir(String string) {
        if (this.directoryCache.containsKey(string)) {
            return this.directoryCache.get(string);
        }
        String string2 = this.evaluator().getProperty(string);
        if (string2 == null) {
            throw new NullPointerException("Property ${" + string + "} returned null, probably undefined.");
        }
        FileObject fileObject = this.helper.resolveFileObject(string2);
        this.directoryCache.put(string, fileObject);
        return fileObject;
    }

    public FileObject getSourceDirectory() {
        return this.getDir("src.dir");
    }

    public FileObject getTestSourceDirectory(String string) {
        return this.getDir("test." + string + ".src.dir");
    }

    public File getClassesDirectory() {
        String string = this.evaluator().getProperty("build.classes.dir");
        return string != null ? this.helper.resolveFile(string) : null;
    }

    public File getTestClassesDirectory(String string) {
        String string2 = this.evaluator().getProperty("build.test." + string + ".classes.dir");
        return string2 != null ? this.helper.resolveFile(string2) : null;
    }

    public FileObject getJavaHelpDirectory() {
        if (this.helper.resolveFileObject("javahelp/manifest.mf") != null) {
            return null;
        }
        return this.helper.resolveFileObject(SOURCES_TYPE_JAVAHELP);
    }

    public File getModuleJarLocation() {
        return this.helper.resolveFile(this.evaluator().evaluate("${cluster}/${module.jar}"));
    }

    public File getTestUserDirLockFile() {
        return this.getHelper().resolveFile(this.evaluator().evaluate("${test.user.dir}/lock"));
    }

    public String getCodeNameBase() {
        Element element = this.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3");
        if (element2 != null) {
            return Util.findText(element2);
        }
        return null;
    }

    public String getSpecVersion() {
        String string;
        Manifest manifest = this.getManifest();
        if (manifest != null && (string = manifest.getMainAttributes().getValue("OpenIDE-Module-Specification-Version")) != null) {
            return NbModuleProject.stripExcessZeros(string);
        }
        return NbModuleProject.stripExcessZeros(this.evaluator().getProperty("spec.version.base"));
    }

    private static String stripExcessZeros(String string) {
        return string != null ? string.replaceAll("(\\.[0-9]+)\\.0$", "$1") : null;
    }

    public String getPathWithinNetBeansOrg() {
        FileObject fileObject = this.getNbrootFileObject(null);
        if (fileObject != null) {
            return FileUtil.getRelativePath((FileObject)fileObject, (FileObject)this.getProjectDirectory());
        }
        return null;
    }

    private File getNbroot() {
        File file = this.getProjectDirectoryFile();
        File file2 = ModuleList.findNetBeansOrg(file);
        if (file2 != null) {
            return file2;
        }
        NbPlatform nbPlatform = this.getPlatform();
        if (nbPlatform != null) {
            URL[] uRLArray = nbPlatform.getSourceRoots();
            for (int i = 0; i < uRLArray.length; ++i) {
                File file3;
                if (!uRLArray[i].getProtocol().equals("file") || !ModuleList.isNetBeansOrg(file3 = new File(URI.create(uRLArray[i].toExternalForm())))) continue;
                return file3;
            }
        }
        return null;
    }

    public File getNbrootFile(String string) {
        File file = this.getNbroot();
        if (file != null) {
            return new File(file, string.replace('/', File.separatorChar));
        }
        return null;
    }

    public FileObject getNbrootFileObject(String string) {
        File file;
        File file2 = file = string != null ? this.getNbrootFile(string) : this.getNbroot();
        if (file != null) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public ModuleList getModuleList() throws IOException {
        ModuleList moduleList;
        NbPlatform nbPlatform = this.getPlatform(false);
        if (nbPlatform == null || !nbPlatform.isValid()) {
            Util.err.log(16, "Project in " + FileUtil.getFileDisplayName((FileObject)this.getProjectDirectory()) + " is missing its platform '" + this.evaluator().getProperty("nbplatform.active") + "', switching to default platform");
            NbPlatform nbPlatform2 = NbPlatform.getDefaultPlatform();
            return ModuleList.getModuleList(this.getProjectDirectoryFile(), nbPlatform2 != null ? nbPlatform2.getDestDir() : null);
        }
        try {
            moduleList = ModuleList.getModuleList(this.getProjectDirectoryFile(), nbPlatform.getDestDir());
        }
        catch (IOException iOException) {
            Logger.getLogger(NbModuleProject.class.getName()).log(Level.FINE, null, iOException);
            NbPlatform nbPlatform3 = NbPlatform.getDefaultPlatform();
            return ModuleList.getModuleList(this.getProjectDirectoryFile(), nbPlatform3 != null ? nbPlatform3.getDestDir() : null);
        }
        if (moduleList.getEntry(this.getCodeNameBase()) == null) {
            ModuleList.refresh();
            moduleList = ModuleList.getModuleList(this.getProjectDirectoryFile());
            if (moduleList.getEntry(this.getCodeNameBase()) == null) {
                Util.err.log(16, "Project in " + FileUtil.getFileDisplayName((FileObject)this.getProjectDirectory()) + " does not appear to be listed in its own module list; some sort of misconfiguration (e.g. not listed in its own suite)");
            }
        }
        return moduleList;
    }

    public NbPlatform getPlatform(boolean bl) {
        NbPlatform nbPlatform = this.getPlatform();
        if (bl && (nbPlatform == null || !nbPlatform.isValid())) {
            nbPlatform = NbPlatform.getDefaultPlatform();
        }
        return nbPlatform;
    }

    private NbPlatform getPlatform() {
        File file = this.getPlatformFile();
        if (file == null) {
            return null;
        }
        return NbPlatform.getPlatformByDestDir(file);
    }

    private File getPlatformFile() {
        String string = this.evaluator().getProperty("netbeans.dest.dir");
        if (string == null) {
            return null;
        }
        return this.getHelper().resolveFile(string);
    }

    public boolean supportsJavadoc() {
        if (this.evaluator().getProperty("module.javadoc.packages") != null) {
            return true;
        }
        Element element = this.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "public-packages", "http://www.netbeans.org/ns/nb-module-project/3");
        if (element2 == null) {
            element2 = Util.findElement(element, "friend-packages", "http://www.netbeans.org/ns/nb-module-project/3");
        }
        return element2 != null && !Util.findSubElements(element2).isEmpty();
    }

    public List<String> supportedTestTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : COMMON_TEST_TYPES) {
            if (this.getTestSourceDirectory(string) == null || Boolean.parseBoolean(this.evaluator().getProperty("disable." + string + ".tests"))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public Map<FileObject, Element> getExtraCompilationUnits() {
        if (this.extraCompilationUnits == null) {
            this.extraCompilationUnits = new HashMap<FileObject, Element>();
            for (Element element : Util.findSubElements(this.getPrimaryConfigurationData())) {
                if (!element.getLocalName().equals("extra-compilation-unit")) continue;
                Element element2 = Util.findElement(element, "package-root", "http://www.netbeans.org/ns/nb-module-project/3");
                String string = Util.findText(element2);
                String string2 = this.evaluator().evaluate(string);
                FileObject fileObject = this.getHelper().resolveFileObject(string2);
                if (fileObject == null) {
                    Util.err.log(16, "Could not find package-root " + string2 + " for " + this.getCodeNameBase());
                    continue;
                }
                this.extraCompilationUnits.put(fileObject, element);
            }
        }
        return this.extraCompilationUnits;
    }

    public String getJavacSource() {
        String string = this.evaluator().getProperty("javac.source");
        assert (string != null);
        return string;
    }

    public void open() {
        if (this.getModuleType() == NbModuleProvider.STANDALONE) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    String string = "nbproject/private/platform-private.properties";
                    EditableProperties editableProperties = NbModuleProject.this.getHelper().getProperties(string);
                    File file = new File(System.getProperty("netbeans.user"), "build.properties");
                    editableProperties.setProperty("user.properties.file", file.getAbsolutePath());
                    NbModuleProject.this.getHelper().putProperties(string, editableProperties);
                    try {
                        ProjectManager.getDefault().saveProject((Project)NbModuleProject.this);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    return null;
                }
            });
        }
        ClassPathProviderImpl classPathProviderImpl = (ClassPathProviderImpl)this.lookup.lookup(ClassPathProviderImpl.class);
        ClassPath[] classPathArray = classPathProviderImpl.getProjectClassPaths("classpath/boot");
        assert (classPathArray != null) : "No BOOT path";
        ClassPath[] classPathArray2 = classPathProviderImpl.getProjectClassPaths("classpath/source");
        assert (classPathArray2 != null) : "No SOURCE path";
        ClassPath[] classPathArray3 = classPathProviderImpl.getProjectClassPaths("classpath/compile");
        assert (classPathArray3 != null) : "No COMPILE path";
        GlobalPathRegistry.getDefault().register("classpath/boot", classPathArray);
        GlobalPathRegistry.getDefault().register("classpath/source", classPathArray2);
        GlobalPathRegistry.getDefault().register("classpath/compile", classPathArray3);
        this.boot = classPathArray;
        this.source = classPathArray2;
        this.compile = classPathArray3;
        if (this.getModuleType() != NbModuleProvider.NETBEANS_ORG) {
            try {
                this.refreshBuildScripts(true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public LocalizedBundleInfo getBundleInfo() {
        return ((LocalizedBundleInfo.Provider)this.getLookup().lookup(LocalizedBundleInfo.Provider.class)).getLocalizedBundleInfo();
    }

    public void setRunInAtomicAction(boolean bl) {
        this.eval.setRunInAtomicAction(bl);
    }

    public boolean isRunInAtomicAction() {
        return this.eval.isRunInAtomicAction();
    }

    public void notifyDeleting() {
        this.eval.removeListeners();
    }

    public void refreshBuildScripts(boolean bl) throws IOException {
        this.refreshBuildScripts(bl, this.getPlatform(true));
    }

    public void refreshBuildScripts(boolean bl, NbPlatform nbPlatform) throws IOException {
        String string = nbPlatform.getHarnessVersion() <= 6 || this.eval.getProperty("cluster.path") == null ? "build-impl-65.xsl" : "build-impl.xsl";
        this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", NbModuleProject.class.getResource("resources/" + string), bl);
        this.genFilesHelper.refreshBuildScript("build.xml", NbModuleProject.class.getResource("resources/build.xsl"), bl);
    }

    static /* synthetic */ ClassPath[] access$402(NbModuleProject nbModuleProject, ClassPath[] classPathArray) {
        nbModuleProject.boot = classPathArray;
        return classPathArray;
    }

    static /* synthetic */ ClassPath[] access$502(NbModuleProject nbModuleProject, ClassPath[] classPathArray) {
        nbModuleProject.source = classPathArray;
        return classPathArray;
    }

    static /* synthetic */ ClassPath[] access$602(NbModuleProject nbModuleProject, ClassPath[] classPathArray) {
        nbModuleProject.compile = classPathArray;
        return classPathArray;
    }

    private final class LocalizedBundleInfoProvider
    implements LocalizedBundleInfo.Provider {
        private LocalizedBundleInfo bundleInfo;

        private LocalizedBundleInfoProvider() {
        }

        public LocalizedBundleInfo getLocalizedBundleInfo() {
            if (this.bundleInfo == null) {
                Manifest manifest = NbModuleProject.this.getManifest();
                FileObject fileObject = NbModuleProject.this.getSourceDirectory();
                if (manifest != null && fileObject != null) {
                    this.bundleInfo = Util.findLocalizedBundleInfo(fileObject, NbModuleProject.this.getManifest());
                }
                if (this.bundleInfo != null) {
                    this.bundleInfo.addPropertyChangeListener((PropertyChangeListener)NbModuleProject.this.getLookup().lookup(Info.class));
                }
                if (manifest != null) {
                    NbModuleProject.this.getManifestFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                        public void fileChanged(FileEvent fileEvent) {
                            LocalizedBundleInfoProvider.this.bundleInfo = null;
                        }
                    });
                }
            }
            return this.bundleInfo;
        }
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Classes/Interface.java", "Templates/JUnit/SimpleJUnitTest.java", "Templates/NetBeansModuleDevelopment/newAction", "Templates/NetBeansModuleDevelopment/emptyLibraryDescriptor", "Templates/NetBeansModuleDevelopment/newLoader", "Templates/NetBeansModuleDevelopment/newProject", "Templates/NetBeansModuleDevelopment/newWindow", "Templates/NetBeansModuleDevelopment/newWizard"};
        private static final String[] RECOMMENDED_TYPES;

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        static {
            assert (PRIVILEGED_NAMES.length <= 10) : "Too many privileged templates to fit! extras will be ignored: " + Arrays.asList(PRIVILEGED_NAMES).subList(10, PRIVILEGED_NAMES.length);
            RECOMMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-forms", "java-beans", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "junit", "simple-files", "nbm-specific", "nbm-specific2"};
        }
    }

    private class NbModuleProviderImpl
    implements NbModuleProvider,
    AntProjectListener {
        private NbModuleProvider.NbModuleType type;

        public NbModuleProviderImpl() {
            NbModuleProject.this.getHelper().addAntProjectListener((AntProjectListener)this);
        }

        public NbModuleProvider.NbModuleType getModuleType() {
            if (this.type == null) {
                this.type = NbModuleProject.this.getModuleType();
            }
            return this.type;
        }

        public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
            if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
                this.type = null;
            }
        }

        public void propertiesChanged(AntProjectEvent antProjectEvent) {
        }

        public String getSpecVersion() {
            return NbModuleProject.this.getSpecVersion();
        }

        public String getCodeNameBase() {
            return NbModuleProject.this.getCodeNameBase();
        }

        public String getSourceDirectoryPath() {
            return NbModuleProject.this.getSourceDirectoryPath();
        }

        public FileObject getSourceDirectory() {
            return NbModuleProject.this.getSourceDirectory();
        }

        public FileObject getManifestFile() {
            return NbModuleProject.this.getManifestFile();
        }

        public String getResourceDirectoryPath(boolean bl) {
            return NbModuleProject.this.evaluator().getProperty(bl ? "test.unit.src.dir" : "src.dir");
        }

        public boolean addDependency(String string, String string2, SpecificationVersion specificationVersion, boolean bl) throws IOException {
            return Util.addDependency(NbModuleProject.this, string, string2, specificationVersion, bl);
        }

        public SpecificationVersion getDependencyVersion(String string) throws IOException {
            ModuleList moduleList = NbModuleProject.this.getModuleList();
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            SpecificationVersion specificationVersion = new SpecificationVersion(moduleEntry.getSpecificationVersion());
            return specificationVersion;
        }

        public String getProjectFilePath() {
            return "nbproject/project.xml";
        }

        public File getActivePlatformLocation() {
            return NbModuleProject.this.getPlatformFile();
        }

        public File getModuleJarLocation() {
            return NbModuleProject.this.getModuleJarLocation();
        }
    }

    private final class SuiteProviderImpl
    implements SuiteProvider {
        private SuiteProviderImpl() {
        }

        public File getSuiteDirectory() {
            String string = NbModuleProject.this.evaluator().getProperty("suite.dir");
            return string == null ? null : NbModuleProject.this.helper.resolveFile(string);
        }

        public File getClusterDirectory() {
            return NbModuleProject.this.getModuleJarLocation().getParentFile().getParentFile().getAbsoluteFile();
        }
    }

    private final class SavedHook
    extends ProjectXmlSavedHook {
        SavedHook() {
        }

        protected void projectXmlSaved() throws IOException {
            if (NbModuleProject.this.getModuleType() != NbModuleProvider.NETBEANS_ORG) {
                NbModuleProject.this.refreshBuildScripts(false);
            }
        }
    }

    private final class Info
    implements ProjectInformation,
    PropertyChangeListener {
        private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String displayName;

        Info() {
        }

        public String getName() {
            String string = NbModuleProject.this.getCodeNameBase();
            return string != null ? string : NbModuleProject.this.getProjectDirectory().toString();
        }

        public String getDisplayName() {
            LocalizedBundleInfo localizedBundleInfo;
            if (this.displayName == null && (localizedBundleInfo = NbModuleProject.this.getBundleInfo()) != null) {
                this.displayName = localizedBundleInfo.getDisplayName();
            }
            if (this.displayName == null) {
                this.displayName = this.getName();
            }
            assert (this.displayName != null) : NbModuleProject.this;
            return this.displayName;
        }

        private void setDisplayName(String string) {
            String string2 = this.getDisplayName();
            this.displayName = string == null ? this.getName() : string;
            this.firePropertyChange("displayName", string2, this.displayName);
        }

        public Icon getIcon() {
            return NB_PROJECT_ICON;
        }

        public Project getProject() {
            return NbModuleProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        private void firePropertyChange(String string, Object object, Object object2) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                this.setDisplayName((String)propertyChangeEvent.getNewValue());
            }
        }
    }

    private final class OpenedHook
    extends ProjectOpenedHook {
        OpenedHook() {
        }

        protected void projectOpened() {
            NbModuleProject.this.open();
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)NbModuleProject.this);
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
            assert (NbModuleProject.this.boot != null && NbModuleProject.this.source != null && NbModuleProject.this.compile != null) : "#46802: project being closed which was never opened?? " + NbModuleProject.this;
            GlobalPathRegistry.getDefault().unregister("classpath/boot", NbModuleProject.this.boot);
            GlobalPathRegistry.getDefault().unregister("classpath/source", NbModuleProject.this.source);
            GlobalPathRegistry.getDefault().unregister("classpath/compile", NbModuleProject.this.compile);
            NbModuleProject.access$402(NbModuleProject.this, null);
            NbModuleProject.access$502(NbModuleProject.this, null);
            NbModuleProject.access$602(NbModuleProject.this, null);
        }
    }
}

