/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SuiteSubprojectProviderImpl
implements SubprojectProvider {
    private Set<NbModuleProject> projects;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean reloadNeeded;

    public SuiteSubprojectProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.eval = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("modules".equals(propertyChangeEvent.getPropertyName())) {
                    SuiteSubprojectProviderImpl.this.reloadNeeded = true;
                    SuiteSubprojectProviderImpl.this.changeSupport.fireChange();
                }
            }
        });
    }

    public Set<NbModuleProject> getSubprojects() {
        if (this.projects == null || this.reloadNeeded) {
            this.reloadNeeded = false;
            this.projects = this.loadProjects();
        }
        return this.projects;
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private Set<NbModuleProject> loadProjects() {
        HashSet<NbModuleProject> hashSet = new HashSet<NbModuleProject>();
        String string = this.eval.getProperty("modules");
        if (string != null) {
            for (String string2 : PropertyUtils.tokenizePath((String)string)) {
                FileObject fileObject = this.helper.resolveFileObject(string2);
                if (fileObject == null) continue;
                try {
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (project == null || !(project instanceof NbModuleProject)) continue;
                    hashSet.add((NbModuleProject)project);
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                }
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

