/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.ModuleLogicalView;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SourcesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        NbModuleProject nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
        return new SourceNL(nbModuleProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceNL
    implements NodeList<SourceGroup>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private static final String[] SOURCE_GROUP_TYPES = new String[]{"java", "javahelp"};
        private final NbModuleProject project;

        SourceNL(NbModuleProject nbModuleProject) {
            this.project = nbModuleProject;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void addNotify() {
            ProjectUtils.getSources((Project)this.project).addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            ProjectUtils.getSources((Project)this.project).removeChangeListener((ChangeListener)this);
        }

        public Node node(SourceGroup sourceGroup) {
            return PackageView.createPackageView((SourceGroup)sourceGroup);
        }

        public List<SourceGroup> keys() {
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            Sources sources = ProjectUtils.getSources((Project)this.project);
            for (int i = 0; i < SOURCE_GROUP_TYPES.length; ++i) {
                SourceGroup[] sourceGroupArray = sources.getSourceGroups(SOURCE_GROUP_TYPES[i]);
                arrayList.addAll(Arrays.asList(sourceGroupArray));
            }
            SourceGroup sourceGroup = this.makeJavadocDocfilesSourceGroup();
            if (sourceGroup != null) {
                arrayList.add(sourceGroup);
            }
            return arrayList;
        }

        private SourceGroup makeJavadocDocfilesSourceGroup() {
            String string = "javadoc.docfiles";
            FileObject fileObject = this.resolveFileObjectFromProperty(string);
            if (fileObject == null) {
                return null;
            }
            return GenericSources.group((Project)this.project, (FileObject)fileObject, (String)string, (String)NbBundle.getMessage(ModuleLogicalView.class, (String)"LBL_extra_javadoc_files"), null, null);
        }

        private FileObject resolveFileObjectFromProperty(String string) {
            String string2 = this.project.evaluator().getProperty(string);
            if (string2 == null) {
                return null;
            }
            return this.project.getHelper().resolveFileObject(string2);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }
    }
}

