/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.SuiteActions;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class SuiteLogicalView
implements LogicalViewProvider {
    private final SuiteProject suite;

    public SuiteLogicalView(SuiteProject suiteProject) {
        this.suite = suiteProject;
    }

    public Node createLogicalView() {
        return new SuiteRootNode(this.suite);
    }

    public Node findPath(Node node, Object object) {
        DataObject dataObject;
        if (node.getLookup().lookup(SuiteProject.class) != this.suite) {
            return null;
        }
        if (object instanceof FileObject) {
            try {
                dataObject = DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        } else if (object instanceof DataObject) {
            dataObject = (DataObject)object;
        } else {
            return null;
        }
        Node node2 = node.getChildren().findChild("important.files");
        if (node2 != null) {
            Node[] nodeArray = node2.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].getCookie(DataObject.class) != dataObject) continue;
                return nodeArray[i];
            }
        }
        return null;
    }

    static final class SuiteRootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/suite/resources/suite.png", (boolean)true);
        private final SuiteProject suite;
        private final ProjectInformation info;

        SuiteRootNode(SuiteProject suiteProject) {
            super(NodeFactorySupport.createCompositeChildren((Project)suiteProject, (String)"Projects/org-netbeans-modules-apisupport-project-suite/Nodes"), Lookups.fixed((Object[])new Object[]{suiteProject}));
            this.suite = suiteProject;
            this.info = ProjectUtils.getInformation((Project)suiteProject);
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public String getDisplayName() {
            return this.info.getDisplayName();
        }

        public String getShortDescription() {
            return NbBundle.getMessage(SuiteLogicalView.class, (String)"HINT_suite_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)this.suite.getProjectDirectory()));
        }

        public Action[] getActions(boolean bl) {
            return SuiteActions.getProjectActions(this.suite);
        }

        public Image getIcon(int n) {
            return ICON;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                public void run() {
                    if (propertyChangeEvent.getPropertyName().equals("name")) {
                        SuiteRootNode.this.fireNameChange(null, SuiteRootNode.this.getName());
                    } else if (propertyChangeEvent.getPropertyName().equals("displayName")) {
                        SuiteRootNode.this.fireDisplayNameChange(null, SuiteRootNode.this.getDisplayName());
                    }
                }
            });
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.suite, (String)string);
        }
    }
}

