/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;

public final class ClusterInfo {
    private File clusterDir;
    private boolean isPlatformCluster;
    private Project project;
    private boolean enabled;
    private URL[] sourceRoots;
    private URL[] javadocRoots;
    private static final String NO_NBORG_PROJECTS = "Only standalone module or suite projects allowed";

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ClusterInfo clusterInfo = (ClusterInfo)object;
        if (!(this.clusterDir == clusterInfo.clusterDir || this.clusterDir != null && this.clusterDir.equals(clusterInfo.clusterDir))) {
            return false;
        }
        if (this.isPlatformCluster != clusterInfo.isPlatformCluster) {
            return false;
        }
        if (!(this.project == clusterInfo.project || this.project != null && this.project.equals(clusterInfo.project))) {
            return false;
        }
        if (this.enabled != clusterInfo.enabled) {
            return false;
        }
        if (!Arrays.deepEquals(this.sourceRoots, clusterInfo.sourceRoots)) {
            return false;
        }
        return Arrays.deepEquals(this.javadocRoots, clusterInfo.javadocRoots);
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.clusterDir != null ? this.clusterDir.hashCode() : 0);
        n = 47 * n + (this.isPlatformCluster ? 1 : 0);
        n = 47 * n + (this.project != null ? this.project.hashCode() : 0);
        n = 47 * n + (this.enabled ? 1 : 0);
        n = 47 * n + Arrays.deepHashCode(this.sourceRoots);
        n = 47 * n + Arrays.deepHashCode(this.javadocRoots);
        return n;
    }

    public String toString() {
        return this.clusterDir.getAbsolutePath() + (this.isEnabled() ? "" : " (DISABLED)");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPlatformCluster() {
        return this.isPlatformCluster;
    }

    public boolean isExternalCluster() {
        return !this.isPlatformCluster && this.project == null;
    }

    public File getClusterDir() {
        return this.clusterDir;
    }

    private ClusterInfo(File file) {
        this.clusterDir = file;
    }

    public static ClusterInfo createFromCP(File file, Project project, boolean bl, URL[] uRLArray, URL[] uRLArray2, boolean bl2) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = bl;
        clusterInfo.project = project;
        clusterInfo.enabled = bl2;
        clusterInfo.sourceRoots = uRLArray;
        clusterInfo.javadocRoots = uRLArray2;
        return clusterInfo;
    }

    public static ClusterInfo create(File file, boolean bl, boolean bl2) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = bl;
        clusterInfo.enabled = bl2;
        return clusterInfo;
    }

    public static ClusterInfo createExternal(File file, URL[] uRLArray, URL[] uRLArray2, boolean bl) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = false;
        clusterInfo.enabled = bl;
        clusterInfo.sourceRoots = uRLArray;
        clusterInfo.javadocRoots = uRLArray2;
        return clusterInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterInfo create(Project project, boolean bl) {
        File file;
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (suiteProvider != null) {
            file = suiteProvider.getClusterDirectory();
        } else {
            if (nbModuleProvider == null) throw new IllegalArgumentException(NO_NBORG_PROJECTS);
            if (nbModuleProvider.getModuleType() != NbModuleProvider.STANDALONE) throw new IllegalArgumentException(NO_NBORG_PROJECTS);
            file = ClusterUtils.getClusterDirectory(project);
        }
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.project = project;
        clusterInfo.enabled = bl;
        return clusterInfo;
    }

    public Project getProject() {
        return this.project;
    }

    public URL[] getSourceRoots() {
        return this.sourceRoots;
    }

    public URL[] getJavadocRoots() {
        return this.javadocRoots;
    }
}

