/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public class CustomizerLibraries
extends NbPropertyPanel.Single {
    private Logger LOG = Logger.getLogger(CustomizerLibraries.class.getName());
    private JButton addDepButton;
    private JButton addLibrary;
    private JButton addTokenButton;
    private JPanel depButtonPanel;
    private JList dependencyList;
    private JScrollPane dependencySP;
    private JButton editDepButton;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel modDepLabel;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private JButton removeDepButton;
    private JButton removeTokenButton;
    private JList reqTokenList;
    private JScrollPane reqTokenSP;
    private JLabel reqTokens;
    private JLabel space1;
    private JPanel tokenButtonPanel;

    public CustomizerLibraries(SingleModuleProperties singleModuleProperties, ProjectCustomizer.Category category) {
        super(singleModuleProperties, CustomizerLibraries.class, category);
        this.initComponents();
        this.initAccessibility();
        if (!this.getProperties().isSuiteComponent()) {
            this.addLibrary.setVisible(false);
            Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)this.getMessage("CTL_AddButton"));
        }
        this.refresh();
        this.dependencyList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
        this.removeTokenButton.setEnabled(false);
        this.attachListeners();
    }

    void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        this.platformValue.setEnabled(this.getProperties().isStandalone());
        this.managePlafsButton.setEnabled(this.getProperties().isStandalone());
        this.updateEnabled();
        this.reqTokenList.setModel(this.getProperties().getRequiredTokenListModel());
        this.dependencyList.setModel(this.getProperties().getDependenciesListModel());
        this.dependencyList.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                CustomizerLibraries.this.updateEnabled();
            }
        });
    }

    private void attachListeners() {
        this.platformValue.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActivePlatform((NbPlatform)CustomizerLibraries.this.platformValue.getSelectedItem());
                    CustomizerLibraries.this.runDependenciesListModelRefresh();
                }
            }
        });
        this.dependencyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActiveJavaPlatform((JavaPlatform)CustomizerLibraries.this.javaPlatformCombo.getSelectedItem());
                }
            }
        });
        this.reqTokenList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    CustomizerLibraries.this.removeTokenButton.setEnabled(CustomizerLibraries.this.reqTokenList.getSelectedIndex() != -1);
                }
            }
        });
    }

    private void runDependenciesListModelRefresh() {
        this.dependencyList.setModel(CustomizerComponentFactory.createListWaitModel());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final CustomizerComponentFactory.DependencyListModel dependencyListModel = CustomizerLibraries.this.getProperties().getDependenciesListModel();
                CustomizerLibraries.this.LOG.log(Level.FINER, "DependenciesListModel generated");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CustomizerLibraries.this.LOG.log(Level.FINER, "DependenciesListModel invokeLater entered");
                        CustomizerLibraries.this.dependencyList.setModel(dependencyListModel);
                        CustomizerLibraries.this.LOG.log(Level.FINER, "DependenciesListModel model set");
                        CustomizerLibraries.this.updateEnabled();
                    }
                });
            }
        });
        this.updateEnabled();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel(this.getProperties().getActivePlatform()));
        this.platformValue.requestFocusInWindow();
    }

    private void updateEnabled() {
        boolean bl = !CustomizerComponentFactory.isWaitModel(this.dependencyList.getModel());
        boolean bl2 = this.dependencyList.getModel().getSize() > 0 && bl && this.getProperties().isActivePlatformValid() && this.dependencyList.getSelectedIndex() != -1;
        this.editDepButton.setEnabled(bl2);
        this.removeDepButton.setEnabled(bl2);
        this.addDepButton.setEnabled(bl && this.getProperties().isActivePlatformValid());
        boolean bl3 = this.getProperties().isNetBeansOrg() || this.getProperties().isStandalone() && ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion() >= 2;
        this.javaPlatformCombo.setEnabled(bl3);
        this.javaPlatformButton.setEnabled(bl3);
    }

    private CustomizerComponentFactory.DependencyListModel getDepListModel() {
        return (CustomizerComponentFactory.DependencyListModel)this.dependencyList.getModel();
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(CustomizerLibraries.class, (String)string);
    }

    private void initComponents() {
        this.modDepLabel = new JLabel();
        this.depButtonPanel = new JPanel();
        this.addDepButton = new JButton();
        this.addLibrary = new JButton();
        this.removeDepButton = new JButton();
        this.space1 = new JLabel();
        this.editDepButton = new JButton();
        this.dependencySP = new JScrollPane();
        this.dependencyList = new JList();
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.reqTokens = new JLabel();
        this.reqTokenSP = new JScrollPane();
        this.reqTokenList = new JList();
        this.tokenButtonPanel = new JPanel();
        this.addTokenButton = new JButton();
        this.removeTokenButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.modDepLabel.setLabelFor(this.dependencyList);
        Mnemonics.setLocalizedText((JLabel)this.modDepLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_ModuleDependencies"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 2, 0);
        this.add((Component)this.modDepLabel, gridBagConstraints);
        this.depButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddDependency"));
        this.addDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.depButtonPanel.add((Component)this.addDepButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addLibrary, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddNewLibrary"));
        this.addLibrary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addLibraryActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.depButtonPanel.add((Component)this.addLibrary, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.depButtonPanel.add((Component)this.removeDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.depButtonPanel.add((Component)this.space1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editDepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.editModuleDependency(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.depButtonPanel.add((Component)this.editDepButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.depButtonPanel, gridBagConstraints);
        this.dependencySP.setViewportView(this.dependencyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.dependencySP, gridBagConstraints);
        this.platformsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_ManagePlatform"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.managePlatforms(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.javaPlatformButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.platformsPanel, gridBagConstraints);
        this.reqTokens.setLabelFor(this.reqTokenList);
        Mnemonics.setLocalizedText((JLabel)this.reqTokens, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_RequiredTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 12);
        this.add((Component)this.reqTokens, gridBagConstraints);
        this.reqTokenSP.setViewportView(this.reqTokenList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.reqTokenSP, gridBagConstraints);
        this.tokenButtonPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddButton_d"));
        this.addTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.addToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tokenButtonPanel.add((Component)this.addTokenButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton_v"));
        this.removeTokenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.removeToken(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.tokenButtonPanel.add((Component)this.removeTokenButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tokenButtonPanel, gridBagConstraints);
    }

    private void addLibraryActionPerformed(ActionEvent actionEvent) {
        block3: {
            NbModuleProject nbModuleProject = UIUtil.runLibraryWrapperWizard(this.getProperties().getProject());
            if (nbModuleProject != null) {
                try {
                    this.getProperties().resetUniverseDependencies();
                    ModuleDependency moduleDependency = new ModuleDependency(this.getProperties().getModuleList().getEntry(nbModuleProject.getCodeNameBase()));
                    this.getDepListModel().addDependency(moduleDependency);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)iOException);
                }
            }
        }
    }

    private void javaPlatformButtonActionPerformed(ActionEvent actionEvent) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
        this.refreshJavaPlatforms();
    }

    private void removeToken(ActionEvent actionEvent) {
        CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
        Object[] objectArray = this.reqTokenList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            requiredTokenListModel.removeToken((String)objectArray[i]);
        }
        if (requiredTokenListModel.getSize() > 0) {
            this.reqTokenList.setSelectedIndex(0);
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void addToken(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.setLayout(new BorderLayout(0, 2));
        JList<String> jList = new JList<String>(this.getProperties().getAllTokens());
        JScrollPane jScrollPane = new JScrollPane(jList);
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(jList);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)this.getMessage("LBL_ProvidedTokens_T"));
        jPanel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_ProvidedTokensTitle"));
        jList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_LBL_ProvidedTokens"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensVerticalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(this.getMessage("ACS_CTL_ProvidedTokensHorizontalScroll"));
        jScrollPane.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_CTL_ProvidedTokensHorizontalScroll"));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, this.getMessage("LBL_ProvidedTokens_NoMnem"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            Object[] objectArray = jList.getSelectedValues();
            CustomizerComponentFactory.RequiredTokenListModel requiredTokenListModel = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                requiredTokenListModel.addToken((String)objectArray[i]);
            }
            if (objectArray.length > 0) {
                this.reqTokenList.clearSelection();
                this.reqTokenList.setSelectedValue(objectArray[0], true);
            }
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void managePlatforms(ActionEvent actionEvent) {
        NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
    }

    private void editModuleDependency(ActionEvent actionEvent) {
        ModuleDependency moduleDependency = this.getDepListModel().getDependency(this.dependencyList.getSelectedIndex());
        EditDependencyPanel editDependencyPanel = new EditDependencyPanel(moduleDependency, this.getProperties().getActivePlatform());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editDependencyPanel, this.getMessage("CTL_EditModuleDependencyTitle"));
        dialogDescriptor.setHelpCtx(new HelpCtx(EditDependencyPanel.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.getDepListModel().editDependency(moduleDependency, editDependencyPanel.getEditedDependency());
        }
        dialog.dispose();
        this.dependencyList.requestFocusInWindow();
    }

    private void removeModuleDependency(ActionEvent actionEvent) {
        List list = NbCollections.checkedListByCopy(Arrays.asList(this.dependencyList.getSelectedValues()), ModuleDependency.class, (boolean)false);
        if (list.size() > 0) {
            this.getDepListModel().removeDependencies(list);
            if (this.dependencyList.getModel().getSize() > 0) {
                this.dependencyList.setSelectedIndex(0);
            }
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void addModuleDependency(ActionEvent actionEvent) {
        ModuleDependency[] moduleDependencyArray = AddModulePanel.selectDependencies(this.getProperties());
        for (int i = 0; i < moduleDependencyArray.length; ++i) {
            ModuleDependency moduleDependency = moduleDependencyArray[i];
            if ("0".equals(moduleDependency.getReleaseVersion()) && !moduleDependency.hasImplementationDepedendency()) {
                this.getDepListModel().addDependency(new ModuleDependency(moduleDependency.getModuleEntry(), "0-1", moduleDependency.getSpecificationVersion(), moduleDependency.hasCompileDependency(), moduleDependency.hasImplementationDepedendency()));
            } else {
                this.getDepListModel().addDependency(moduleDependency);
            }
            this.dependencyList.setSelectedValue(moduleDependency, true);
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void initAccessibility() {
        this.addTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddTokenButton"));
        this.dependencyList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_DependencyList"));
        this.editDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_EditDepButton"));
        this.removeDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveDepButton"));
        this.removeTokenButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_RemoveTokenButton"));
        this.addDepButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_AddDepButton"));
        this.reqTokenList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ReqTokenList"));
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_ManagePlafsButton"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PlatformValue"));
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformCombo"));
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformButton"));
        this.javaPlatformLabel.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_JavaPlatformLbl"));
        this.platform.getAccessibleContext().setAccessibleDescription(this.getMessage("ACSD_PlatformLbl"));
    }
}

