/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.text.Collator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleDependency
implements Comparable<ModuleDependency> {
    private String releaseVersion;
    private String specVersion;
    private static final String SPEC_VERSION_LAZY = "<lazy>";
    private boolean implDep;
    private boolean compileDep;
    private ModuleEntry me;
    private Set<String> filterTokensNotFriend;
    private Set<String> filterTokensFriend;
    public static final Comparator<ModuleDependency> LOCALIZED_NAME_COMPARATOR = new Comparator<ModuleDependency>(){

        @Override
        public int compare(ModuleDependency moduleDependency, ModuleDependency moduleDependency2) {
            ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
            ModuleEntry moduleEntry2 = moduleDependency2.getModuleEntry();
            int n = Collator.getInstance().compare(moduleEntry.getLocalizedName(), moduleEntry2.getLocalizedName());
            return n != 0 ? n : moduleEntry.getCodeNameBase().compareTo(moduleEntry2.getCodeNameBase());
        }
    };
    public static final Comparator<ModuleDependency> CNB_COMPARATOR = new Comparator<ModuleDependency>(){

        @Override
        public int compare(ModuleDependency moduleDependency, ModuleDependency moduleDependency2) {
            return moduleDependency.getCodeNameBase().compareTo(moduleDependency2.getCodeNameBase());
        }
    };

    public ModuleDependency(ModuleEntry moduleEntry) {
        this(moduleEntry, moduleEntry.getReleaseVersion(), SPEC_VERSION_LAZY, moduleEntry.getPublicPackages().length > 0, false);
    }

    public ModuleDependency(ModuleEntry moduleEntry, String string, String string2, boolean bl, boolean bl2) {
        this.me = moduleEntry;
        this.compileDep = bl;
        this.implDep = bl2;
        this.releaseVersion = string;
        this.specVersion = string2;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getSpecificationVersion() {
        if (this.specVersion == SPEC_VERSION_LAZY) {
            this.specVersion = this.me.getSpecificationVersion();
        }
        return this.specVersion;
    }

    public ModuleEntry getModuleEntry() {
        return this.me;
    }

    private String getCodeNameBase() {
        return this.getModuleEntry().getCodeNameBase();
    }

    @Override
    public int compareTo(ModuleDependency moduleDependency) {
        int n = this.getCodeNameBase().compareTo(moduleDependency.getCodeNameBase());
        if (n != 0) {
            return n;
        }
        String string = moduleDependency.getReleaseVersion();
        int n2 = this.getReleaseVersion() == null ? (string == null ? 0 : -1) : (n = string == null ? 1 : this.getReleaseVersion().compareTo(string));
        if (n != 0) {
            return n;
        }
        if (this.specVersion != SPEC_VERSION_LAZY || moduleDependency.specVersion != SPEC_VERSION_LAZY) {
            String string2 = moduleDependency.getSpecificationVersion();
            String string3 = this.getSpecificationVersion();
            int n3 = string3 == null ? (string2 == null ? 0 : -1) : (n = string2 == null ? 1 : string3.compareTo(string2));
            if (n != 0) {
                return n;
            }
        }
        int n4 = this.hasImplementationDepedendency() == moduleDependency.hasImplementationDepedendency() ? 0 : (n = this.implDep ? 1 : -1);
        if (n != 0) {
            return n;
        }
        n = this.hasCompileDependency() == moduleDependency.hasCompileDependency() ? 0 : (this.compileDep ? 1 : -1);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)object;
            return this.getCodeNameBase().equals(moduleDependency.getCodeNameBase()) && Utilities.compareObjects((Object)this.getReleaseVersion(), (Object)moduleDependency.getReleaseVersion()) && (this.specVersion == SPEC_VERSION_LAZY && moduleDependency.specVersion == SPEC_VERSION_LAZY || Utilities.compareObjects((Object)this.getSpecificationVersion(), (Object)moduleDependency.getSpecificationVersion())) && this.hasImplementationDepedendency() == moduleDependency.hasImplementationDepedendency() && this.hasCompileDependency() == moduleDependency.hasCompileDependency();
        }
        return false;
    }

    public int hashCode() {
        return this.getCodeNameBase().hashCode();
    }

    public boolean hasCompileDependency() {
        return this.compileDep;
    }

    public boolean hasImplementationDepedendency() {
        return this.implDep;
    }

    Set<String> getFilterTokens(String string) {
        Set<String> set;
        boolean bl = this.me.isDeclaredAsFriend(string);
        Set<String> set2 = set = bl ? this.filterTokensFriend : this.filterTokensNotFriend;
        if (set == null) {
            set = new HashSet<String>();
            set.add(this.me.getCodeNameBase());
            set.add(this.me.getLocalizedName());
            set.add(this.me.getJarLocation().getAbsolutePath());
            String[] stringArray = PropertyUtils.tokenizePath((String)this.me.getClassPathExtensions());
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
            }
            if (bl) {
                for (String string2 : this.me.getPublicClassNames()) {
                    set.add(string2.replace('$', '.'));
                }
            }
            if (bl) {
                this.filterTokensFriend = set;
            } else {
                this.filterTokensNotFriend = set;
            }
        }
        return set;
    }

    public String toString() {
        return "ModuleDependency[me: " + this.getModuleEntry() + ", relVer: " + this.getReleaseVersion() + ", specVer: " + this.getSpecificationVersion() + ", implDep: " + this.hasImplementationDepedendency() + ", compDep: " + this.hasCompileDependency() + "]";
    }
}

