/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectLibraryPanel
extends BasicWizardIterator.Panel {
    private NewLibraryDescriptor.DataModel data;
    private final LibraryChooser.Panel panel;

    public SelectLibraryPanel(WizardDescriptor wizardDescriptor, NewLibraryDescriptor.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.getAccessibleContext().setAccessibleDescription(SelectLibraryPanel.getMessage("ACS_SelectLibraryPanel"));
        this.putClientProperty("NewFileWizard_Title", SelectLibraryPanel.getMessage("LBL_LibraryWizardTitle"));
        this.panel = LibraryChooser.createPanel(null, null);
        this.panel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedLibraries".equals(propertyChangeEvent.getPropertyName())) {
                    SelectLibraryPanel.this.checkValidity();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.panel.getVisualComponent(), "Center");
    }

    private void checkValidity() {
        if (this.getSelectedLibrary() != null) {
            this.markValid();
        } else {
            this.markInvalid();
        }
    }

    private Library getSelectedLibrary() {
        Set set = this.panel.getSelectedLibraries();
        return set.size() == 1 ? (Library)set.iterator().next() : null;
    }

    protected void storeToDataModel() {
        this.data.setLibrary(this.getSelectedLibrary());
    }

    protected void readFromDataModel() {
        this.checkValidity();
    }

    protected String getPanelName() {
        return SelectLibraryPanel.getMessage("LBL_SelectLibraryPanel_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(SelectLibraryPanel.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SelectLibraryPanel.class, (String)string);
    }
}

