/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEntry
implements ModuleEntry {
    private String localizedName;
    private Set<String> publicClassNames;

    AbstractEntry() {
    }

    protected abstract LocalizedBundleInfo getBundleInfo();

    @Override
    public String getLocalizedName() {
        if (this.localizedName == null) {
            this.localizedName = this.getBundleInfo().getDisplayName();
            if (this.localizedName == null) {
                this.localizedName = this.getCodeNameBase();
            }
        }
        return this.localizedName;
    }

    @Override
    public String getCategory() {
        return this.getBundleInfo().getCategory();
    }

    @Override
    public String getShortDescription() {
        return this.getBundleInfo().getShortDescription();
    }

    @Override
    public String getLongDescription() {
        return this.getBundleInfo().getLongDescription();
    }

    public int compareTo(Object object) {
        int n = this.getLocalizedName().compareTo(((ModuleEntry)object).getLocalizedName());
        return n != 0 ? n : this.getCodeNameBase().compareTo(((ModuleEntry)object).getCodeNameBase());
    }

    @Override
    public synchronized Set<String> getPublicClassNames() {
        if (this.publicClassNames == null) {
            try {
                this.publicClassNames = this.computePublicClassNamesInMainModule();
                String[] stringArray = PropertyUtils.tokenizePath((String)this.getClassPathExtensions());
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    if (!file.isFile()) {
                        Util.err.log(16, "Could not find Class-Path extension " + file + " of " + this);
                        continue;
                    }
                    this.scanJarForPublicClassNames(this.publicClassNames, file);
                }
            }
            catch (IOException iOException) {
                this.publicClassNames = Collections.emptySet();
                Util.err.annotate((Throwable)iOException, 0, "While scanning for public classes in " + this, null, null, null);
                Util.err.notify(1, (Throwable)iOException);
            }
        }
        return this.publicClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanJarForPublicClassNames(Set<String> set, File file) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ManifestManager.PackageExport object2 : this.getPublicPackages()) {
            String string = object2.getPackage().replace('.', '/') + '/';
            if (object2.isRecursive()) {
                arrayList.add(string);
                continue;
            }
            hashSet.add(string);
        }
        JarFile jarFile = new JarFile(file);
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            block4: while (enumeration.hasMoreElements()) {
                Object object;
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.endsWith(".class") || (n = string.lastIndexOf(47)) == -1) continue;
                String string2 = string.substring(0, n + 1);
                if (!hashSet.contains(string2)) {
                    boolean bl = false;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        if (!string2.startsWith((String)object.next())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    char c = ((String)object).charAt(0);
                    if (c < '0' || c > '9') continue;
                    continue block4;
                }
                if (!AbstractEntry.isPublic(jarFile, jarEntry)) continue;
                set.add(string.substring(0, string.length() - 6).replace('/', '.'));
            }
        }
        finally {
            jarFile.close();
        }
    }

    protected abstract Set<String> computePublicClassNamesInMainModule() throws IOException;

    protected static boolean isDeclaredAsFriend(String[] stringArray, String string) {
        return stringArray == null ? true : Arrays.binarySearch(stringArray, string) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPublic(JarFile jarFile, JarEntry jarEntry) throws IOException {
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            AbstractEntry.skip(dataInputStream, 8);
            int n3 = dataInputStream.readUnsignedShort() - 1;
            block9: for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readByte();
                switch (n) {
                    case 1: {
                        dataInputStream.readUTF();
                        continue block9;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        AbstractEntry.skip(dataInputStream, 4);
                        continue block9;
                    }
                    case 7: 
                    case 8: {
                        AbstractEntry.skip(dataInputStream, 2);
                        continue block9;
                    }
                    case 5: 
                    case 6: {
                        AbstractEntry.skip(dataInputStream, 8);
                        ++n2;
                        continue block9;
                    }
                    default: {
                        throw new IOException("Unrecognized constant pool tag " + n + " at index " + n2);
                    }
                }
            }
            n2 = dataInputStream.readUnsignedShort();
            n = (n2 & 1) > 0 ? 1 : 0;
            return n != 0;
        }
        finally {
            inputStream.close();
        }
    }

    private static void skip(DataInput dataInput, int n) throws IOException {
        int n2 = dataInput.skipBytes(n);
        if (n2 != n) {
            throw new IOException();
        }
    }

    @Override
    public URL getJavadoc(NbPlatform nbPlatform) {
        if (nbPlatform == null) {
            return null;
        }
        String string = this.getCodeNameBase().replace('.', '-');
        URL[] uRLArray = nbPlatform.getJavadocRoots();
        return uRLArray == null ? null : Util.findJavadocURL(string, uRLArray);
    }
}

