/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;

public class JavadocRootsSupport
implements JavadocRootsProvider {
    private URL[] javadocRoots;
    private JavadocRootsProvider delegate;
    private PropertyChangeSupport pcs;

    public JavadocRootsSupport(URL[] uRLArray, JavadocRootsProvider javadocRootsProvider) {
        if (uRLArray == null) {
            throw new NullPointerException("javadocRoots must not be null.");
        }
        this.javadocRoots = uRLArray;
        this.pcs = new PropertyChangeSupport(this);
        this.delegate = javadocRootsProvider;
    }

    public URL[] getDefaultJavadocRoots() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDefaultJavadocRoots();
    }

    public URL[] getJavadocRoots() {
        URL[] uRLArray;
        if (this.javadocRoots.length == 0 && (uRLArray = this.getDefaultJavadocRoots()) != null) {
            return uRLArray;
        }
        return this.javadocRoots;
    }

    private void maybeUpdateDefaultJavadoc() {
        URL[] uRLArray;
        if (this.javadocRoots.length == 0 && (uRLArray = this.getDefaultJavadocRoots()) != null) {
            this.javadocRoots = uRLArray;
            this.pcs.firePropertyChange("javadocRoots", null, null);
        }
    }

    public void addJavadocRoot(URL uRL) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        URL[] uRLArray = new URL[this.javadocRoots.length + 1];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[this.javadocRoots.length] = uRL;
        this.setJavadocRootsInternal(uRLArray);
    }

    public void removeJavadocRoots(URL[] uRLArray) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(this.javadocRoots));
        arrayList.removeAll(Arrays.asList(uRLArray));
        URL[] uRLArray2 = new URL[arrayList.size()];
        this.setJavadocRootsInternal(arrayList.toArray(uRLArray2));
    }

    public void moveJavadocRootUp(int n) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        if (n <= 0) {
            return;
        }
        URL[] uRLArray = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[n - 1] = this.javadocRoots[n];
        uRLArray[n] = this.javadocRoots[n - 1];
        this.setJavadocRootsInternal(uRLArray);
    }

    public void moveJavadocRootDown(int n) throws IOException {
        this.maybeUpdateDefaultJavadoc();
        if (n >= this.javadocRoots.length - 1) {
            return;
        }
        URL[] uRLArray = new URL[this.javadocRoots.length];
        System.arraycopy(this.javadocRoots, 0, uRLArray, 0, this.javadocRoots.length);
        uRLArray[n + 1] = this.javadocRoots[n];
        uRLArray[n] = this.javadocRoots[n + 1];
        this.setJavadocRootsInternal(uRLArray);
    }

    private void setJavadocRootsInternal(URL[] uRLArray) throws IOException {
        if (this.delegate != null) {
            this.delegate.setJavadocRoots(uRLArray);
        } else {
            this.setJavadocRoots(uRLArray);
        }
    }

    public void setJavadocRoots(URL[] uRLArray) throws IOException {
        this.javadocRoots = uRLArray;
        this.pcs.firePropertyChange("javadocRoots", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

