/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsSupport;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NbPlatform
implements SourceRootsProvider,
JavadocRootsProvider {
    private static final String PLATFORM_PREFIX = "nbplatform.";
    private static final String PLATFORM_DEST_DIR_SUFFIX = ".netbeans.dest.dir";
    private static final String PLATFORM_LABEL_SUFFIX = ".label";
    public static final String PLATFORM_SOURCES_SUFFIX = ".sources";
    public static final String PLATFORM_JAVADOC_SUFFIX = ".javadoc";
    private static final String PLATFORM_HARNESS_DIR_SUFFIX = ".harness.dir";
    public static final String PLATFORM_ID_DEFAULT = "default";
    private static Set<NbPlatform> platforms;
    private final PropertyChangeSupport pcs;
    private final SourceRootsSupport srs;
    private final JavadocRootsSupport jrs;
    public static final int HARNESS_VERSION_UNKNOWN = 0;
    public static final int HARNESS_VERSION_50 = 1;
    public static final int HARNESS_VERSION_50u1 = 2;
    public static final int HARNESS_VERSION_55u1 = 3;
    public static final int HARNESS_VERSION_60 = 4;
    public static final int HARNESS_VERSION_61 = 5;
    public static final int HARNESS_VERSION_65 = 6;
    public static final int HARNESS_VERSION_67 = 7;
    private final String id;
    private String label;
    private File nbdestdir;
    private File harness;
    private URL[] javadocRoots;
    private int harnessVersion = -1;
    private URL[] defaultSourceRoots;

    public static void reset() {
        platforms = null;
    }

    public static synchronized Set<NbPlatform> getPlatforms() {
        return new HashSet<NbPlatform>(NbPlatform.getPlatformsInternal());
    }

    private static Set<NbPlatform> getPlatformsInternal() {
        if (platforms == null) {
            platforms = new HashSet<NbPlatform>();
            Map map = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.globalPropertyProvider()}).getProperties();
            if (map == null) {
                map = Collections.emptyMap();
            }
            boolean bl = false;
            Object object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String string = (String)entry.getKey();
                if (!string.startsWith(PLATFORM_PREFIX) || !string.endsWith(PLATFORM_DEST_DIR_SUFFIX)) continue;
                String string2 = string.substring(PLATFORM_PREFIX.length(), string.length() - PLATFORM_DEST_DIR_SUFFIX.length());
                String string3 = (String)map.get(PLATFORM_PREFIX + string2 + PLATFORM_LABEL_SUFFIX);
                String string4 = (String)entry.getValue();
                String string5 = (String)map.get(PLATFORM_PREFIX + string2 + PLATFORM_HARNESS_DIR_SUFFIX);
                String string6 = (String)map.get(PLATFORM_PREFIX + string2 + PLATFORM_SOURCES_SUFFIX);
                String string7 = (String)map.get(PLATFORM_PREFIX + string2 + PLATFORM_JAVADOC_SUFFIX);
                File file = FileUtil.normalizeFile((File)new File(string4));
                File file2 = string5 != null ? FileUtil.normalizeFile((File)new File(string5)) : NbPlatform.findHarness(file);
                platforms.add(new NbPlatform(string2, string3, file, file2, Util.findURLs(string6), Util.findURLs(string7)));
                bl |= string2.equals(PLATFORM_ID_DEFAULT);
            }
            if (!bl && (object = NbPlatform.defaultPlatformLocation()) != null) {
                platforms.add(new NbPlatform(PLATFORM_ID_DEFAULT, null, (File)object, NbPlatform.findHarness((File)object), new URL[0], new URL[0]));
            }
            if (Util.err.isLoggable(1)) {
                Util.err.log("NbPlatform initial list: " + platforms);
            }
        }
        return platforms;
    }

    public static NbPlatform getDefaultPlatform() {
        return NbPlatform.getPlatformByID(PLATFORM_ID_DEFAULT);
    }

    public static File defaultPlatformLocation() {
        File file = InstalledFileLocator.getDefault().locate("core/core.jar", "org.netbeans.core.startup", false);
        if (file == null) {
            if (Util.err.isLoggable(1)) {
                Util.err.log("no core/core.jar");
            }
            return null;
        }
        File file2 = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-apisupport-harness.jar", "org.netbeans.modules.apisupport.harness", false);
        if (file2 == null) {
            ErrorManager.getDefault().log(16, "Cannot resolve default platform. Probably either \"org.netbeans.modules.apisupport.harness\" module is missing or is corrupted.");
            return null;
        }
        File file3 = file2.getParentFile().getParentFile().getParentFile();
        try {
            if (!file3.getCanonicalFile().equals(file.getParentFile().getParentFile().getParentFile().getCanonicalFile())) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("core.jar & harness.jar locations do not match: " + file + " vs. " + file2);
                }
                return null;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return FileUtil.normalizeFile((File)file3);
    }

    public static synchronized NbPlatform getPlatformByID(String string) {
        for (NbPlatform nbPlatform : NbPlatform.getPlatformsInternal()) {
            if (!nbPlatform.getID().equals(string)) continue;
            return nbPlatform;
        }
        return null;
    }

    public static synchronized NbPlatform getPlatformByDestDir(File file) {
        File file2;
        File file3;
        for (NbPlatform object2 : NbPlatform.getPlatformsInternal()) {
            int file22 = object2.getDestDir().compareTo(file);
            if (!object2.getDestDir().equals(file)) continue;
            return object2;
        }
        URL[] uRLArray = new URL[]{};
        if (file.getName().equals("netbeans") && (file3 = file.getParentFile()) != null && file3.getName().equals("nbbuild") && (file2 = file3.getParentFile()) != null && ModuleList.isNetBeansOrg(file2)) {
            uRLArray = new URL[]{FileUtil.urlForArchiveOrDir((File)file2)};
        }
        return new NbPlatform(null, null, file, NbPlatform.findHarness(file), uRLArray, new URL[0]);
    }

    private static File findHarness(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!NbPlatform.isHarness(fileArray[i])) continue;
                return fileArray[i];
            }
        }
        return new File(file, "harness");
    }

    public static boolean isHarness(File file) {
        return new File(file, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar").isFile();
    }

    public static synchronized boolean contains(File file) {
        boolean bl = false;
        for (NbPlatform nbPlatform : NbPlatform.getPlatformsInternal()) {
            if (!nbPlatform.getDestDir().equals(file)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static NbPlatform addPlatform(String string, File file, String string2) throws IOException {
        return NbPlatform.addPlatform(string, file, NbPlatform.findHarness(file), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NbPlatform addPlatform(final String string, final File file, final File file2, final String string2) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (NbPlatform.getPlatformByID(string) != null) {
                        throw new IOException("ID " + string + " already taken");
                    }
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    String string3 = NbPlatform.PLATFORM_PREFIX + string + NbPlatform.PLATFORM_DEST_DIR_SUFFIX;
                    editableProperties.setProperty(string3, file.getAbsolutePath());
                    if (!file.isDirectory()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                    NbPlatform.storeHarnessLocation(string, file, file2, editableProperties);
                    editableProperties.setProperty(NbPlatform.PLATFORM_PREFIX + string + NbPlatform.PLATFORM_LABEL_SUFFIX, string2);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        NbPlatform nbPlatform = new NbPlatform(string, string2, FileUtil.normalizeFile((File)file), file2, Util.findURLs(null), Util.findURLs(null));
        Class<NbPlatform> clazz = NbPlatform.class;
        synchronized (NbPlatform.class) {
            NbPlatform.getPlatformsInternal().add(nbPlatform);
            // ** MonitorExit[var5_6] (shouldn't be in output)
            if (Util.err.isLoggable(1)) {
                Util.err.log("NbPlatform added: " + nbPlatform);
            }
            return nbPlatform;
        }
    }

    private static void storeHarnessLocation(String string, File file, File file2, EditableProperties editableProperties) {
        String string2 = PLATFORM_PREFIX + string + PLATFORM_HARNESS_DIR_SUFFIX;
        if (file2.equals(NbPlatform.findHarness(file))) {
            String string3 = PLATFORM_PREFIX + string + PLATFORM_DEST_DIR_SUFFIX;
            editableProperties.setProperty(string2, "${" + string3 + "}/" + file2.getName());
        } else if (NbPlatform.getDefaultPlatform() != null && file2.equals(NbPlatform.getDefaultPlatform().getHarnessLocation())) {
            editableProperties.setProperty(string2, "${nbplatform.default.harness.dir}");
        } else {
            editableProperties.setProperty(string2, file2.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlatform(final NbPlatform nbPlatform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_DEST_DIR_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_HARNESS_DIR_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_LABEL_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_SOURCES_SUFFIX));
                    editableProperties.remove((Object)(NbPlatform.PLATFORM_PREFIX + nbPlatform.getID() + NbPlatform.PLATFORM_JAVADOC_SUFFIX));
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        Class<NbPlatform> clazz = NbPlatform.class;
        synchronized (NbPlatform.class) {
            NbPlatform.getPlatformsInternal().remove(nbPlatform);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            if (Util.err.isLoggable(1)) {
                Util.err.log("NbPlatform removed: " + nbPlatform);
            }
            return;
        }
    }

    private NbPlatform(String string, String string2, File file, File file2, URL[] uRLArray, URL[] uRLArray2) {
        this.id = string;
        this.label = string2;
        this.nbdestdir = file;
        this.harness = file2;
        this.javadocRoots = uRLArray2;
        this.pcs = new PropertyChangeSupport(this);
        this.srs = new SourceRootsSupport(uRLArray, this);
        this.srs.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NbPlatform.this.pcs.firePropertyChange(propertyChangeEvent);
            }
        });
        this.jrs = new JavadocRootsSupport(uRLArray2, this);
        this.jrs.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NbPlatform.this.pcs.firePropertyChange(propertyChangeEvent);
            }
        });
    }

    public String getID() {
        return this.id;
    }

    public boolean isDefault() {
        return PLATFORM_ID_DEFAULT.equals(this.id);
    }

    public String getLabel() {
        if (this.label == null) {
            try {
                this.label = this.isValid() ? NbPlatform.computeDisplayName(this.nbdestdir) : NbBundle.getMessage(NbPlatform.class, (String)"MSG_InvalidPlatform", (Object)this.getDestDir().getAbsolutePath());
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
                this.label = this.nbdestdir.getAbsolutePath();
            }
        }
        if (this.isDefault()) {
            return NbBundle.getMessage(NbPlatform.class, (String)"LBL_default_platform", (Object)this.label);
        }
        return this.label;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public void setDestDir(File file) {
        this.nbdestdir = file;
    }

    @Override
    public URL[] getDefaultJavadocRoots() {
        if (!this.isDefault()) {
            return null;
        }
        File file = InstalledFileLocator.getDefault().locate("docs/NetBeansAPIs.zip", "org.netbeans.modules.apisupport.apidocs", true);
        if (file != null) {
            return new URL[]{FileUtil.urlForArchiveOrDir((File)file)};
        }
        return new URL[0];
    }

    @Override
    public void addJavadocRoot(URL uRL) throws IOException {
        this.jrs.addJavadocRoot(uRL);
    }

    @Override
    public URL[] getJavadocRoots() {
        return this.jrs.getJavadocRoots();
    }

    @Override
    public void moveJavadocRootDown(int n) throws IOException {
        this.jrs.moveJavadocRootDown(n);
    }

    @Override
    public void moveJavadocRootUp(int n) throws IOException {
        this.jrs.moveJavadocRootUp(n);
    }

    @Override
    public void removeJavadocRoots(URL[] uRLArray) throws IOException {
        this.jrs.removeJavadocRoots(uRLArray);
    }

    @Override
    public void setJavadocRoots(URL[] uRLArray) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_JAVADOC_SUFFIX, Util.urlsToAntPath(uRLArray));
        this.jrs.setJavadocRoots(uRLArray);
    }

    @Override
    public URL[] getDefaultSourceRoots() {
        block5: {
            if (!this.isDefault()) {
                return null;
            }
            if (this.defaultSourceRoots != null) {
                return this.defaultSourceRoots;
            }
            File file = this.getDestDir();
            if (file.getName().equals("netbeans") && file.getParentFile().getName().equals("nbbuild")) {
                try {
                    this.defaultSourceRoots = new URL[]{file.getParentFile().getParentFile().toURI().toURL()};
                }
                catch (MalformedURLException malformedURLException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)malformedURLException);
                }
            }
        }
        this.defaultSourceRoots = new URL[0];
        return this.defaultSourceRoots;
    }

    @Override
    public URL[] getSourceRoots() {
        return this.srs.getSourceRoots();
    }

    @Override
    public void addSourceRoot(URL uRL) throws IOException {
        this.srs.addSourceRoot(uRL);
    }

    @Override
    public void removeSourceRoots(URL[] uRLArray) throws IOException {
        this.srs.removeSourceRoots(uRLArray);
    }

    @Override
    public void moveSourceRootUp(int n) throws IOException {
        this.srs.moveSourceRootUp(n);
    }

    @Override
    public void moveSourceRootDown(int n) throws IOException {
        this.srs.moveSourceRootDown(n);
    }

    @Override
    public void setSourceRoots(URL[] uRLArray) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_SOURCES_SUFFIX, Util.urlsToAntPath(uRLArray));
        this.srs.setSourceRoots(uRLArray);
    }

    public boolean isValid() {
        return NbPlatform.isPlatformDirectory(this.getDestDir());
    }

    private void putGlobalProperty(final String string, final String string2) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    if ("".equals(string2)) {
                        editableProperties.remove((Object)string);
                    } else {
                        editableProperties.setProperty(string, string2);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    @Override
    public File getSourceLocationOfModule(File file) {
        return this.srs.getSourceLocationOfModule(file);
    }

    public ModuleEntry[] getSortedModules() {
        TreeSet<ModuleEntry> treeSet = new TreeSet<ModuleEntry>(this.getModules());
        ModuleEntry[] moduleEntryArray = new ModuleEntry[treeSet.size()];
        treeSet.toArray(moduleEntryArray);
        return moduleEntryArray;
    }

    public Set<ModuleEntry> getModules() {
        try {
            return ModuleList.findOrCreateModuleListFromBinaries(this.getDestDir()).getAllEntriesSoft();
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
            return Collections.emptySet();
        }
    }

    public ModuleEntry getModule(String string) {
        try {
            return ModuleList.findOrCreateModuleListFromBinaries(this.getDestDir()).getEntry(string);
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
            return null;
        }
    }

    private static File findCoreJar(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2;
                if (!fileArray[i].isDirectory() || !fileArray[i].getName().startsWith("platform") || !(file2 = new File(fileArray[i], "core" + File.separatorChar + "core.jar")).isFile()) continue;
                return file2;
            }
        }
        return null;
    }

    public static boolean isPlatformDirectory(File file) {
        return NbPlatform.findCoreJar(file) != null;
    }

    public static boolean isSupportedPlatform(File file) {
        boolean bl = false;
        File file2 = NbPlatform.findCoreJar(file);
        if (file2 != null) {
            String string = file2.getParentFile().getParentFile().getName();
            assert (string.startsWith("platform"));
            int n = Integer.parseInt(string.substring(8));
            bl = n >= 6;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDisplayName(File file) throws IOException {
        String string;
        String string2;
        File file2 = NbPlatform.findCoreJar(file);
        if (file2 == null) {
            throw new IllegalArgumentException(file.getAbsolutePath());
        }
        JarFile jarFile = new JarFile(file2);
        try {
            string2 = NbPlatform.findCurrVer(jarFile, "");
            if (string2 == null) {
                throw new IOException(file2.getAbsolutePath());
            }
            string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Build-Version");
            if (string == null) {
                string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            if (string == null) {
                throw new IOException(file2.getAbsolutePath());
            }
        }
        finally {
            jarFile.close();
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            block6: for (int i = 0; i < fileArray.length; ++i) {
                String[] stringArray;
                File file3 = new File(fileArray[i], "core" + File.separatorChar + "locale");
                if (!file3.isDirectory() || (stringArray = file3.list()) == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string3;
                    int n;
                    String string4 = stringArray[j];
                    String string5 = "core";
                    String string6 = ".jar";
                    if (!string4.startsWith(string5) || !string4.endsWith(string6) || (n = (string3 = string4.substring(string5.length(), string4.length() - string6.length())).lastIndexOf(95)) == -1) continue;
                    String string7 = string3.substring(n + 1);
                    if (Arrays.asList(Locale.getISOCountries()).contains(string7) || !string7.equals("nb") && Arrays.asList(Locale.getISOLanguages()).contains(string7)) continue;
                    jarFile = new JarFile(new File(file3, string4));
                    try {
                        String string8 = NbPlatform.findCurrVer(jarFile, string3);
                        if (string8 == null) continue;
                        string2 = string8;
                        break block6;
                    }
                    finally {
                        jarFile.close();
                    }
                }
            }
        }
        return MessageFormat.format(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findCurrVer(JarFile jarFile, String string) throws IOException {
        ZipEntry zipEntry = jarFile.getEntry("org/netbeans/core/startup/Bundle" + string + ".properties");
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("org/netbeans/core/Bundle" + string + ".properties");
        }
        if (zipEntry == null) {
            return null;
        }
        Properties properties = new Properties();
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties.getProperty("currentVersion");
    }

    public static boolean isLabelValid(String string) {
        if (string == null) {
            return false;
        }
        for (NbPlatform nbPlatform : NbPlatform.getPlatforms()) {
            String string2 = nbPlatform.getLabel();
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "NbPlatform[" + this.getID() + ":" + this.getDestDir() + ";sources=" + Arrays.asList(this.getSourceRoots()) + ";javadoc=" + Arrays.asList(this.getJavadocRoots()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getHarnessVersion() {
        if (this.harnessVersion != -1) {
            return this.harnessVersion;
        }
        if (!this.isValid()) {
            this.harnessVersion = 0;
            return 0;
        }
        File file = new File(this.harness, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar");
        if (file.isFile()) {
            try {
                JarFile jarFile = new JarFile(file);
                try {
                    String string = jarFile.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                    if (string != null) {
                        SpecificationVersion specificationVersion = new SpecificationVersion(string);
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.14")) >= 0) {
                            this.harnessVersion = 7;
                            int n = 7;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.12")) >= 0) {
                            this.harnessVersion = 6;
                            int n = 6;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.11")) >= 0) {
                            this.harnessVersion = 5;
                            int n = 5;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.10")) >= 0) {
                            this.harnessVersion = 4;
                            int n = 4;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.9")) >= 0) {
                            this.harnessVersion = 3;
                            int n = 3;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.7")) >= 0) {
                            this.harnessVersion = 2;
                            int n = 2;
                            return n;
                        }
                        if (specificationVersion.compareTo((Object)new SpecificationVersion("1.6")) >= 0) {
                            this.harnessVersion = 1;
                            int n = 1;
                            return n;
                        }
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
            catch (NumberFormatException numberFormatException) {
                Util.err.notify(1, (Throwable)numberFormatException);
            }
        }
        this.harnessVersion = 0;
        return 0;
    }

    public File getHarnessLocation() {
        return this.harness;
    }

    public File getBundledHarnessLocation() {
        return NbPlatform.findHarness(this.nbdestdir);
    }

    public void setHarnessLocation(final File file) throws IOException {
        if (file.equals(this.harness)) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties editableProperties = PropertyUtils.getGlobalProperties();
                    NbPlatform.storeHarnessLocation(NbPlatform.this.id, NbPlatform.this.nbdestdir, file, editableProperties);
                    PropertyUtils.putGlobalProperties((EditableProperties)editableProperties);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
        this.harness = file;
        this.harnessVersion = -1;
    }

    public static String getHarnessVersionDisplayName(int n) {
        switch (n) {
            case 1: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_5.0");
            }
            case 2: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_5.0u1");
            }
            case 3: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_5.5u1");
            }
            case 4: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_6.0");
            }
            case 5: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_6.1");
            }
            case 6: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_6.5");
            }
            case 7: {
                return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_6.7");
            }
        }
        assert (n == 0);
        return NbBundle.getMessage(NbPlatform.class, (String)"LBL_harness_version_unknown");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

