/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.editor.EditorUI;
import org.openide.util.Exceptions;

public class HTMLDocView
extends JEditorPane {
    private HTMLEditorKit htmlKit;
    private int selectionAnchor = 0;
    private Object highlight = null;

    public HTMLDocView(Color color) {
        this.setEditable(false);
        this.setFocusable(true);
        this.setBackground(color);
        this.setMargin(new Insets(0, 3, 3, 3));
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HTMLDocView.this.getHighlighter().removeAllHighlights();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                HTMLDocView.this.getHighlighter().removeAllHighlights();
                HTMLDocView.this.selectionAnchor = HTMLDocView.this.positionCaret(mouseEvent);
                try {
                    HTMLDocView.this.highlight = HTMLDocView.this.getHighlighter().addHighlight(HTMLDocView.this.selectionAnchor, HTMLDocView.this.selectionAnchor, DefaultHighlighter.DefaultPainter);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                try {
                    if (HTMLDocView.this.selectionAnchor <= HTMLDocView.this.positionCaret(mouseEvent)) {
                        HTMLDocView.this.getHighlighter().changeHighlight(HTMLDocView.this.highlight, HTMLDocView.this.selectionAnchor, HTMLDocView.this.positionCaret(mouseEvent));
                    } else {
                        HTMLDocView.this.getHighlighter().changeHighlight(HTMLDocView.this.highlight, HTMLDocView.this.positionCaret(mouseEvent), HTMLDocView.this.selectionAnchor);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
    }

    private int positionCaret(MouseEvent mouseEvent) {
        int n = this.viewToModel(mouseEvent.getPoint());
        return n;
    }

    public void setContent(final String string, final String string2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringReader stringReader = new StringReader("<HTML><BODY>" + string + "</BODY></HTML>");
                try {
                    Document document = HTMLDocView.this.getDocument();
                    document.remove(0, document.getLength());
                    HTMLDocView.this.getEditorKit().read(stringReader, HTMLDocView.this.getDocument(), 0);
                    HTMLDocView.this.setCaretPosition(0);
                    if (string2 != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                HTMLDocView.this.scrollToReference(string2);
                            }
                        });
                    } else {
                        HTMLDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
            if (this.htmlKit.getStyleSheet().getStyleSheets() != null) {
                this.setBodyFontInCSS();
                return this.htmlKit;
            }
            this.setBodyFontInCSS();
        }
        return this.htmlKit;
    }

    private void setBodyFontInCSS() {
        StyleSheet styleSheet = new StyleSheet();
        Font font = new EditorUI().getDefaultColoring().getFont();
        styleSheet.addRule("body { font-size: " + font.getSize() + "; font-family: " + this.getFont().getFamily() + ("; color: " + HTMLDocView.getForegroundColor() + ";}"));
        styleSheet.addStyleSheet(this.htmlKit.getStyleSheet());
        this.htmlKit.setStyleSheet(styleSheet);
    }

    private static String getForegroundColor() {
        Color color = UIManager.getColor("textText");
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        StringBuilder stringBuilder = new StringBuilder("#");
        for (int n : nArray) {
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                string = '0' + string;
            } else if (string.length() < 1) {
                string = "00";
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

