/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.print.ui.UI;

public final class Percent
extends JComboBox
implements ActionListener {
    private Listener myListener;
    private String[] myCustoms;
    private String myCurrentText;
    private double myCurrentValue;
    private static final int BOUND_1 = 1000;
    private static final int BOUND_2 = 2000;
    private static final double FACTOR = 1.09;
    private static final double THRESHOLD = 0.2;
    private static final double SUBTRAHEND = 0.01;
    private static final double MIN_VALUE = 0.01;
    private static final double MAX_VALUE = 15.0;
    private static final String CUSTOM = "custom";
    private static final String NORMAL = "normal";
    private static final String INCREASE = "increase";
    private static final String DECREASE = "decrease";
    private static final double YUZ = 100.0;
    private static final String PERCENT = "%";

    public Percent(Listener listener, double d, int[] nArray, final int n, String[] stringArray, String string) {
        for (int n2 : nArray) {
            this.addItem(n2 + PERCENT);
        }
        if (stringArray != null) {
            for (int n3 : (Object)stringArray) {
                this.addItem(n3);
            }
        }
        this.setToolTipText(string);
        this.setEditable(true);
        this.myCustoms = stringArray;
        this.myListener = listener;
        Object object = (JTextComponent)this.getEditor().getEditorComponent();
        InputMap inputMap = ((JComponent)object).getInputMap();
        ActionMap actionMap = ((JComponent)object).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke('+'), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('='), INCREASE);
        inputMap.put(KeyStroke.getKeyStroke('-'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('_'), DECREASE);
        inputMap.put(KeyStroke.getKeyStroke('/'), NORMAL);
        inputMap.put(KeyStroke.getKeyStroke('*'), CUSTOM);
        actionMap.put(INCREASE, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Percent.this.increaseValue();
            }
        });
        actionMap.put(DECREASE, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Percent.this.decreaseValue();
            }
        });
        actionMap.put(NORMAL, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Percent.this.normalValue();
            }
        });
        actionMap.put(CUSTOM, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Percent.this.customValue(n);
            }
        });
        this.addActionListener(this);
        this.setValue(d);
        this.selectValue();
    }

    private void selectValue() {
        String string = this.getEditorItem();
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!string.equals(this.getItemAt(i))) continue;
            this.setSelectedIndex(i);
        }
    }

    public boolean isCustomValue() {
        return this.getCustomIndex(this.getEditorItem()) != -1;
    }

    public String getEditorItem() {
        return this.getEditor().getItem().toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.getEditorItem();
        int n = this.getCustomIndex(string);
        if (n != -1) {
            this.valueChanged(this.getCustomValue(n), n);
            return;
        }
        double d = this.parsePercent(string);
        if (this.isValid(d)) {
            int n2 = this.getCustomIndex(d);
            if (n2 != -1) {
                this.setValue(d, n2);
            } else {
                this.valueChanged(d, n2);
            }
        } else {
            this.myListener.invalidValue(string);
            this.setText(this.myCurrentText);
        }
    }

    private int getCustomIndex(String string) {
        if (this.myCustoms == null) {
            return -1;
        }
        for (int i = 0; i < this.myCustoms.length; ++i) {
            if (!this.myCustoms[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public double getValue() {
        return this.myCurrentValue;
    }

    public void increaseValue() {
        if (this.myCurrentValue < 0.2) {
            this.setValue(this.myCurrentValue + 0.01);
        } else {
            this.setValue(this.myCurrentValue * 1.09);
        }
    }

    public void decreaseValue() {
        if (this.myCurrentValue > 0.2) {
            this.setValue(this.myCurrentValue / 1.09);
        } else {
            this.setValue(this.myCurrentValue - 0.01);
        }
    }

    public void normalValue() {
        this.setValue(1.0);
    }

    public void customValue(int n) {
        this.setValue(this.getCustomValue(n), n);
    }

    public void setValue(double d) {
        this.setValue(d, this.getCustomIndex(d));
    }

    private void setValue(double d, int n) {
        String string = this.valueChanged(d, n);
        if (string != null) {
            this.setText(string);
        }
    }

    private String valueChanged(double d, int n) {
        boolean bl;
        boolean bl2 = bl = n != -1;
        if (!bl && !this.isValid(d)) {
            return null;
        }
        this.myCurrentValue = d;
        this.myCurrentText = bl && this.myCustoms != null ? this.myCustoms[n] : this.getPercent(d);
        this.myListener.valueChanged(d, n);
        return this.myCurrentText;
    }

    private void setText(String string) {
        this.getEditor().setItem(string);
    }

    private int getCustomIndex(double d) {
        if (this.myCustoms == null) {
            return -1;
        }
        for (int i = 0; i < this.myCustoms.length; ++i) {
            if (!this.getPercent(d).equals(this.getPercent(this.getCustomValue(i)))) continue;
            return i;
        }
        return -1;
    }

    private boolean isValid(double d) {
        return 0.01 <= d && d <= 15.0;
    }

    private double getCustomValue(int n) {
        return this.myListener.getCustomValue(n);
    }

    private double parsePercent(String string) {
        String string2 = string;
        if (string2.endsWith(PERCENT)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return (double)UI.getInt(string2.trim()) / 100.0;
    }

    private String getPercent(double d) {
        return (int)Math.round(100.0 * d) + PERCENT;
    }

    public static double getZoomFactor(double d, double d2) {
        if (0.0 < d && d <= 15.0) {
            return d;
        }
        return d2;
    }

    public static int getZoomWidth(double d, int n) {
        if (1000.0 <= d && d < 2000.0) {
            return UI.round(d - 1000.0);
        }
        return n;
    }

    public static int getZoomHeight(double d, int n) {
        if (2000.0 <= d) {
            return UI.round(d - 2000.0);
        }
        return n;
    }

    public static boolean isZoomFactor(double d) {
        return d < 1000.0;
    }

    public static boolean isZoomWidth(double d) {
        return 1000.0 <= d && d < 2000.0;
    }

    public static boolean isZoomHeight(double d) {
        return 2000.0 <= d;
    }

    public static boolean isZoomPage(double d) {
        return d == 0.0;
    }

    public static double createZoomWidth(double d) {
        return 1000.0 + d;
    }

    public static double createZoomHeight(double d) {
        return 2000.0 + d;
    }

    public static interface Listener {
        public double getCustomValue(int var1);

        public void valueChanged(double var1, int var3);

        public void invalidValue(String var1);
    }
}

