/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.databinding;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.DatabindingCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetConnectorCD;
import org.netbeans.modules.vmd.midp.components.databinding.IndexableDataAbstractSetCD;
import org.netbeans.modules.vmd.midp.components.databinding.IndexableDataSetIndexCD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MidpDatabindingSupport {
    private MidpDatabindingSupport() {
    }

    public static DesignComponent getConnector(DesignComponent designComponent, String string) {
        DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), DatabindingCategoryCD.TYPEID);
        for (DesignComponent designComponent3 : designComponent2.getComponents()) {
            for (DesignComponent designComponent4 : designComponent3.getComponents()) {
                if (designComponent4.getType() != DataSetConnectorCD.TYPEID) continue;
                String string2 = (String)designComponent4.readProperty("property").getPrimitiveValue();
                Long l = (Long)designComponent4.readProperty("referencedComponent").getPrimitiveValue();
                if (!string2.equals(string) || l == null || designComponent.getComponentID() != l.longValue()) continue;
                return designComponent4;
            }
        }
        return null;
    }

    public static Collection<DesignComponent> getAllRelatedConnectors(DesignComponent designComponent) {
        DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), DatabindingCategoryCD.TYPEID);
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        for (DesignComponent designComponent3 : designComponent2.getComponents()) {
            for (DesignComponent designComponent4 : designComponent3.getComponents()) {
                Long l;
                if (designComponent4.getType() != DataSetConnectorCD.TYPEID || (l = (Long)designComponent4.readProperty("referencedComponent").getPrimitiveValue()) == null || designComponent.getComponentID() != l.longValue()) continue;
                hashSet.add(designComponent4);
            }
        }
        return hashSet;
    }

    public static Collection<DesignComponent> getAllConnectors(DesignDocument designDocument) {
        DesignComponent designComponent = MidpDocumentSupport.getCategoryComponent(designDocument, DatabindingCategoryCD.TYPEID);
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            for (DesignComponent designComponent3 : designComponent2.getComponents()) {
                if (designComponent3.getType() != DataSetConnectorCD.TYPEID) continue;
                hashSet.add(designComponent3);
            }
        }
        return hashSet;
    }

    public static String getDatabaindingAsText(final DesignComponent designComponent, final String string) {
        if (designComponent != null) {
            final boolean[] blArray = new boolean[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    if (MidpDatabindingSupport.getConnector(designComponent, string) != null) {
                        blArray[0] = true;
                    }
                }
            });
            if (blArray[0]) {
                return "<databinding>";
            }
        }
        return null;
    }

    public static Collection<DesignComponent> getIndexes(DesignComponent designComponent) {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            if (designComponent2.getType() != IndexableDataSetIndexCD.TYPEID) continue;
            hashSet.add(designComponent2);
        }
        return hashSet;
    }

    public static DesignComponent getIndex(DesignComponent designComponent, String string) {
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            if (designComponent2.getType() != IndexableDataSetIndexCD.TYPEID || !designComponent2.readProperty("instanceName").getPrimitiveValue().equals(string)) continue;
            return designComponent2;
        }
        return null;
    }

    public static DesignComponent createIndex(DesignComponent designComponent, String string) {
        DesignComponent designComponent2 = designComponent.getDocument().createComponent(IndexableDataSetIndexCD.TYPEID);
        designComponent2.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(designComponent2, string));
        designComponent.addComponent(designComponent2);
        return designComponent2;
    }

    public static void removerUnusedIndexes(DesignDocument designDocument) {
        assert (designDocument != null);
        Collection<DesignComponent> collection = MidpDatabindingSupport.getAllConnectors(designDocument);
        Collection collection2 = MidpDocumentSupport.getCategoryComponent(designDocument, DatabindingCategoryCD.TYPEID).getComponents();
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        for (DesignComponent designComponent : collection2) {
            if (!MidpDatabindingSupport.isIndexableDataSet(designDocument, designComponent.getType())) continue;
            hashSet.addAll(MidpDatabindingSupport.getIndexes(designComponent));
        }
        for (DesignComponent designComponent : collection) {
            DesignComponent designComponent2 = designComponent.readProperty("index").getComponent();
            if (designComponent2 == null) {
                return;
            }
            hashSet.remove(designComponent2);
        }
        for (DesignComponent designComponent : hashSet) {
            designDocument.deleteComponent(designComponent);
        }
    }

    public static String getIndexName(DesignComponent designComponent) {
        DesignComponent designComponent2 = designComponent.readProperty("index").getComponent();
        String string = null;
        if (designComponent2 != null) {
            string = (String)designComponent2.readProperty("instanceName").getPrimitiveValue();
        }
        return string;
    }

    public static boolean isIndexableDataSet(DesignDocument designDocument, TypeID typeID) {
        DescriptorRegistry descriptorRegistry = designDocument.getDescriptorRegistry();
        return descriptorRegistry.isInHierarchy(IndexableDataAbstractSetCD.TYPEID, typeID);
    }

    public static synchronized void removeUnusedConnector(DesignComponent designComponent, String string) {
        DesignComponent designComponent2 = MidpDatabindingSupport.getConnector(designComponent, string);
        if (designComponent2 != null) {
            designComponent.getDocument().deleteComponent(designComponent2);
        }
    }
}

