/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.items;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.codegen.Parameter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.codegen.MidpCodeSupport;
import org.netbeans.modules.vmd.midp.codegen.MidpParameter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ItemCode {
    static final String PARAM_COMMAND = "itemCommand";
    static final String PARAM_ITEM_COMMAND_LISTENER = "itemCommandListener";
    static final String PARAM_LAYOUT = "layout";
    static final String PARAM_APPEARANCE_MODE = "appearanceMode";
    static final String PARAM_DEFAULT_COMMAND = "defaultCommand";

    public static Parameter createCommandParameter() {
        return new CommandParameter();
    }

    public static Parameter createItemCommandListenerParameter() {
        return new ItemCommandListenerParameter();
    }

    public static Parameter createItemLayoutParameter() {
        return new ItemLayoutParameter();
    }

    public static Parameter createAppearanceModeParameter() {
        return new AppearanceModeParameter();
    }

    public static Parameter createDefaultCommandParameter() {
        return new DefaultCommandParameter();
    }

    private static class DefaultCommandParameter
    implements Parameter {
        private DefaultCommandParameter() {
        }

        public String getParameterName() {
            return ItemCode.PARAM_DEFAULT_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), this.getDefaultCommand(designComponent));
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return this.getDefaultCommand(designComponent).getKind() != PropertyValue.Kind.NULL;
        }

        public int getCount(DesignComponent designComponent) {
            return -1;
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private PropertyValue getDefaultCommand(DesignComponent designComponent) {
            DesignComponent designComponent2 = designComponent.readProperty(ItemCode.PARAM_DEFAULT_COMMAND).getComponent();
            return designComponent2 != null ? designComponent2.readProperty("command") : PropertyValue.createNull();
        }
    }

    private static class AppearanceModeParameter
    extends MidpParameter {
        protected AppearanceModeParameter() {
            super(ItemCode.PARAM_APPEARANCE_MODE);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ItemCode.PARAM_APPEARANCE_MODE);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2) {
                    case 0: {
                        multiGuardedSection.getWriter().write("Item.PLAIN");
                        return;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("Item.BUTTON");
                        return;
                    }
                    case 1: {
                        multiGuardedSection.getWriter().write("Item.HYPERLINK");
                        return;
                    }
                }
                throw Debug.illegalState((Object[])new Object[0]);
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static class ItemLayoutParameter
    extends MidpParameter {
        protected ItemLayoutParameter() {
            super(ItemCode.PARAM_LAYOUT);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty(ItemCode.PARAM_LAYOUT);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                int n2 = MidpTypes.getInteger(propertyValue);
                switch (n2 & 3) {
                    case 0: {
                        multiGuardedSection.getWriter().write("ImageItem.LAYOUT_DEFAULT");
                        break;
                    }
                    case 1: {
                        multiGuardedSection.getWriter().write("ImageItem.LAYOUT_LEFT");
                        break;
                    }
                    case 2: {
                        multiGuardedSection.getWriter().write("ImageItem.LAYOUT_RIGHT");
                        break;
                    }
                    case 3: {
                        multiGuardedSection.getWriter().write("ImageItem.LAYOUT_CENTER");
                        break;
                    }
                    default: {
                        throw Debug.illegalState((Object[])new Object[0]);
                    }
                }
                if ((n2 & 0x10) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_TOP");
                }
                if ((n2 & 0x20) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_BOTTOM");
                }
                if ((n2 & 0x30) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_VCENTER");
                }
                if ((n2 & 0x100) != 0) {
                    multiGuardedSection.getWriter().write(" | ImageItem.LAYOUT_NEWLINE_BEFORE");
                }
                if ((n2 & 0x200) != 0) {
                    multiGuardedSection.getWriter().write(" | ImageItem.LAYOUT_NEWLINE_AFTER");
                }
                if ((n2 & 0x400) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_SHRINK");
                }
                if ((n2 & 0x800) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_VSHRINK");
                }
                if ((n2 & 0x1000) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_EXPAND");
                }
                if ((n2 & 0x2000) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_VEXPAND");
                }
                if ((n2 & 0x4000) != 0) {
                    multiGuardedSection.getWriter().write(" | Item.LAYOUT_2");
                }
                return;
            }
            super.generateParameterCode(designComponent, multiGuardedSection, n);
        }
    }

    private static class ItemCommandListenerParameter
    extends MidpParameter {
        private ItemCommandListenerParameter() {
            super(ItemCode.PARAM_ITEM_COMMAND_LISTENER);
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), designComponent.readProperty(ItemCode.PARAM_ITEM_COMMAND_LISTENER));
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("commands");
        }
    }

    private static class CommandParameter
    implements Parameter {
        private CommandParameter() {
        }

        public String getParameterName() {
            return ItemCode.PARAM_COMMAND;
        }

        public int getParameterPriority() {
            return 0;
        }

        public void generateParameterCode(DesignComponent designComponent, MultiGuardedSection multiGuardedSection, int n) {
            PropertyValue propertyValue = designComponent.readProperty("commands");
            List list = propertyValue.getArray();
            DesignComponent designComponent2 = ((PropertyValue)list.get(n)).getComponent();
            MidpCodeSupport.generateCodeForPropertyValue(multiGuardedSection.getWriter(), designComponent2.readProperty("command"));
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent) {
            return !designComponent.isDefaultValue("commands");
        }

        public int getCount(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty("commands");
            List list = propertyValue.getArray();
            return list.size();
        }

        public boolean isRequiredToBeSet(DesignComponent designComponent, int n) {
            return true;
        }
    }
}

