/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.eventhandler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD;
import org.netbeans.modules.vmd.midp.components.points.CallPointCD;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.components.points.MobileDeviceCD;
import org.netbeans.modules.vmd.midp.general.AcceptContextResolver;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorElementFactory;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorEventHandlerElement;
import org.netbeans.modules.vmd.midp.propertyeditors.eventhandler.ExitMidletElement;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class PropertyEditorEventHandler
extends DesignPropertyEditor {
    private static final String DO_NOTHING = NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"LBL_NOTHING_ACTION");
    private CustomEditor customEditor = null;
    private WeakReference<DesignComponent> component;
    private boolean initialized;

    private PropertyEditorEventHandler() {
    }

    public static final PropertyEditorEventHandler createInstance() {
        return new PropertyEditorEventHandler();
    }

    public void init(DesignComponent designComponent) {
        if (designComponent != null) {
            this.component = new WeakReference<DesignComponent>(designComponent);
        }
    }

    public Component getCustomEditor() {
        if (this.customEditor == null) {
            Collection collection = Lookup.getDefault().lookup(new Lookup.Template(PropertyEditorElementFactory.class)).allInstances();
            ArrayList<PropertyEditorEventHandlerElement> arrayList = new ArrayList<PropertyEditorEventHandlerElement>(collection.size());
            for (PropertyEditorElementFactory propertyEditorElementFactory : collection) {
                arrayList.add(propertyEditorElementFactory.createElement());
            }
            this.customEditor = new CustomEditor(arrayList);
        }
        if (this.initialized) {
            this.initCustomEditor();
        }
        return this.customEditor;
    }

    private void initCustomEditor() {
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent3;
                    PropertyValue propertyValue = null;
                    Iterator iterator = designComponent.getComponents().iterator();
                    if (iterator.hasNext()) {
                        designComponent3 = (DesignComponent)iterator.next();
                        propertyValue = PropertyValue.createComponentReference((DesignComponent)designComponent3);
                    }
                    designComponent3 = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), DisplayablesCategoryCD.TYPEID);
                    DesignComponent designComponent2 = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), PointsCategoryCD.TYPEID);
                    List list = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)designComponent3, (TypeID)DisplayableCD.TYPEID);
                    PropertyEditorEventHandler.this.customEditor.updateModels(list, 0, propertyValue);
                    List list2 = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)designComponent3, (TypeID)AlertCD.TYPEID);
                    ArrayList<DesignComponent> arrayList = new ArrayList<DesignComponent>(list.size() - list2.size());
                    arrayList.addAll(list);
                    arrayList.removeAll(list2);
                    PropertyEditorEventHandler.this.customEditor.updateModels(arrayList, 1, propertyValue);
                    List list3 = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)designComponent2, (TypeID)CallPointCD.TYPEID);
                    List list4 = DocumentSupport.gatherAllComponentsOfTypeID((DesignComponent)designComponent2, (TypeID)MethodPointCD.TYPEID);
                    ArrayList<DesignComponent> arrayList2 = new ArrayList<DesignComponent>(list3.size() + list4.size());
                    arrayList2.addAll(list3);
                    arrayList2.addAll(list4);
                    PropertyEditorEventHandler.this.customEditor.updateModels(arrayList2, 2, propertyValue);
                    List list5 = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent2, (TypeID)MobileDeviceCD.TYPEID);
                    PropertyEditorEventHandler.this.customEditor.setExitMidletEnabled(list5.size() == 1);
                }
            });
        }
    }

    public Boolean canEditAsText() {
        return false;
    }

    public String getAsText() {
        final String[] stringArray = new String[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    Iterator iterator = designComponent.getComponents().iterator();
                    if (!iterator.hasNext()) {
                        stringArray[0] = DO_NOTHING;
                    } else {
                        DesignComponent designComponent2 = (DesignComponent)iterator.next();
                        InfoPresenter infoPresenter = (InfoPresenter)designComponent2.getPresenter(InfoPresenter.class);
                        if (infoPresenter != null) {
                            stringArray[0] = infoPresenter.getDisplayName(InfoPresenter.NameType.PRIMARY);
                        } else {
                            throw new IllegalStateException("No infoPresenter for " + designComponent2);
                        }
                    }
                }
            });
        }
        return stringArray[0];
    }

    public boolean executeInsideWriteTransaction() {
        if (this.initialized && this.component != null && this.component.get() != null) {
            this.customEditor.createEventHandler((DesignComponent)this.component.get());
        }
        return false;
    }

    public boolean isDefaultValue() {
        return true;
    }

    public void cleanUp(DesignComponent designComponent) {
        if (this.customEditor != null) {
            this.customEditor.clean(designComponent);
        }
        designComponent = null;
        super.cleanUp(designComponent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomEditor
    extends JPanel
    implements CleanUp {
        private Collection<PropertyEditorEventHandlerElement> elements;
        private JRadioButton doNothingRadioButton;

        public CustomEditor(Collection<PropertyEditorEventHandlerElement> collection) {
            this.elements = collection;
        }

        private void initComponents(Collection<PropertyEditorEventHandlerElement> collection) {
            if (PropertyEditorEventHandler.this.component == null || PropertyEditorEventHandler.this.component.get() == null) {
                return;
            }
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            boolean bl = false;
            final DesignComponent designComponent = (DesignComponent)PropertyEditorEventHandler.this.component.get();
            for (PropertyEditorEventHandlerElement propertyEditorEventHandlerElement : collection) {
                final Collection<TypeID> collection2 = propertyEditorEventHandlerElement.getTypes();
                final boolean[] blArray = new boolean[]{true};
                designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                    public void run() {
                        for (TypeID typeID : collection2) {
                            if (AcceptContextResolver.resolveAcceptAllowance(designComponent, typeID)) continue;
                            blArray[0] = false;
                            break;
                        }
                    }
                });
                if (!blArray[0]) continue;
                JRadioButton jRadioButton = propertyEditorEventHandlerElement.getRadioButton();
                if (propertyEditorEventHandlerElement.isInitiallySelected()) {
                    jRadioButton.setSelected(true);
                    bl = true;
                }
                buttonGroup.add(jRadioButton);
                gridBagConstraints.insets = new Insets(12, 12, 6, 12);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                this.add((Component)jRadioButton, gridBagConstraints);
                JComponent jComponent = propertyEditorEventHandlerElement.getCustomEditorComponent();
                if (jComponent == null) continue;
                gridBagConstraints.insets = new Insets(0, 32, 12, 12);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = -1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = propertyEditorEventHandlerElement.isVerticallyResizable() ? 1.0 : 0.0;
                gridBagConstraints.fill = 1;
                this.add((Component)jComponent, gridBagConstraints);
            }
            this.doNothingRadioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.doNothingRadioButton, (String)NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"LBL_NOTHING"));
            this.doNothingRadioButton.setSelected(!bl);
            buttonGroup.add(this.doNothingRadioButton);
            this.doNothingRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"ACSN_NOTHING"));
            this.doNothingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorEventHandler.class, (String)"ACSD_NOTHING"));
            gridBagConstraints.insets = new Insets(12, 12, 6, 12);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.doNothingRadioButton, gridBagConstraints);
            JPanel jPanel = new JPanel();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.add((Component)jPanel, gridBagConstraints);
        }

        public void updateModels(List<DesignComponent> list, int n, PropertyValue propertyValue) {
            for (PropertyEditorEventHandlerElement propertyEditorEventHandlerElement : this.elements) {
                propertyEditorEventHandlerElement.updateModel(list, n);
                propertyEditorEventHandlerElement.updateState(propertyValue);
                this.checkDoNothing(propertyValue);
            }
        }

        public void setExitMidletEnabled(boolean bl) {
            for (PropertyEditorEventHandlerElement propertyEditorEventHandlerElement : this.elements) {
                if (!(propertyEditorEventHandlerElement instanceof ExitMidletElement)) continue;
                propertyEditorEventHandlerElement.setElementEnabled(bl);
                break;
            }
        }

        private void checkDoNothing(PropertyValue propertyValue) {
            if (propertyValue == null || propertyValue.getComponent() == null) {
                this.doNothingRadioButton.setSelected(true);
            }
        }

        private void resetEventHandler(DesignComponent designComponent) {
            MidpDocumentSupport.updateEventHandlerWithNew(designComponent, null);
        }

        public void createEventHandler(DesignComponent designComponent) {
            if (this.doNothingRadioButton.isSelected()) {
                this.resetEventHandler(designComponent);
            } else {
                for (PropertyEditorEventHandlerElement propertyEditorEventHandlerElement : this.elements) {
                    if (designComponent == null) continue;
                    propertyEditorEventHandlerElement.createEventHandler(designComponent);
                }
            }
        }

        @Override
        public void addNotify() {
            if (!PropertyEditorEventHandler.this.initialized) {
                this.initComponents(this.elements);
                PropertyEditorEventHandler.this.initCustomEditor();
                PropertyEditorEventHandler.this.initialized = true;
            }
            super.addNotify();
        }

        @Override
        public void clean(DesignComponent designComponent) {
            if (this.elements != null && this.elements.size() > 0) {
                for (PropertyEditorEventHandlerElement propertyEditorEventHandlerElement : this.elements) {
                    if (!(propertyEditorEventHandlerElement instanceof CleanUp)) continue;
                    ((CleanUp)((Object)propertyEditorEventHandlerElement)).clean(designComponent);
                }
                this.elements = null;
            }
            this.doNothingRadioButton = null;
        }
    }
}

