/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TickerEditorElement
extends PropertyEditorResourceElement
implements DocumentListener,
CleanUp {
    private long componentID;
    private boolean doNotFireEvent;
    private JLabel tickerLabel;
    private JTextField tickerTextField;

    public TickerEditorElement() {
        this.initComponents();
        this.tickerTextField.getDocument().addDocumentListener(this);
    }

    @Override
    public void clean(DesignComponent designComponent) {
        this.tickerLabel = null;
        this.tickerTextField = null;
        this.removeAll();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return TickerCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("string");
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        if (designComponentWrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = designComponentWrapper.getComponentID();
        final String[] stringArray = new String[1];
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent != null) {
            if (!designComponent.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + designComponent.getType());
            }
            this.componentID = designComponent.getComponentID();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("string");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        stringArray[0] = MidpTypes.getString(propertyValue);
                    }
                }
            });
        }
        if (designComponentWrapper.hasChanges()) {
            Map<String, PropertyValue> map = designComponentWrapper.getChanges();
            for (String string : map.keySet()) {
                PropertyValue propertyValue = map.get(string);
                if (!"string".equals(string)) continue;
                stringArray[0] = MidpTypes.getString(propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(stringArray[0]);
    }

    private synchronized void setText(String string) {
        this.doNotFireEvent = true;
        this.tickerTextField.setText(string);
        this.doNotFireEvent = false;
    }

    private void setAllEnabled(boolean bl) {
        this.tickerLabel.setEnabled(bl);
        this.tickerTextField.setEnabled(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.tickerTextField.hasFocus()) {
            this.textChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.tickerTextField.hasFocus()) {
            this.textChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private synchronized void textChanged() {
        if (!this.doNotFireEvent) {
            this.fireElementChanged(this.componentID, "string", MidpTypes.createStringValue(this.tickerTextField.getText()));
        }
    }

    private void initComponents() {
        this.tickerLabel = new JLabel();
        this.tickerTextField = new JTextField();
        this.tickerLabel.setLabelFor(this.tickerTextField);
        Mnemonics.setLocalizedText((JLabel)this.tickerLabel, (String)NbBundle.getMessage(TickerEditorElement.class, (String)"TickerEditorElement.tickerLabel.text"));
        this.tickerLabel.setEnabled(false);
        this.tickerTextField.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(2, 2, 2).add((Component)this.tickerLabel).addContainerGap()).add((Component)this.tickerTextField, -1, 320, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tickerLabel).addPreferredGap(0).add((Component)this.tickerTextField, -2, -1, -2).addContainerGap(110, Short.MAX_VALUE)));
        this.tickerTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TickerEditorElement.class, (String)"ACSN_Ticker"));
        this.tickerTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TickerEditorElement.class, (String)"ACSD_Ticker"));
    }
}

