/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyKernel;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyRational;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.Convert;
import org.jruby.nb.util.Numeric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Float"}, parent="Numeric", include={"Precision"})
public class RubyFloat
extends RubyNumeric {
    private final double value;
    private static final DecimalFormat FORMAT = new DecimalFormat("##############0.0##############", new DecimalFormatSymbols(Locale.ENGLISH));
    static final int DBL_MANT_DIG = 53;
    static final int FLT_RADIX = 2;

    public static RubyClass createFloatClass(Ruby ruby) {
        RubyClass rubyClass = ruby.defineClass("Float", ruby.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        ruby.setFloat(rubyClass);
        rubyClass.index = 11;
        rubyClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return iRubyObject instanceof RubyFloat;
            }
        };
        rubyClass.getSingletonClass().undefineMethod("new");
        rubyClass.includeModule(ruby.getPrecision());
        rubyClass.defineConstant("ROUNDS", RubyFixnum.newFixnum(ruby, 1L));
        rubyClass.defineConstant("RADIX", RubyFixnum.newFixnum(ruby, 2L));
        rubyClass.defineConstant("MANT_DIG", RubyFixnum.newFixnum(ruby, 53L));
        rubyClass.defineConstant("DIG", RubyFixnum.newFixnum(ruby, 15L));
        rubyClass.defineConstant("MIN_EXP", RubyFixnum.newFixnum(ruby, -1021L));
        rubyClass.defineConstant("MAX_EXP", RubyFixnum.newFixnum(ruby, 1024L));
        rubyClass.defineConstant("MIN_10_EXP", RubyFixnum.newFixnum(ruby, -307L));
        rubyClass.defineConstant("MAX_10_EXP", RubyFixnum.newFixnum(ruby, 308L));
        rubyClass.defineConstant("MIN", RubyFloat.newFloat(ruby, Double.MIN_VALUE));
        rubyClass.defineConstant("MAX", RubyFloat.newFloat(ruby, Double.MAX_VALUE));
        rubyClass.defineConstant("EPSILON", RubyFloat.newFloat(ruby, 2.220446049250313E-16));
        rubyClass.defineAnnotatedMethods(RubyFloat.class);
        return rubyClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 11;
    }

    public RubyFloat(Ruby ruby) {
        this(ruby, 0.0);
    }

    public RubyFloat(Ruby ruby, double d) {
        super(ruby, ruby.getFloat());
        this.value = d;
    }

    @Override
    public Class<?> getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public RubyFloat convertToFloat() {
        return this;
    }

    protected int compareValue(RubyNumeric rubyNumeric) {
        double d = rubyNumeric.getDoubleValue();
        return this.getValue() > d ? 1 : (this.getValue() < d ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby ruby, double d) {
        return new RubyFloat(ruby, d);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject induced_from(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubyBignum || iRubyObject2 instanceof RubyRational) {
            return iRubyObject2.callMethod(threadContext, MethodIndex.TO_F, "to_f");
        }
        if (iRubyObject2 instanceof RubyFloat) {
            return iRubyObject2;
        }
        throw iRubyObject.getRuntime().newTypeError("failed to convert " + iRubyObject2.getMetaClass() + " into Float");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (Double.isInfinite(this.value)) {
            return RubyString.newString(this.getRuntime(), this.value < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(this.value)) {
            return RubyString.newString(this.getRuntime(), "NaN");
        }
        String string = "" + this.value;
        if (string.indexOf(69) != -1) {
            String string2 = FORMAT.format(this.value);
            int n = string2.length() - 1;
            while (string2.charAt(n) == '0' && string2.charAt(n - 1) != '.') {
                --n;
            }
            string = n > 15 || "0.0".equals(string2.substring(0, n + 1)) ? string.replaceFirst("E(\\d)", "e+$1").replaceFirst("E-", "e-") : string2.substring(0, n + 1);
        }
        return RubyString.newString(this.getRuntime(), string);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject iRubyObject) {
        return this.getRuntime().newArray(RubyKernel.new_float(this, iRubyObject), this);
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return RubyFloat.newFloat(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value + ((RubyNumeric)iRubyObject).getDoubleValue());
            }
        }
        return this.coerceBin(threadContext, "+", iRubyObject);
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value - ((RubyNumeric)iRubyObject).getDoubleValue());
            }
        }
        return this.coerceBin(threadContext, "-", iRubyObject);
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value * ((RubyNumeric)iRubyObject).getDoubleValue());
            }
        }
        return this.coerceBin(threadContext, "*", iRubyObject);
    }

    @JRubyMethod(name={"/"}, required=1)
    public IRubyObject op_fdiv(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), this.value / ((RubyNumeric)iRubyObject).getDoubleValue());
            }
        }
        return this.coerceBin(threadContext, "/", iRubyObject);
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                double d2 = this.value;
                double d3 = Math.IEEEremainder(d2, d);
                if (d * d3 < 0.0) {
                    d3 += d;
                }
                return RubyFloat.newFloat(this.getRuntime(), d3);
            }
        }
        return this.coerceBin(threadContext, "%", iRubyObject);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                double d2 = this.value;
                double d3 = Math.IEEEremainder(d2, d);
                if (Double.isNaN(d3)) {
                    throw this.getRuntime().newFloatDomainError("NaN");
                }
                double d4 = Math.floor(d2 / d);
                if (d * d3 < 0.0) {
                    d3 += d;
                }
                Ruby ruby = this.getRuntime();
                IRubyObject iRubyObject2 = RubyFloat.dbl2num(ruby, d4);
                RubyFloat rubyFloat = RubyFloat.newFloat(ruby, d3);
                return RubyArray.newArray(ruby, iRubyObject2, rubyFloat);
            }
        }
        return this.coerceBin(threadContext, "divmod", iRubyObject);
    }

    @JRubyMethod(name={"**"}, required=1)
    public IRubyObject op_pow(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyFloat.newFloat(this.getRuntime(), Math.pow(this.value, ((RubyNumeric)iRubyObject).getDoubleValue()));
            }
        }
        return this.coerceBin(threadContext, "**", iRubyObject);
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                return RubyBoolean.newBoolean(this.getRuntime(), this.value == ((RubyNumeric)iRubyObject).getDoubleValue());
            }
        }
        return super.op_num_equal(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                return RubyFloat.dbl_cmp(this.getRuntime(), this.value, d);
            }
        }
        return this.coerceCmp(threadContext, "<=>", iRubyObject);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(d) && this.value > d);
            }
        }
        return this.coerceRelOp(threadContext, ">", iRubyObject);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(d) && this.value >= d);
            }
        }
        return this.coerceRelOp(threadContext, ">=", iRubyObject);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(d) && this.value < d);
            }
        }
        return this.coerceRelOp(threadContext, "<", iRubyObject);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext threadContext, IRubyObject iRubyObject) {
        switch (iRubyObject.getMetaClass().index) {
            case 1: 
            case 2: 
            case 11: {
                double d = ((RubyNumeric)iRubyObject).getDoubleValue();
                return RubyBoolean.newBoolean(this.getRuntime(), !Double.isNaN(d) && this.value <= d);
            }
        }
        return this.coerceRelOp(threadContext, "<=", iRubyObject);
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFloat) {
            double d = ((RubyFloat)iRubyObject).value;
            if (Double.isNaN(this.value) || Double.isNaN(d)) {
                return this.getRuntime().getFalse();
            }
            if (this.value == d) {
                return this.getRuntime().getTrue();
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return this;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        if (Double.doubleToLongBits(this.value) < 0L) {
            return RubyFloat.newFloat(this.getRuntime(), Math.abs(this.value));
        }
        return this;
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0.0);
    }

    @Override
    @JRubyMethod(name={"truncate", "to_i", "to_int"})
    public IRubyObject truncate() {
        double d = this.value;
        if (d > 0.0) {
            d = Math.floor(d);
        }
        if (d < 0.0) {
            d = Math.ceil(d);
        }
        return RubyFloat.dbl2num(this.getRuntime(), d);
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext threadContext) {
        long[] lArray = new long[1];
        double d = Numeric.frexp(this.value, lArray);
        d = Numeric.ldexp(d, 53L);
        long l = lArray[0] - 53L;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = Numeric.f_mul(threadContext, Numeric.f_to_i(threadContext, ruby.newFloat(d)), Numeric.f_expt(threadContext, RubyFixnum.newFixnum(threadContext.getRuntime(), 2L), RubyFixnum.newFixnum(ruby, l)));
        return iRubyObject;
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.floor(this.value));
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return RubyFloat.dbl2num(this.getRuntime(), Math.ceil(this.value));
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        double d = this.value;
        if (d > 0.0) {
            d = Math.floor(d + 0.5);
        }
        if (d < 0.0) {
            d = Math.ceil(d - 0.5);
        }
        return RubyFloat.dbl2num(this.getRuntime(), d);
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Double.isNaN(this.value));
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (Double.isInfinite(this.value)) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.value < 0.0 ? -1L : 1L);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (Double.isInfinite(this.value) || Double.isNaN(this.value)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public static void marshalTo(RubyFloat rubyFloat, MarshalStream marshalStream) throws IOException {
        marshalStream.registerLinkTarget(rubyFloat);
        String string = rubyFloat.toString();
        if (Double.isInfinite(rubyFloat.value)) {
            string = rubyFloat.value < 0.0 ? "-inf" : "inf";
        } else if (Double.isNaN(rubyFloat.value)) {
            string = "nan";
        }
        marshalStream.writeString(string);
    }

    public static RubyFloat unmarshalFrom(UnmarshalStream unmarshalStream) throws IOException {
        RubyFloat rubyFloat = RubyFloat.newFloat(unmarshalStream.getRuntime(), Convert.byteListToDouble(unmarshalStream.unmarshalString(), false));
        unmarshalStream.registerLinkTarget(rubyFloat);
        return rubyFloat;
    }
}

