/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    public static RubyModule createGCModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("GC");
        ruby.setGC(rubyModule);
        rubyModule.defineAnnotatedMethods(RubyGC.class);
        return rubyModule;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(IRubyObject iRubyObject) {
        System.gc();
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(IRubyObject iRubyObject) {
        System.gc();
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(IRubyObject iRubyObject) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.enable will not work on JRuby", "GC.enable");
        return iRubyObject.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(IRubyObject iRubyObject) {
        iRubyObject.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.disable will not work on JRuby", "GC.disable");
        return iRubyObject.getRuntime().getNil();
    }
}

