/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.MethodDefNode;
import org.jruby.nb.ast.NilNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefsNode
extends MethodDefNode
implements INameNode {
    private final Node receiverNode;

    public DefsNode(ISourcePosition iSourcePosition, Node node, ArgumentNode argumentNode, ArgsNode argsNode, StaticScope staticScope, Node node2) {
        super(iSourcePosition, argumentNode, argsNode, staticScope, node2, NodeType.DEFSNODE);
        assert (node != null) : "receiverNode is not null";
        this.receiverNode = node;
    }

    @Override
    public Instruction accept(NodeVisitor nodeVisitor) {
        return nodeVisitor.visitDefsNode(this);
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby ruby, ThreadContext threadContext, IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2 = this.receiverNode.interpret(ruby, threadContext, iRubyObject, block);
        String string = this.getName();
        if (ruby.getSafeLevel() >= 4 && !iRubyObject2.isTaint()) {
            throw ruby.newSecurityError("Insecure; can't define singleton method.");
        }
        if (iRubyObject2 instanceof RubyFixnum || iRubyObject2 instanceof RubySymbol) {
            throw ruby.newTypeError("can't define singleton method \"" + string + "\" for " + iRubyObject2.getMetaClass().getBaseName());
        }
        if (iRubyObject2.isFrozen()) {
            throw ruby.newFrozenError("object");
        }
        RubyClass rubyClass = iRubyObject2.getSingletonClass();
        if (ruby.getSafeLevel() >= 4 && rubyClass.getMethods().get(string) != null) {
            throw ruby.newSecurityError("redefining method prohibited.");
        }
        this.scope.determineModule();
        Node node = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod defaultMethod = new DefaultMethod(rubyClass, this.scope, node, this.argsNode, Visibility.PUBLIC, this.getPosition());
        rubyClass.addMethod(string, defaultMethod);
        iRubyObject2.callMethod(threadContext, "singleton_method_added", ruby.fastNewSymbol(string));
        return ruby.getNil();
    }
}

