/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyThread;
import org.jruby.nb.runtime.ThreadContext;

public class ThreadService {
    private Ruby runtime;
    private ThreadContext mainContext;
    private ThreadLocal<SoftReference<ThreadContext>> localContext;
    private ThreadGroup rubyThreadGroup;
    private Map<Thread, RubyThread> rubyThreadMap;
    private ReentrantLock criticalLock = new ReentrantLock();

    public ThreadService(Ruby ruby) {
        this.runtime = ruby;
        this.mainContext = ThreadContext.newContext(ruby);
        this.localContext = new ThreadLocal();
        this.rubyThreadGroup = new ThreadGroup("Ruby Threads#" + ruby.hashCode());
        this.rubyThreadMap = Collections.synchronizedMap(new WeakHashMap());
        this.localContext.set(new SoftReference<ThreadContext>(this.mainContext));
    }

    public void disposeCurrentThread() {
        this.localContext.set(null);
        this.rubyThreadMap.remove(Thread.currentThread());
    }

    public ThreadContext getCurrentContext() {
        SoftReference softReference = null;
        ThreadContext threadContext = null;
        while (threadContext == null) {
            softReference = this.localContext.get();
            if (softReference == null) {
                softReference = this.adoptCurrentThread();
                threadContext = (ThreadContext)softReference.get();
            } else {
                threadContext = softReference.get();
            }
            if (threadContext != null) continue;
            this.localContext.set(null);
        }
        return threadContext;
    }

    private SoftReference adoptCurrentThread() {
        Thread thread = Thread.currentThread();
        RubyThread.adopt(this.runtime.getThread(), thread);
        return this.localContext.get();
    }

    public RubyThread getMainThread() {
        return this.mainContext.getThread();
    }

    public void setMainThread(Thread thread, RubyThread rubyThread) {
        this.mainContext.setThread(rubyThread);
        this.rubyThreadMap.put(thread, rubyThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RubyThread[] getActiveRubyThreads() {
        Map<Thread, RubyThread> map = this.rubyThreadMap;
        synchronized (map) {
            ArrayList<RubyThread> arrayList = new ArrayList<RubyThread>(this.rubyThreadMap.size());
            for (Map.Entry<Thread, RubyThread> entry : this.rubyThreadMap.entrySet()) {
                Thread thread = entry.getKey();
                if (!thread.isAlive()) continue;
                arrayList.add(entry.getValue());
            }
            RubyThread[] rubyThreadArray = new RubyThread[arrayList.size()];
            arrayList.toArray(rubyThreadArray);
            return rubyThreadArray;
        }
    }

    public ThreadGroup getRubyThreadGroup() {
        return this.rubyThreadGroup;
    }

    public synchronized ThreadContext registerNewThread(RubyThread rubyThread) {
        ThreadContext threadContext = ThreadContext.newContext(this.runtime);
        this.localContext.set(new SoftReference<ThreadContext>(threadContext));
        this.getCurrentContext().setThread(rubyThread);
        this.rubyThreadMap.put(Thread.currentThread(), rubyThread);
        return threadContext;
    }

    public synchronized void unregisterThread(RubyThread rubyThread) {
        this.rubyThreadMap.remove(Thread.currentThread());
        this.getCurrentContext().setThread(null);
        this.localContext.set(null);
    }

    private RubyThread getRubyThreadFromThread(Thread thread) {
        RubyThread rubyThread = this.rubyThreadMap.get(thread);
        return rubyThread;
    }

    public void setCritical(boolean bl) {
        if (this.criticalLock.isHeldByCurrentThread()) {
            if (!bl) {
                this.criticalLock.unlock();
            }
        } else if (bl) {
            this.criticalLock.lock();
        }
    }

    public boolean getCritical() {
        return this.criticalLock.isHeldByCurrentThread();
    }

    public void waitForCritical() {
        if (this.criticalLock.isLocked()) {
            this.criticalLock.lock();
            this.criticalLock.unlock();
        }
    }
}

