/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.invokers;

import java.util.Arrays;
import java.util.Map;
import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaCallable;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class RubyToJavaInvoker
extends JavaMethod {
    protected static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected JavaCallable javaCallable;
    protected JavaCallable[][] javaCallables;
    protected Map cache;
    protected volatile boolean initialized;

    RubyToJavaInvoker(RubyModule rubyModule) {
        super(rubyModule, Visibility.PUBLIC);
    }

    void raiseNoMatchingCallableError(String string, IRubyObject iRubyObject, Object ... objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new Class[objectArray.length];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray[i].getClass();
        }
        throw iRubyObject.getRuntime().newNameError("no " + string + " with arguments matching " + Arrays.toString(objectArray2) + " on object " + iRubyObject.getMetaClass(), null);
    }

    protected JavaCallable findCallable(IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, int n) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (n > this.javaCallables.length || (javaCallableArray = this.javaCallables[n]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, iRubyObjectArray, 0);
            }
            javaCallable = Java.matchingCallableArityN(iRubyObject, this.cache, javaCallableArray, iRubyObjectArray, n);
        } else if (javaCallable.getParameterTypes().length != iRubyObjectArray.length) {
            throw iRubyObject.getRuntime().newArgumentError(iRubyObjectArray.length, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }

    protected JavaCallable findCallableArityZero(IRubyObject iRubyObject, String string) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (this.javaCallables.length == 0 || (javaCallableArray = this.javaCallables[0]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, IRubyObject.NULL_ARRAY, 0);
            }
            javaCallable = javaCallableArray[0];
        } else if (javaCallable.getParameterTypes().length != 0) {
            throw iRubyObject.getRuntime().newArgumentError(0, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }

    protected JavaCallable findCallableArityOne(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (this.javaCallables.length < 1 || (javaCallableArray = this.javaCallables[1]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, iRubyObject2);
            }
            javaCallable = Java.matchingCallableArityOne(iRubyObject, this.cache, javaCallableArray, iRubyObject2);
        } else if (javaCallable.getParameterTypes().length != 1) {
            throw iRubyObject.getRuntime().newArgumentError(1, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }

    protected JavaCallable findCallableArityTwo(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (this.javaCallables.length <= 2 || (javaCallableArray = this.javaCallables[2]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, iRubyObject2, iRubyObject3);
            }
            javaCallable = Java.matchingCallableArityTwo(iRubyObject, this.cache, javaCallableArray, iRubyObject2, iRubyObject3);
        } else if (javaCallable.getParameterTypes().length != 2) {
            throw iRubyObject.getRuntime().newArgumentError(2, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }

    protected JavaCallable findCallableArityThree(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (this.javaCallables.length <= 3 || (javaCallableArray = this.javaCallables[3]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4);
            }
            javaCallable = Java.matchingCallableArityThree(iRubyObject, this.cache, javaCallableArray, iRubyObject2, iRubyObject3, iRubyObject4);
        } else if (javaCallable.getParameterTypes().length != 3) {
            throw iRubyObject.getRuntime().newArgumentError(3, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }

    protected JavaCallable findCallableArityFour(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        JavaCallable javaCallable = this.javaCallable;
        if (javaCallable == null) {
            JavaCallable[] javaCallableArray = null;
            if (this.javaCallables.length <= 4 || (javaCallableArray = this.javaCallables[4]) == null) {
                this.raiseNoMatchingCallableError(string, iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5);
            }
            javaCallable = Java.matchingCallableArityFour(iRubyObject, this.cache, javaCallableArray, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5);
        } else if (javaCallable.getParameterTypes().length != 4) {
            throw iRubyObject.getRuntime().newArgumentError(4, javaCallable.getParameterTypes().length);
        }
        return javaCallable;
    }
}

