/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObjectAdapter;
import org.jruby.nb.RubyRuntimeAdapter;
import org.jruby.nb.RubyString;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.ClassCache;

public class JavaEmbedUtils {
    public static Ruby initialize(List list) {
        return JavaEmbedUtils.initialize(list, new RubyInstanceConfig());
    }

    public static Ruby initialize(List list, ClassCache classCache) {
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig();
        if (classCache != null) {
            rubyInstanceConfig.setClassCache(classCache);
        }
        return JavaEmbedUtils.initialize(list, rubyInstanceConfig);
    }

    public static Ruby initialize(List list, RubyInstanceConfig rubyInstanceConfig) {
        Ruby ruby = Ruby.newInstance(rubyInstanceConfig);
        ruby.getLoadService().init(list);
        ruby.getLoadService().require("java");
        return ruby;
    }

    public static ClassCache createClassCache(ClassLoader classLoader) {
        return new ClassCache(classLoader, new RubyInstanceConfig().getJitMax());
    }

    public static RubyObjectAdapter newObjectAdapter() {
        return new RubyObjectAdapter(){

            public boolean isKindOf(IRubyObject iRubyObject, RubyModule rubyModule) {
                return rubyModule.isInstance(iRubyObject);
            }

            public IRubyObject setInstanceVariable(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
                return iRubyObject.getInstanceVariables().setInstanceVariable(string, iRubyObject2);
            }

            public IRubyObject[] convertToJavaArray(IRubyObject iRubyObject) {
                return ((RubyArray)iRubyObject).toJavaArray();
            }

            public RubyInteger convertToRubyInteger(IRubyObject iRubyObject) {
                return iRubyObject.convertToInteger();
            }

            public IRubyObject getInstanceVariable(IRubyObject iRubyObject, String string) {
                return iRubyObject.getInstanceVariables().getInstanceVariable(string);
            }

            public RubyString convertToRubyString(IRubyObject iRubyObject) {
                return iRubyObject.convertToString();
            }

            public IRubyObject callMethod(IRubyObject iRubyObject, String string) {
                return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), string);
            }

            public IRubyObject callMethod(IRubyObject iRubyObject, String string, IRubyObject iRubyObject2) {
                return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), string, iRubyObject2);
            }

            public IRubyObject callMethod(IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray) {
                return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), string, iRubyObjectArray);
            }

            public IRubyObject callMethod(IRubyObject iRubyObject, String string, IRubyObject[] iRubyObjectArray, Block block) {
                return iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), string, iRubyObjectArray, block);
            }

            public IRubyObject callSuper(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
                return iRubyObject.callSuper(iRubyObject.getRuntime().getCurrentContext(), iRubyObjectArray, Block.NULL_BLOCK);
            }

            public IRubyObject callSuper(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
                return iRubyObject.callSuper(iRubyObject.getRuntime().getCurrentContext(), iRubyObjectArray, block);
            }
        };
    }

    public static RubyRuntimeAdapter newRuntimeAdapter() {
        return new RubyRuntimeAdapter(){

            public IRubyObject eval(Ruby ruby, String string) {
                return ruby.evalScriptlet(string);
            }
        };
    }

    public static void terminate(Ruby ruby) {
        ruby.tearDown();
    }

    public static Object invokeMethod(Ruby ruby, Object object, String string, Object[] objectArray, Class clazz) {
        IRubyObject iRubyObject = object != null ? JavaUtil.convertJavaToRuby(ruby, object) : ruby.getTopSelf();
        IRubyObject[] iRubyObjectArray = JavaUtil.convertJavaArrayToRuby(ruby, objectArray);
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray[i];
            if (!(iRubyObject2 instanceof JavaObject)) continue;
            iRubyObjectArray[i] = Java.wrap(ruby, iRubyObject2);
        }
        IRubyObject iRubyObject3 = iRubyObject.callMethod(ruby.getCurrentContext(), string, iRubyObjectArray);
        return JavaEmbedUtils.rubyToJava(ruby, iRubyObject3, clazz);
    }

    public static Object rubyToJava(Ruby ruby, IRubyObject iRubyObject, Class clazz) {
        return JavaUtil.convertArgument(ruby, Java.ruby_to_java(ruby.getObject(), iRubyObject, Block.NULL_BLOCK), clazz);
    }

    public static IRubyObject javaToRuby(Ruby ruby, Object object) {
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        IRubyObject iRubyObject = JavaUtil.convertJavaToRuby(ruby, object);
        return iRubyObject instanceof JavaObject ? Java.wrap(ruby, iRubyObject) : iRubyObject;
    }

    public static IRubyObject javaToRuby(Ruby ruby, boolean bl) {
        return JavaEmbedUtils.javaToRuby(ruby, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public static IRubyObject javaToRuby(Ruby ruby, byte by) {
        return JavaEmbedUtils.javaToRuby(ruby, new Byte(by));
    }

    public static IRubyObject javaToRuby(Ruby ruby, char c) {
        return JavaEmbedUtils.javaToRuby(ruby, new Character(c));
    }

    public static IRubyObject javaToRuby(Ruby ruby, double d) {
        return JavaEmbedUtils.javaToRuby(ruby, new Double(d));
    }

    public static IRubyObject javaToRuby(Ruby ruby, float f) {
        return JavaEmbedUtils.javaToRuby(ruby, new Float(f));
    }

    public static IRubyObject javaToRuby(Ruby ruby, int n) {
        return JavaEmbedUtils.javaToRuby(ruby, new Integer(n));
    }

    public static IRubyObject javaToRuby(Ruby ruby, long l) {
        return JavaEmbedUtils.javaToRuby(ruby, new Long(l));
    }

    public static IRubyObject javaToRuby(Ruby ruby, short s) {
        return JavaEmbedUtils.javaToRuby(ruby, new Short(s));
    }
}

