/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyModule;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.BlockCallback;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class CallBlock
extends BlockBody {
    private final Arity arity;
    private final BlockCallback callback;
    private final RubyModule imClass;
    private final ThreadContext context;

    public static Block newCallClosure(IRubyObject iRubyObject, RubyModule rubyModule, Arity arity, BlockCallback blockCallback, ThreadContext threadContext) {
        Binding binding = new Binding(iRubyObject, threadContext.getCurrentFrame(), Visibility.PUBLIC, threadContext.getRubyClass(), threadContext.getCurrentScope());
        CallBlock callBlock = new CallBlock(rubyModule, arity, blockCallback, threadContext);
        return new Block(callBlock, binding);
    }

    private CallBlock(RubyModule rubyModule, Arity arity, BlockCallback blockCallback, ThreadContext threadContext) {
        super(3);
        this.arity = arity;
        this.callback = blockCallback;
        this.imClass = rubyModule;
        this.context = threadContext;
    }

    public IRubyObject call(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Binding binding, Block.Type type) {
        return this.callback.call(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        return this.callback.call(threadContext, new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        return this.callback.call(threadContext, new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
    }

    public StaticScope getStaticScope() {
        throw new RuntimeException("CallBlock does not have a static scope; this should not be called");
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), Visibility.PUBLIC, binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

