/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.MultipleAsgnNode;
import org.jruby.nb.ast.NilImplicitNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends BlockBody {
    private final IterNode iterNode;
    private final boolean hasVarNode;
    private final Node varNode;
    private final Node bodyNode;
    private final StaticScope scope;
    private final Arity arity;

    public static Block newInterpretedClosure(ThreadContext threadContext, IterNode iterNode, IRubyObject iRubyObject) {
        Frame frame = threadContext.getCurrentFrame();
        return InterpretedBlock.newInterpretedClosure(iterNode, iRubyObject, Arity.procArityOf(iterNode.getVarNode()), frame, frame.getVisibility(), threadContext.getRubyClass(), threadContext.getCurrentScope());
    }

    public static Block newInterpretedClosure(ThreadContext threadContext, InterpretedBlock interpretedBlock, IRubyObject iRubyObject) {
        Frame frame = threadContext.getCurrentFrame();
        Binding binding = new Binding(iRubyObject, frame, frame.getVisibility(), threadContext.getRubyClass(), threadContext.getCurrentScope());
        return new Block(interpretedBlock, binding);
    }

    public static Block newInterpretedClosure(IterNode iterNode, IRubyObject iRubyObject, Arity arity, Frame frame, Visibility visibility, RubyModule rubyModule, DynamicScope dynamicScope) {
        NodeType nodeType = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        InterpretedBlock interpretedBlock = new InterpretedBlock(iterNode, arity, InterpretedBlock.asArgumentType(nodeType));
        Binding binding = new Binding(iRubyObject, frame, visibility, rubyModule, dynamicScope);
        return new Block(interpretedBlock, binding);
    }

    public InterpretedBlock(IterNode iterNode, int n) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), n);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity, int n) {
        super(n);
        this.iterNode = iterNode;
        this.arity = arity;
        this.hasVarNode = iterNode.getVarNode() != null;
        this.varNode = iterNode.getVarNode();
        this.bodyNode = iterNode.getBodyNode() == null ? NilImplicitNode.NIL : iterNode.getBodyNode();
        this.scope = iterNode.getScope();
    }

    protected Frame pre(ThreadContext threadContext, RubyModule rubyModule, Binding binding) {
        return threadContext.preYieldSpecificBlock(binding, this.iterNode.getScope(), rubyModule);
    }

    protected void post(ThreadContext threadContext, Binding binding, Visibility visibility, Frame frame) {
        binding.getFrame().setVisibility(visibility);
        threadContext.postYield(binding, frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, Binding binding, Block.Type type) {
        IRubyObject iRubyObject2 = this.prepareSelf(binding);
        Visibility visibility = binding.getFrame().getVisibility();
        Frame frame = this.pre(threadContext, null, binding);
        try {
            if (this.hasVarNode) {
                this.setupBlockArg(threadContext, this.varNode, iRubyObject, iRubyObject2);
            }
            IRubyObject iRubyObject3 = this.evalBlockBody(threadContext, iRubyObject2);
            return iRubyObject3;
        }
        catch (JumpException.NextJump nextJump) {
            IRubyObject iRubyObject4 = this.handleNextJump(threadContext, nextJump, type);
            return iRubyObject4;
        }
        finally {
            this.post(threadContext, binding, visibility, frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject yield(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, RubyModule rubyModule, boolean bl, Binding binding, Block.Type type) {
        if (rubyModule == null) {
            iRubyObject2 = this.prepareSelf(binding);
        }
        Visibility visibility = binding.getFrame().getVisibility();
        Frame frame = this.pre(threadContext, rubyModule, binding);
        try {
            if (this.hasVarNode) {
                if (bl) {
                    this.setupBlockArgs(threadContext, this.varNode, iRubyObject, iRubyObject2);
                } else {
                    this.setupBlockArg(threadContext, this.varNode, iRubyObject, iRubyObject2);
                }
            }
            IRubyObject iRubyObject3 = this.evalBlockBody(threadContext, iRubyObject2);
            return iRubyObject3;
        }
        catch (JumpException.NextJump nextJump) {
            IRubyObject iRubyObject4 = this.handleNextJump(threadContext, nextJump, type);
            return iRubyObject4;
        }
        finally {
            this.post(threadContext, binding, visibility, frame);
        }
    }

    /*
     * Loose catch block
     */
    private IRubyObject evalBlockBody(ThreadContext threadContext, IRubyObject iRubyObject) {
        while (true) {
            try {
                return this.bodyNode.interpret(threadContext.getRuntime(), threadContext, iRubyObject, Block.NULL_BLOCK);
            }
            catch (JumpException.RedoJump redoJump) {
                threadContext.pollThreadEvents();
                continue;
            }
            break;
        }
        catch (StackOverflowError stackOverflowError) {
            throw threadContext.getRuntime().newSystemStackError("stack level too deep");
        }
    }

    private IRubyObject prepareSelf(Binding binding) {
        IRubyObject iRubyObject = binding.getSelf();
        binding.getFrame().setSelf(iRubyObject);
        return iRubyObject;
    }

    private IRubyObject handleNextJump(ThreadContext threadContext, JumpException.NextJump nextJump, Block.Type type) {
        return type == Block.Type.LAMBDA ? threadContext.getRuntime().getNil() : (IRubyObject)nextJump.getValue();
    }

    private void setupBlockArgs(ThreadContext threadContext, Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        switch (node.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                iRubyObject = AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject2, (MultipleAsgnNode)node, (RubyArray)iRubyObject, false);
                break;
            }
            default: {
                this.defaultArgsLogic(threadContext, ruby, iRubyObject2, iRubyObject);
            }
        }
    }

    private void setupBlockArg(ThreadContext threadContext, Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = threadContext.getRuntime();
        switch (node.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                iRubyObject = AssignmentVisitor.multiAssign(ruby, threadContext, iRubyObject2, (MultipleAsgnNode)node, ArgsUtil.convertToRubyArray(ruby, iRubyObject, ((MultipleAsgnNode)node).getHeadNode() != null), false);
                break;
            }
            default: {
                this.defaultArgLogic(threadContext, ruby, iRubyObject2, iRubyObject);
            }
        }
    }

    private final void defaultArgsLogic(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = ArgsUtil.arrayLength(iRubyObject2);
        switch (n) {
            case 0: {
                iRubyObject2 = ruby.getNil();
                break;
            }
            case 1: {
                iRubyObject2 = ((RubyArray)iRubyObject2).eltInternal(0);
                break;
            }
            default: {
                ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + n + " for 1)", new Object[0]);
            }
        }
        this.varNode.assign(ruby, threadContext, iRubyObject, iRubyObject2, Block.NULL_BLOCK, false);
    }

    private final void defaultArgLogic(ThreadContext threadContext, Ruby ruby, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (iRubyObject2 == null) {
            ruby.getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
        }
        this.varNode.assign(ruby, threadContext, iRubyObject, iRubyObject2, Block.NULL_BLOCK, false);
    }

    public StaticScope getStaticScope() {
        return this.scope;
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    public Arity arity() {
        return this.arity;
    }
}

