/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.math.BigInteger;
import org.jruby.nb.RubyNumeric;
import org.jruby.util.ByteList;

public class Convert {
    private static final long[] LONG_10_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L};
    private static final BigInteger BIG_INT_ZERO = BigInteger.valueOf(0L);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] MIN_INT_BYTE_ARRAY = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    private static final byte[] MIN_LONG_BYTE_ARRAY = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    private static final char[] MIN_LONG_CHAR_ARRAY = new char[]{'-', '9', '2', '2', '3', '3', '7', '2', '0', '3', '6', '8', '5', '4', '7', '7', '5', '8', '0', '8'};
    private static final int[] SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] UCDIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final char[] CDIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] CDIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] CDIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final double[] SMALL_10_POWERS = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final int MAX_SMALL_10 = SMALL_10_POWERS.length - 1;
    private static final int MAX_DECIMAL_DIGITS = 15;

    public static final ByteList intToByteList(int n) {
        if (n == Integer.MIN_VALUE) {
            return new ByteList((byte[])MIN_INT_BYTE_ARRAY.clone(), false);
        }
        int n2 = n < 0 ? Convert.arraySize(-n) + 1 : Convert.arraySize(n);
        byte[] byArray = new byte[n2];
        Convert.getCharBytes(n, n2, byArray);
        return new ByteList(byArray, false);
    }

    public static final byte[] intToByteArray(int n) {
        if (n == Integer.MIN_VALUE) {
            return (byte[])MIN_INT_BYTE_ARRAY.clone();
        }
        int n2 = n < 0 ? Convert.arraySize(-n) + 1 : Convert.arraySize(n);
        byte[] byArray = new byte[n2];
        Convert.getCharBytes(n, n2, byArray);
        return byArray;
    }

    public static final ByteList intToByteList(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Convert.intToByteList(n);
        }
        byte[] byArray = new byte[33];
        boolean bl = n < 0;
        int n3 = 32;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            byArray[n3--] = DIGITS[-(n % n2)];
            n /= n2;
        }
        byArray[n3] = DIGITS[-n];
        if (bl) {
            byArray[--n3] = 45;
        }
        return new ByteList(byArray, n3, 33 - n3);
    }

    public static final byte[] intToByteArray(int n, int n2, boolean bl) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Convert.intToByteArray(n);
        }
        byte[] byArray = new byte[33];
        byte[] byArray2 = bl ? UCDIGITS : DIGITS;
        boolean bl2 = n < 0;
        int n3 = 32;
        if (!bl2) {
            n = -n;
        }
        while (n <= -n2) {
            byArray[n3--] = byArray2[-(n % n2)];
            n /= n2;
        }
        byArray[n3] = byArray2[-n];
        if (bl2) {
            byArray[--n3] = 45;
        }
        int n4 = 33 - n3;
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n3, byArray3, 0, n4);
        return byArray3;
    }

    public static final ByteList longToByteList(long l) {
        if (l == Long.MIN_VALUE) {
            return new ByteList((byte[])MIN_LONG_BYTE_ARRAY.clone(), false);
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Convert.intToByteList((int)l);
        }
        int n = l < 0L ? Convert.arraySize(-l) + 1 : Convert.arraySize(l);
        byte[] byArray = new byte[n];
        Convert.getCharBytes(l, n, byArray);
        return new ByteList(byArray, false);
    }

    public static final byte[] longToByteArray(long l) {
        if (l == Long.MIN_VALUE) {
            return (byte[])MIN_LONG_BYTE_ARRAY.clone();
        }
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            return Convert.intToByteArray((int)l);
        }
        int n = l < 0L ? Convert.arraySize(-l) + 1 : Convert.arraySize(l);
        byte[] byArray = new byte[n];
        Convert.getCharBytes(l, n, byArray);
        return byArray;
    }

    public static final ByteList longToByteList(long l, int n) {
        boolean bl;
        if (n < 2 || n > 36) {
            n = 10;
        }
        if (n == 10) {
            return Convert.longToByteList(l);
        }
        byte[] byArray = new byte[65];
        int n2 = 64;
        boolean bl2 = bl = l < 0L;
        if (!bl) {
            l = -l;
        }
        while (l <= (long)(-n)) {
            byArray[n2--] = DIGITS[(int)(-(l % (long)n))];
            l /= (long)n;
        }
        byArray[n2] = DIGITS[(int)(-l)];
        if (bl) {
            byArray[--n2] = 45;
        }
        return new ByteList(byArray, n2, 65 - n2);
    }

    public static final byte[] longToByteArray(long l, int n, boolean bl) {
        boolean bl2;
        if (n < 2 || n > 36) {
            n = 10;
        }
        if (n == 10) {
            return Convert.longToByteArray(l);
        }
        byte[] byArray = new byte[65];
        byte[] byArray2 = bl ? UCDIGITS : DIGITS;
        int n2 = 64;
        boolean bl3 = bl2 = l < 0L;
        if (!bl2) {
            l = -l;
        }
        while (l <= (long)(-n)) {
            byArray[n2--] = byArray2[(int)(-(l % (long)n))];
            l /= (long)n;
        }
        byArray[n2] = byArray2[(int)(-l)];
        if (bl2) {
            byArray[--n2] = 45;
        }
        int n3 = 65 - n2;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        return byArray3;
    }

    public static final byte[] intToCharBytes(int n) {
        if (n == Integer.MIN_VALUE) {
            return (byte[])MIN_INT_BYTE_ARRAY.clone();
        }
        int n2 = n < 0 ? Convert.arraySize(-n) + 1 : Convert.arraySize(n);
        byte[] byArray = new byte[n2];
        Convert.getCharBytes(n, n2, byArray);
        return byArray;
    }

    public static final byte[] longToCharBytes(long l) {
        if (l == Long.MIN_VALUE) {
            return (byte[])MIN_LONG_BYTE_ARRAY.clone();
        }
        int n = l < 0L ? Convert.arraySize(-l) + 1 : Convert.arraySize(l);
        byte[] byArray = new byte[n];
        Convert.getCharBytes(l, n, byArray);
        return byArray;
    }

    public static final char[] longToChars(long l) {
        if (l == Long.MIN_VALUE) {
            return (char[])MIN_LONG_CHAR_ARRAY.clone();
        }
        int n = l < 0L ? Convert.arraySize(-l) + 1 : Convert.arraySize(l);
        char[] cArray = new char[n];
        Convert.getChars(l, n, cArray);
        return cArray;
    }

    public static final void getCharBytes(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (n < 0) {
            n6 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n4 = n / 100;
            n3 = n - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n = n4;
            byArray[--n5] = DIGIT_ONES[n3];
            byArray[--n5] = DIGIT_TENS[n3];
        }
        do {
            n4 = n * 52429 >>> 19;
            n3 = n - ((n4 << 3) + (n4 << 1));
            byArray[--n5] = DIGITS[n3];
        } while ((n = n4) != 0);
        if (n6 != 0) {
            byArray[--n5] = n6;
        }
    }

    public static final void getCharBytes(long l, int n, byte[] byArray) {
        int n2;
        int n3;
        int n4 = n;
        int n5 = 0;
        if (l < 0L) {
            n5 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            byArray[--n4] = DIGIT_ONES[n3];
            byArray[--n4] = DIGIT_TENS[n3];
        }
        int n6 = (int)l;
        while (n6 >= 65536) {
            n2 = n6 / 100;
            n3 = n6 - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n6 = n2;
            byArray[--n4] = DIGIT_ONES[n3];
            byArray[--n4] = DIGIT_TENS[n3];
        }
        do {
            n2 = n6 * 52429 >>> 19;
            n3 = n6 - ((n2 << 3) + (n2 << 1));
            byArray[--n4] = DIGITS[n3];
        } while ((n6 = n2) != 0);
        if (n5 != 0) {
            byArray[--n4] = n5;
        }
    }

    public static final void getChars(long l, int n, char[] cArray) {
        int n2;
        int n3;
        int n4 = n;
        int n5 = 0;
        if (l < 0L) {
            n5 = 45;
            l = -l;
        }
        while (l > Integer.MAX_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l - ((l2 << 6) + (l2 << 5) + (l2 << 2)));
            l = l2;
            cArray[--n4] = CDIGIT_ONES[n3];
            cArray[--n4] = CDIGIT_TENS[n3];
        }
        int n6 = (int)l;
        while (n6 >= 65536) {
            n2 = n6 / 100;
            n3 = n6 - ((n2 << 6) + (n2 << 5) + (n2 << 2));
            n6 = n2;
            cArray[--n4] = CDIGIT_ONES[n3];
            cArray[--n4] = CDIGIT_TENS[n3];
        }
        do {
            n2 = n6 * 52429 >>> 19;
            n3 = n6 - ((n2 << 3) + (n2 << 1));
            cArray[--n4] = CDIGITS[n3];
        } while ((n6 = n2) != 0);
        if (n5 != 0) {
            cArray[--n4] = n5;
        }
    }

    public static final int arraySize(long l) {
        long l2 = 10L;
        for (int i = 1; i < 19; ++i) {
            if (l < l2) {
                return i;
            }
            l2 = 10L * l2;
        }
        return 19;
    }

    public static final int arraySize(int n) {
        int n2 = 0;
        while (n > SIZE_TABLE[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    public static final byte[] intToBinaryBytes(int n) {
        return Convert.intToUnsignedBytes(n, 1, false);
    }

    public static final byte[] intToOctalBytes(int n) {
        return Convert.intToUnsignedBytes(n, 3, false);
    }

    public static final byte[] intToHexBytes(int n) {
        return Convert.intToUnsignedBytes(n, 4, false);
    }

    public static final byte[] intToHexBytes(int n, boolean bl) {
        return Convert.intToUnsignedBytes(n, 4, bl);
    }

    public static final ByteList intToBinaryByteList(int n) {
        return new ByteList(Convert.intToUnsignedBytes(n, 1, false));
    }

    public static final ByteList intToOctalByteList(int n) {
        return new ByteList(Convert.intToUnsignedBytes(n, 3, false));
    }

    public static final ByteList intToHexByteList(int n) {
        return new ByteList(Convert.intToUnsignedBytes(n, 4, false));
    }

    public static final ByteList intToHexByteList(int n, boolean bl) {
        return new ByteList(Convert.intToUnsignedBytes(n, 4, bl));
    }

    public static final byte[] longToBinaryBytes(long l) {
        return Convert.longToUnsignedBytes(l, 1, false);
    }

    public static final byte[] longToOctalBytes(long l) {
        return Convert.longToUnsignedBytes(l, 3, false);
    }

    public static final byte[] longToHexBytes(long l) {
        return Convert.longToUnsignedBytes(l, 4, false);
    }

    public static final byte[] longToHexBytes(long l, boolean bl) {
        return Convert.longToUnsignedBytes(l, 4, bl);
    }

    public static final ByteList longToBinaryByteList(long l) {
        return new ByteList(Convert.longToUnsignedBytes(l, 1, false));
    }

    public static final ByteList longToOctalByteList(long l) {
        return new ByteList(Convert.longToUnsignedBytes(l, 3, false));
    }

    public static final ByteList longToHexByteList(long l) {
        return new ByteList(Convert.longToUnsignedBytes(l, 4, false));
    }

    public static final ByteList longToHexByteList(long l, boolean bl) {
        return new ByteList(Convert.longToUnsignedBytes(l, 4, bl));
    }

    public static final byte[] intToRawUnsignedBytes(int n, int n2) {
        byte[] byArray = new byte[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        do {
            byArray[--n3] = DIGITS[n & n5];
        } while ((n >>>= n2) != 0);
        return byArray;
    }

    public static final byte[] intToUnsignedBytes(int n, int n2, boolean bl) {
        byte[] byArray = new byte[32];
        int n3 = 32;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        byte[] byArray2 = bl ? UCDIGITS : DIGITS;
        do {
            byArray[--n3] = byArray2[n & n5];
        } while ((n >>>= n2) != 0);
        int n6 = 32 - n3;
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray, n3, byArray3, 0, n6);
        return byArray3;
    }

    public static final byte[] longToRawUnsignedBytes(long l, int n) {
        byte[] byArray = new byte[64];
        int n2 = 64;
        int n3 = 1 << n;
        long l2 = n3 - 1;
        do {
            byArray[--n2] = DIGITS[(int)(l & l2)];
        } while ((l >>>= n) != 0L);
        return byArray;
    }

    public static final byte[] longToUnsignedBytes(long l, int n, boolean bl) {
        byte[] byArray = new byte[64];
        int n2 = 64;
        int n3 = 1 << n;
        long l2 = n3 - 1;
        byte[] byArray2 = bl ? UCDIGITS : DIGITS;
        do {
            byArray[--n2] = byArray2[(int)(l & l2)];
        } while ((l >>>= n) != 0L);
        int n4 = 64 - n2;
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n2, byArray3, 0, n4);
        return byArray3;
    }

    public static final long byteListToLong(ByteList byteList, int n, boolean bl) {
        return Convert.byteArrayToLong(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n, bl);
    }

    public static final long byteListToLong(ByteList byteList, int n) {
        return Convert.byteArrayToLong(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n, false);
    }

    public static final long byteListToLong(ByteList byteList) {
        return Convert.byteArrayToLong(byteList.unsafeBytes(), byteList.begin(), byteList.length(), 10, false);
    }

    public static final BigInteger byteListToBigInteger(ByteList byteList, int n, boolean bl) {
        return Convert.byteArrayToBigInteger(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n, bl);
    }

    public static final BigInteger byteListToBigInteger(ByteList byteList, int n) {
        return Convert.byteArrayToBigInteger(byteList.unsafeBytes(), byteList.begin(), byteList.length(), n, false);
    }

    public static final BigInteger byteListToBigInteger(ByteList byteList) {
        return Convert.byteArrayToBigInteger(byteList.unsafeBytes(), byteList.begin(), byteList.length(), 10, false);
    }

    public static final long byteArrayToLong(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        int n5 = n4 = n3 == 0 ? 10 : n3;
        if (n4 < 2 || n4 > 36) {
            throw new IllegalArgumentException("illegal radix " + n4);
        }
        if (n2 == 0) {
            throw new RubyNumeric.InvalidIntegerException();
        }
        int n6 = n;
        n2 += n;
        int n7 = 0;
        long l = -9223372036854775807L;
        long l2 = 0L;
        long l3 = 0L;
        int n8 = 1;
        while (n8 != 0) {
            block0 : switch (n8) {
                case 1: {
                    byte by;
                    if (bl) {
                        while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                            ++n6;
                        }
                    } else {
                        while (n6 < n2 && (Convert.isWhitespace(by = byArray[n6]) || by == 95)) {
                            ++n6;
                        }
                    }
                    n8 = n6 < n2 ? 2 : 14;
                    break;
                }
                case 2: {
                    switch (byArray[n6]) {
                        case 45: {
                            n7 |= 1;
                            l = Long.MIN_VALUE;
                        }
                        case 43: {
                            if (++n6 >= n2) {
                                n8 = 14;
                                break;
                            }
                            if (byArray[n6] == 48) {
                                n8 = 3;
                                break;
                            }
                            n8 = 4;
                            break;
                        }
                        case 48: {
                            n8 = 3;
                            break;
                        }
                        default: {
                            n8 = 5;
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (++n6 >= n2) {
                        n8 = 0;
                        break;
                    }
                    switch (byArray[n6]) {
                        case 88: 
                        case 120: {
                            if (n3 == 0 || n3 == 16) {
                                n4 = 16;
                                n8 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n8 = 5;
                            break;
                        }
                        case 66: 
                        case 98: {
                            if (n3 == 0 || n3 == 2) {
                                n4 = 2;
                                n8 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n8 = 5;
                            break;
                        }
                        case 68: 
                        case 100: {
                            if (n3 == 0 || n3 == 10) {
                                n4 = 10;
                                n8 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n8 = 5;
                            break;
                        }
                        case 79: 
                        case 95: 
                        case 111: {
                            if (n3 == 0 || n3 == 8) {
                                n4 = 8;
                                n8 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n8 = 5;
                            break;
                        }
                        default: {
                            if (n3 == 0 || n3 == 8) {
                                n4 = 8;
                            }
                            n7 |= 2;
                            n8 = 5;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    byte by;
                    if (bl) {
                        int n9 = n6;
                        while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                            ++n6;
                        }
                        if (n9 != n6) {
                            n7 |= 8;
                        }
                    } else {
                        while (n6 < n2 && (Convert.isWhitespace(by = byArray[n6]) || by == 95)) {
                            if (by == 95) {
                                if ((n7 & 8) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                n7 |= 4;
                            } else {
                                if ((n7 & 4) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                n7 |= 8;
                            }
                            ++n6;
                        }
                    }
                    n8 = n6 < n2 ? 5 : 14;
                    break;
                }
                case 5: {
                    int n10 = Character.digit((char)byArray[n6], n4);
                    if (n10 < 0) {
                        n8 = bl ? 13 : 14;
                        break;
                    }
                    l2 = -n10;
                    if (++n6 >= n2) {
                        n8 = 0;
                        break;
                    }
                    l3 = l / (long)n4;
                    n7 = (n7 | 2) & 0xFFFFFFFB;
                    n8 = bl ? 7 : 6;
                    break;
                }
                case 6: {
                    int n10;
                    while ((n10 = Character.digit((char)byArray[n6], n4)) >= 0) {
                        if (l2 < l3 || (l2 *= (long)n4) < l + (long)n10) {
                            n8 = 18;
                            break block0;
                        }
                        l2 -= (long)n10;
                        if (++n6 < n2) continue;
                        n8 = 0;
                        break block0;
                    }
                    n8 = byArray[n6++] == 95 ? 8 : 14;
                    break;
                }
                case 8: {
                    while (n6 < n2 && byArray[n6] == 95) {
                        ++n6;
                    }
                    n8 = n6 < n2 ? 6 : 14;
                    break;
                }
                case 7: {
                    int n10;
                    while ((n10 = Character.digit((char)byArray[n6], n4)) >= 0) {
                        if (l2 < l3 || (l2 *= (long)n4) < l + (long)n10) {
                            n8 = 18;
                            break block0;
                        }
                        l2 -= (long)n10;
                        if (++n6 >= n2) {
                            n8 = 0;
                            break block0;
                        }
                        n7 &= 0xFFFFFFFB;
                    }
                    if (byArray[n6] == 95) {
                        if ((n7 & 0xC) != 0) {
                            n8 = 17;
                            break;
                        }
                        n7 |= 4;
                        n8 = ++n6 >= n2 ? 13 : 7;
                        break;
                    }
                    n8 = 13;
                    break;
                }
                case 13: {
                    if ((n7 & 4) != 0) {
                        n8 = 17;
                        break;
                    }
                    while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                        ++n6;
                    }
                    n8 = n6 < n2 ? 17 : 0;
                    break;
                }
                case 14: {
                    if ((n7 & 2) == 0) {
                        throw new RubyNumeric.InvalidIntegerException("no digits supplied");
                    }
                    n8 = 0;
                    break;
                }
                case 18: {
                    throw new RubyNumeric.NumberTooLargeException("can't convert to long");
                }
                case 17: {
                    throw new RubyNumeric.InvalidIntegerException("does not meet strict criteria");
                }
            }
        }
        if (!(n7 & true)) {
            return -l2;
        }
        return l2;
    }

    public static final BigInteger byteArrayToBigInteger(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (byArray == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        int n5 = n4 = n3 == 0 ? 10 : n3;
        if (n4 < 2 || n4 > 36) {
            throw new IllegalArgumentException("illegal radix " + n4);
        }
        if (n2 == 0) {
            throw new RubyNumeric.InvalidIntegerException();
        }
        int n6 = n;
        n2 += n;
        int n7 = 0;
        int n8 = 0;
        char[] cArray = null;
        int n9 = 1;
        while (n9 != 0) {
            block0 : switch (n9) {
                case 1: {
                    byte by;
                    if (bl) {
                        while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                            ++n6;
                        }
                    } else {
                        while (n6 < n2 && (Convert.isWhitespace(by = byArray[n6]) || by == 95)) {
                            ++n6;
                        }
                    }
                    n9 = n6 < n2 ? 2 : 14;
                    break;
                }
                case 2: {
                    switch (byArray[n6]) {
                        case 45: {
                            n7 |= 1;
                        }
                        case 43: {
                            if (++n6 >= n2) {
                                n9 = 14;
                                break;
                            }
                            if (byArray[n6] == 48) {
                                n9 = 3;
                                break;
                            }
                            n9 = 4;
                            break;
                        }
                        case 48: {
                            n9 = 3;
                            break;
                        }
                        default: {
                            n9 = 5;
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    if (++n6 >= n2) {
                        n9 = 0;
                        break;
                    }
                    switch (byArray[n6]) {
                        case 88: 
                        case 120: {
                            if (n3 == 0 || n3 == 16) {
                                n4 = 16;
                                n9 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n9 = 5;
                            break;
                        }
                        case 66: 
                        case 98: {
                            if (n3 == 0 || n3 == 2) {
                                n4 = 2;
                                n9 = ++n6 >= n2 ? 14 : 4;
                                break;
                            }
                            n9 = 5;
                            break;
                        }
                        default: {
                            if (n3 == 0 || n3 == 8) {
                                n4 = 8;
                            }
                            n7 |= 2;
                            n9 = 5;
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    byte by;
                    if (bl) {
                        int n10 = n6;
                        while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                            ++n6;
                        }
                        if (n10 != n6) {
                            n7 |= 8;
                        }
                    } else {
                        while (n6 < n2 && (Convert.isWhitespace(by = byArray[n6]) || by == 95)) {
                            if (by == 95) {
                                if ((n7 & 8) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                n7 |= 4;
                            } else {
                                if ((n7 & 4) != 0) {
                                    throw new RubyNumeric.InvalidIntegerException();
                                }
                                n7 |= 8;
                            }
                            ++n6;
                        }
                    }
                    n9 = n6 < n2 ? 5 : 14;
                    break;
                }
                case 5: {
                    int n11 = Character.digit((char)byArray[n6], n4);
                    if (n11 < 0) {
                        n9 = bl ? 13 : 14;
                        break;
                    }
                    if ((n7 & 1) == 0) {
                        cArray = new char[n2 - n6];
                        cArray[0] = (char)byArray[n6];
                        n8 = 1;
                    } else {
                        cArray = new char[n2 - n6 + 1];
                        cArray[0] = 45;
                        cArray[1] = (char)byArray[n6];
                        n8 = 2;
                    }
                    if (++n6 >= n2) {
                        n9 = 0;
                        break;
                    }
                    n7 = (n7 | 2) & 0xFFFFFFFB;
                    n9 = bl ? 7 : 6;
                    break;
                }
                case 6: {
                    int n11;
                    while ((n11 = Character.digit((char)byArray[n6], n4)) >= 0) {
                        cArray[n8++] = (char)byArray[n6];
                        if (++n6 < n2) continue;
                        n9 = 0;
                        break block0;
                    }
                    n9 = byArray[n6++] == 95 ? 8 : 14;
                    break;
                }
                case 8: {
                    while (n6 < n2 && byArray[n6] == 95) {
                        ++n6;
                    }
                    n9 = n6 < n2 ? 6 : 14;
                    break;
                }
                case 7: {
                    int n11;
                    while ((n11 = Character.digit((char)byArray[n6], n4)) >= 0) {
                        cArray[n8++] = (char)byArray[n6];
                        if (++n6 >= n2) {
                            n9 = 0;
                            break block0;
                        }
                        n7 &= 0xFFFFFFFB;
                    }
                    if (byArray[n6] == 95) {
                        if ((n7 & 0xC) != 0) {
                            n9 = 17;
                            break;
                        }
                        n7 |= 4;
                        n9 = ++n6 >= n2 ? 13 : 7;
                        break;
                    }
                    n9 = 13;
                    break;
                }
                case 13: {
                    if ((n7 & 4) != 0) {
                        n9 = 17;
                        break;
                    }
                    while (n6 < n2 && Convert.isWhitespace(byArray[n6])) {
                        ++n6;
                    }
                    n9 = n6 < n2 ? 17 : 0;
                    break;
                }
                case 14: {
                    if ((n7 & 2) == 0) {
                        throw new RubyNumeric.InvalidIntegerException("no digits supplied");
                    }
                    n9 = 0;
                    break;
                }
                case 17: {
                    throw new RubyNumeric.InvalidIntegerException("does not meet strict criteria");
                }
            }
        }
        if (cArray == null) {
            return BIG_INT_ZERO;
        }
        return new BigInteger(new String(cArray, 0, n8), n4);
    }

    public static final double byteListToDouble(ByteList byteList, boolean bl) {
        return Convert.byteArrayToDouble(byteList.unsafeBytes(), byteList.begin(), byteList.length(), bl);
    }

    public static final double byteListToDouble(ByteList byteList) {
        return Convert.byteArrayToDouble(byteList.unsafeBytes(), byteList.begin(), byteList.length(), false);
    }

    /*
     * Unable to fully structure code
     */
    public static final double byteArrayToDouble(byte[] var0, int var1_1, int var2_2, boolean var3_3) {
        var21_4 = 15 + Convert.MAX_SMALL_10;
        if (var0 == null) {
            throw new IllegalArgumentException("null bytes");
        }
        if (var2_2 < 0 || var2_2 > var0.length) {
            throw new IllegalArgumentException("invalid buflen specified");
        }
        if (var2_2 == 0) {
            throw new NumberFormatException();
        }
        var22_5 = var1_1;
        var2_2 += var1_1;
        var23_6 = -1;
        var24_7 = false;
        var25_8 = 0;
        var26_9 = 0;
        var27_10 = -1;
        var28_11 = 0L;
        var30_12 = 0;
        var31_13 = 0;
        var32_14 = null;
        var33_15 = 0;
        var34_16 = 0;
        var35_17 = 1;
        while (var35_17 != 0) {
            block0 : switch (var35_17) {
                case 1: {
                    if (var3_3) {
                        while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                            ++var22_5;
                        }
                    } else {
                        while (var22_5 < var2_2 && (Convert.isWhitespace(var23_6 = var0[var22_5]) || var23_6 == 95)) {
                            ++var22_5;
                        }
                    }
                    if (var22_5 >= var2_2) {
                        var35_17 = var3_3 != false ? 16 : 0;
                        break;
                    }
                }
                case 2: {
                    switch (var0[var22_5]) {
                        case 45: {
                            var24_7 = true;
                        }
                        case 43: {
                            if (++var22_5 >= var2_2) {
                                var35_17 = var3_3 != false ? 16 : 0;
                                break;
                            }
                        }
                        default: {
                            var31_13 = var22_5;
                            if (var3_3) {
                                var35_17 = 6;
                                break;
                            }
                            ** GOTO lbl51
                        }
                    }
                    break;
                }
lbl51:
                // 2 sources

                case 3: {
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var28_11 = var23_6 - 48;
                            var25_8 = 1;
                            break;
                        }
                        case 46: {
                            var35_17 = 4;
                            break block0;
                        }
                        default: {
                            var35_17 = 5;
                            break block0;
                        }
                    }
                    block143: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                if (var25_8 <= 0) continue block143;
                                ++var26_9;
                                continue block143;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                    var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                    var26_9 = 0;
                                }
                                if (var25_8++ < 15) {
                                    var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                                    continue block143;
                                }
                                var35_17 = 10;
                                break;
                            }
                            case 46: {
                                var35_17 = 4;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 9;
                                break;
                            }
                            case 95: {
                                continue block143;
                            }
                            default: {
                                var35_17 = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 5;
                    break;
                }
                case 4: {
                    var27_10 = var25_8 + var26_9;
                    while (var22_5 < var2_2 && var0[var22_5] == 95) {
                        ++var22_5;
                    }
                    if (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                if (var25_8 > 0) {
                                    ++var26_9;
                                    break;
                                }
                                --var30_12;
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                    var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                    var26_9 = 0;
                                }
                                if (var25_8++ < 15) {
                                    var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                                    break;
                                }
                                var35_17 = 10;
                                break block0;
                            }
                            default: {
                                var35_17 = 5;
                                break block0;
                            }
                        }
                    }
                    block145: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                if (var25_8 > 0) {
                                    ++var26_9;
                                    continue block145;
                                }
                                --var30_12;
                                continue block145;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                    var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                    var26_9 = 0;
                                }
                                if (var25_8++ < 15) {
                                    var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                                    continue block145;
                                }
                                var35_17 = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 9;
                                break;
                            }
                            case 95: {
                                continue block145;
                            }
                            default: {
                                var35_17 = 5;
                                break;
                            }
                        }
                        break block0;
                    }
                }
                case 5: {
                    if (var25_8 == 0) {
                        if (var22_5 + 1 < var2_2) {
                            if (!(var23_6 != 110 && var23_6 != 78 || var0[var22_5] != 97 && var0[var22_5] != 65 || var0[var22_5 + 1] != 110 && var0[var22_5 + 1] != 78)) {
                                return NaN;
                            }
                            if (!(var23_6 != 105 && var23_6 != 73 || var0[var22_5] != 110 && var0[var22_5] != 78 || var0[var22_5 + 1] != 102 && var0[var22_5 + 1] != 70)) {
                                return var24_7 != false ? -Infinity : Infinity;
                            }
                        }
                        return var24_7 != false ? -0.0 : 0.0;
                    }
                    var30_12 = var27_10 < 0 ? (var30_12 += var26_9) : (var30_12 += var27_10 - var25_8);
                    var36_18 = var28_11;
                    if (var30_12 == 0 || var36_18 == 0.0) {
                        return var24_7 != false ? -var36_18 : var36_18;
                    }
                    if (var30_12 >= 0) {
                        if (var30_12 <= Convert.MAX_SMALL_10) {
                            return var24_7 != false ? -var36_18 : (var36_18 *= Convert.SMALL_10_POWERS[var30_12]);
                        }
                        var38_19 = 15 - var25_8;
                        if (var30_12 <= Convert.MAX_SMALL_10 + var38_19) {
                            var36_18 = var36_18 * Convert.SMALL_10_POWERS[var38_19] * Convert.SMALL_10_POWERS[var30_12 - var38_19];
                            return var24_7 != false ? -var36_18 : var36_18;
                        }
                    } else if (var30_12 >= -Convert.MAX_SMALL_10) {
                        return var24_7 != false ? -var36_18 : (var36_18 /= Convert.SMALL_10_POWERS[-var30_12]);
                    }
                    var35_17 = 10;
                    break;
                }
                case 9: {
                    while (var22_5 < var2_2 && var0[var22_5] == 95) {
                        ++var22_5;
                    }
                    if (var22_5 >= var2_2) {
                        var35_17 = 5;
                        break;
                    }
                    var38_19 = 1;
                    var39_20 = 0;
                    block44 : switch (var0[var22_5]) {
                        case 45: {
                            var38_19 = -1;
                        }
                        case 43: {
                            if (++var22_5 >= var2_2) {
                                var35_17 = 5;
                                break;
                            }
                        }
                        default: {
                            block147: while (var22_5 < var2_2) {
                                var23_6 = var0[var22_5++];
                                switch (var23_6) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        if ((var39_20 = var39_20 * 10 + (var23_6 - 48)) < var21_4) continue block147;
                                        var35_17 = 10;
                                        break block44;
                                    }
                                    case 95: {
                                        continue block147;
                                    }
                                }
                                var30_12 += var38_19 * var39_20;
                                var35_17 = 5;
                                break block44;
                            }
                            var30_12 += var38_19 * var39_20;
                            var35_17 = 5;
                            break;
                        }
                    }
                    break;
                }
                case 6: {
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: {
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var28_11 = var23_6 - 48;
                            var25_8 = 1;
                            break;
                        }
                        case 46: {
                            var35_17 = 7;
                            break block0;
                        }
                        default: {
                            var35_17 = 16;
                            break block0;
                        }
                    }
                    block148: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                if (var25_8 <= 0) continue block148;
                                ++var26_9;
                                continue block148;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                    var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                    var26_9 = 0;
                                }
                                if (var25_8++ < 15) {
                                    var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                                    continue block148;
                                }
                                var35_17 = 10;
                                break;
                            }
                            case 46: {
                                var35_17 = 7;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 8;
                                break;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block148;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 5;
                    break;
                }
                case 7: {
                    var27_10 = var25_8 + var26_9;
                    if (var22_5 >= var2_2) ** GOTO lbl281
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: {
                            if (var25_8 > 0) {
                                ++var26_9;
                            } else {
                                --var30_12;
                            }
                            ** GOTO lbl283
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                var26_9 = 0;
                            }
                            if (var25_8++ >= 15) ** GOTO lbl275
                            var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                            ** GOTO lbl283
lbl275:
                            // 1 sources

                            var35_17 = 10;
                            break;
                        }
                        default: {
                            var35_17 = 16;
                            break;
                        }
                    }
                    break;
lbl281:
                    // 1 sources

                    var35_17 = 16;
                    break;
lbl283:
                    // 7 sources

                    block150: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                if (var25_8 > 0) {
                                    ++var26_9;
                                    continue block150;
                                }
                                --var30_12;
                                continue block150;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if (var26_9 > 0 && (var25_8 += var26_9) < 15) {
                                    var28_11 *= Convert.LONG_10_POWERS[var26_9];
                                    var26_9 = 0;
                                }
                                if (var25_8++ < 15) {
                                    var28_11 = var28_11 * 10L + (long)(var23_6 - 48);
                                    continue block150;
                                }
                                var35_17 = 10;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 8;
                                break;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block150;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 5;
                    break;
                }
                case 8: {
                    var38_19 = 1;
                    var39_20 = 0;
                    if (var22_5 < var2_2) {
                        switch (var0[var22_5]) {
                            case 45: {
                                var38_19 = -1;
                            }
                            case 43: {
                                if (++var22_5 >= var2_2) {
                                    var35_17 = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        var35_17 = 16;
                        break;
                    }
                    if (var22_5 >= var2_2) ** GOTO lbl342
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var39_20 = var23_6 - 48;
                            ** GOTO lbl344
                        }
                        default: {
                            var35_17 = 16;
                            break;
                        }
                    }
                    break;
lbl342:
                    // 1 sources

                    var35_17 = 16;
                    break;
lbl344:
                    // 3 sources

                    block152: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                if ((var39_20 = var39_20 * 10 + (var23_6 - 48)) < var21_4) continue block152;
                                var35_17 = 10;
                                break;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block152;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                var30_12 += var38_19 * var39_20;
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 5;
                                break;
                            }
                        }
                        break block0;
                    }
                    var30_12 += var38_19 * var39_20;
                    var35_17 = 5;
                    break;
                }
                case 10: {
                    var22_5 = var31_13;
                    if (var24_7) {
                        var32_14 = new char[var2_2 - var22_5 + 1];
                        var32_14[0] = 45;
                        var33_15 = 1;
                    } else {
                        var32_14 = new char[var2_2 - var22_5];
                    }
                    if (var3_3) {
                        var35_17 = 13;
                        break;
                    }
                    if (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: {
                                break;
                            }
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                break;
                            }
                            case 46: {
                                var35_17 = 11;
                                break block0;
                            }
                            default: {
                                var35_17 = 0;
                                break block0;
                            }
                        }
                    }
                    block154: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                continue block154;
                            }
                            case 46: {
                                var35_17 = 11;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 12;
                                break;
                            }
                            case 95: {
                                continue block154;
                            }
                            default: {
                                var35_17 = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 0;
                    break;
                }
                case 11: {
                    var32_14[var33_15++] = 46;
                    while (var22_5 < var2_2 && var0[var22_5] == 95) {
                        ++var22_5;
                    }
                    if (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                break;
                            }
                            default: {
                                var35_17 = 0;
                                break block0;
                            }
                        }
                    }
                    block156: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                continue block156;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 12;
                                break;
                            }
                            case 95: {
                                continue block156;
                            }
                            default: {
                                var35_17 = 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 0;
                    break;
                }
                case 12: {
                    var32_14[var33_15++] = 69;
                    while (var22_5 < var2_2 && var0[var22_5] == 95) {
                        ++var22_5;
                    }
                    if (var22_5 >= var2_2) {
                        var35_17 = 0;
                        break;
                    }
                    block104 : switch (var0[var22_5]) {
                        case 43: 
                        case 45: {
                            var32_14[var33_15++] = (char)var0[var22_5];
                            if (++var22_5 >= var2_2) {
                                var35_17 = 0;
                                break;
                            }
                        }
                        default: {
                            block158: while (var22_5 < var2_2) {
                                var23_6 = var0[var22_5++];
                                switch (var23_6) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        var32_14[var33_15++] = (char)var23_6;
                                        var34_16 = var33_15;
                                        continue block158;
                                    }
                                    case 95: {
                                        continue block158;
                                    }
                                }
                                var35_17 = 0;
                                break block104;
                            }
                            var35_17 = 0;
                            break;
                        }
                    }
                    break;
                }
                case 13: {
                    if (var22_5 >= var2_2) ** GOTO lbl493
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: {
                            ** GOTO lbl495
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var32_14[var33_15++] = (char)var23_6;
                            var34_16 = var33_15;
                            ** GOTO lbl495
                        }
                        case 46: {
                            var35_17 = 14;
                            break;
                        }
                        default: {
                            var35_17 = 16;
                            break;
                        }
                    }
                    break;
lbl493:
                    // 1 sources

                    var35_17 = 16;
                    break;
lbl495:
                    // 4 sources

                    block159: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                continue block159;
                            }
                            case 46: {
                                var35_17 = 14;
                                break;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 15;
                                break;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block159;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 0;
                    break;
                }
                case 14: {
                    var32_14[var33_15++] = 46;
                    if (var22_5 >= var2_2) ** GOTO lbl535
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var32_14[var33_15++] = (char)var23_6;
                            var34_16 = var33_15;
                            ** GOTO lbl537
                        }
                        default: {
                            var35_17 = 16;
                            break;
                        }
                    }
                    break;
lbl535:
                    // 1 sources

                    var35_17 = 16;
                    break;
lbl537:
                    // 3 sources

                    block161: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                continue block161;
                            }
                            case 69: 
                            case 101: {
                                var35_17 = 15;
                                break;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block161;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 0;
                    break;
                }
                case 15: {
                    var32_14[var33_15++] = 69;
                    if (var22_5 < var2_2) {
                        switch (var0[var22_5]) {
                            case 43: 
                            case 45: {
                                var32_14[var33_15++] = (char)var0[var22_5];
                                if (++var22_5 >= var2_2) {
                                    var35_17 = 16;
                                    break block0;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        var35_17 = 16;
                        break;
                    }
                    if (var22_5 >= var2_2) ** GOTO lbl584
                    var23_6 = var0[var22_5++];
                    switch (var23_6) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            var32_14[var33_15++] = (char)var23_6;
                            var34_16 = var33_15;
                            ** GOTO lbl586
                        }
                        default: {
                            var35_17 = 16;
                            break;
                        }
                    }
                    break;
lbl584:
                    // 1 sources

                    var35_17 = 16;
                    break;
lbl586:
                    // 3 sources

                    block163: while (var22_5 < var2_2) {
                        var23_6 = var0[var22_5++];
                        switch (var23_6) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                var32_14[var33_15++] = (char)var23_6;
                                var34_16 = var33_15;
                                continue block163;
                            }
                            case 95: {
                                if (var22_5 < var2_2 && var0[var22_5] >= 48 && var0[var22_5] <= 57) continue block163;
                                var35_17 = 16;
                                break;
                            }
                            default: {
                                --var22_5;
                                while (var22_5 < var2_2 && Convert.isWhitespace(var0[var22_5])) {
                                    ++var22_5;
                                }
                                var35_17 = var22_5 < var2_2 ? 16 : 0;
                                break;
                            }
                        }
                        break block0;
                    }
                    var35_17 = 0;
                    break;
                }
                case 16: {
                    throw new NumberFormatException("does not meet strict criteria");
                }
            }
        }
        if (var32_14 == null || var34_16 == 0) {
            return 0.0;
        }
        return Double.parseDouble(new String(var32_14, 0, var34_16));
    }

    public static final byte[] doubleToByteArray(double d) {
        return ByteList.plain((CharSequence)Double.toString(d));
    }

    public static final byte[] twosComplementToBinaryBytes(byte[] byArray) {
        return Convert.twosComplementToUnsignedBytes(byArray, 1, false);
    }

    public static final byte[] twosComplementToOctalBytes(byte[] byArray) {
        return Convert.twosComplementToUnsignedBytes(byArray, 3, false);
    }

    public static final byte[] twosComplementToHexBytes(byte[] byArray, boolean bl) {
        return Convert.twosComplementToUnsignedBytes(byArray, 4, bl);
    }

    public static final byte[] twosComplementToUnsignedBytes(byte[] byArray, int n, boolean bl) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("shift value must be 1-4");
        }
        int n2 = byArray.length;
        int n3 = (n2 * 8 + n - 1) / n;
        byte[] byArray2 = new byte[n3];
        int n4 = (1 << n) - 1;
        byte[] byArray3 = bl ? UCDIGITS : DIGITS;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = n3;
        while (--n8 >= 0) {
            if (n6 < n) {
                n5 |= (byArray[--n7] & 0xFF) << n6;
                n6 += 8;
            }
            byArray2[n8] = byArray3[n5 & n4];
            n5 >>= n;
            n6 -= n;
        }
        return byArray2;
    }

    public static final int skipLeadingWhitespace(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2 && Convert.isWhitespace(byArray[n]); ++n) {
        }
        return n;
    }

    public static final int skipTrailingWhitespace(byte[] byArray) {
        int n;
        for (n = byArray.length - 1; n >= 0 && Convert.isWhitespace(byArray[n]); --n) {
        }
        return n + 1;
    }

    private static final boolean isWhitespace(byte by) {
        return by == 32 || by <= 13 && by >= 9 && by != 11;
    }

    public static final byte[] trim(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        int n = Convert.skipLeadingWhitespace(byArray);
        if (n >= byArray.length) {
            return EMPTY_BYTES;
        }
        int n2 = Convert.skipTrailingWhitespace(byArray);
        int n3 = n2 - n;
        if (n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public static final byte[] delete(byte[] byArray, int n, boolean bl) {
        int n2 = byArray.length;
        int n3 = n2 - 1;
        if (n < 0 || n > n3) {
            throw new IllegalArgumentException("illegal position for delete");
        }
        int n4 = n + 1;
        if (bl) {
            if (n3 == 0) {
                return EMPTY_BYTES;
            }
            byte[] byArray2 = new byte[n3];
            if (n == 0) {
                System.arraycopy(byArray, 1, byArray2, 0, n3);
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n);
                System.arraycopy(byArray, n4, byArray2, n, n3 - n);
            }
            return byArray2;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n4, byArray, n, n2 - n4);
            byArray[n3] = 0;
        } else {
            byArray[n3 - 1] = 0;
        }
        return byArray;
    }

    public static final byte[] delete(byte[] byArray, int n, int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal length for delete");
        }
        int n3 = byArray.length;
        if (n2 == 0 || n3 == 0) {
            return byArray;
        }
        int n4 = n3 - n2;
        int n5 = n + n2;
        if (n < 0 || n5 > n3) {
            throw new IllegalArgumentException("illegal position for delete");
        }
        if (bl) {
            if (n4 == 0) {
                return EMPTY_BYTES;
            }
            byte[] byArray2 = new byte[n4];
            if (n == 0) {
                System.arraycopy(byArray, n2, byArray2, 0, n4);
            } else if (n == n4) {
                System.arraycopy(byArray, 0, byArray2, 0, n4);
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n);
                System.arraycopy(byArray, n5, byArray2, n, n3 - n5);
            }
            return byArray2;
        }
        if (n4 > 0) {
            System.arraycopy(byArray, n5, byArray, n, n3 - n5);
        }
        Convert.fill(byArray, n4, n3 - n4, (byte)0);
        return byArray;
    }

    public static final byte[] insert(byte[] byArray, int n, byte by, boolean bl) {
        int n2 = byArray.length;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("illegal position for insert");
        }
        if (bl) {
            byte[] byArray2 = new byte[n2 + 1];
            if (n == 0) {
                System.arraycopy(byArray, 0, byArray2, 1, n2);
                byArray2[0] = by;
            } else if (n == n2) {
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray2[n2] = by;
            } else {
                System.arraycopy(byArray, 0, byArray2, 0, n);
                System.arraycopy(byArray, n, byArray2, n + 1, n2 - n);
                byArray2[n] = by;
            }
            return byArray2;
        }
        if (n == n2) {
            throw new IllegalArgumentException("illegal position for insert with no copy");
        }
        if (n > n2 - 1) {
            System.arraycopy(byArray, n, byArray, n + 1, n2 - n - 1);
        }
        byArray[n] = by;
        return byArray;
    }

    public static final byte[] insert(byte[] byArray, int n, byte[] byArray2, boolean bl) {
        int n2 = byArray.length;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("illegal position for insert");
        }
        int n3 = byArray2.length;
        if (bl) {
            int n4 = n2 + n3;
            byte[] byArray3 = new byte[n4];
            if (n == 0) {
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                System.arraycopy(byArray, 0, byArray3, n3, n2);
            } else if (n == n2) {
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                System.arraycopy(byArray2, 0, byArray3, n2, n3);
            } else {
                System.arraycopy(byArray, 0, byArray3, 0, n);
                System.arraycopy(byArray2, 0, byArray3, n, n3);
                System.arraycopy(byArray, n, byArray3, n + n3, n2 - n);
            }
            return byArray3;
        }
        int n5 = n + n3;
        if (n5 > n2) {
            throw new IllegalArgumentException("inserted array won't fit in target array");
        }
        if (n == 0) {
            System.arraycopy(byArray, 0, byArray, n3, n2 - n3);
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        } else if (n5 == n2) {
            System.arraycopy(byArray2, 0, byArray, n, n3);
        } else {
            System.arraycopy(byArray, n, byArray, n5, n2 - n5);
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        return byArray;
    }

    public static final byte[] append(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray[n] = by;
        return byArray;
    }

    public static final byte[] fill(byte[] byArray, int n, int n2, byte by) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal length for fill");
        }
        int n3 = n + n2;
        int n4 = byArray.length;
        if (n3 > n4) {
            n3 = n4;
        }
        while (n < n3) {
            byArray[n] = by;
            ++n;
        }
        return byArray;
    }

    public static final byte[] copy(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }
}

