/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.yaml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyHash;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.javasupport.JavaEmbedUtils;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jvyamlb.Representer;
import org.jvyamlb.SafeRepresenterImpl;
import org.jvyamlb.Serializer;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLNodeCreator;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;

public class JRubyRepresenter
extends SafeRepresenterImpl {
    public JRubyRepresenter(Serializer serializer, YAMLConfig yAMLConfig) {
        super(serializer, yAMLConfig);
    }

    protected YAMLNodeCreator getNodeCreatorFor(Object object) {
        if (object instanceof YAMLNodeCreator) {
            return (YAMLNodeCreator)object;
        }
        if (object instanceof IRubyObject) {
            return new IRubyObjectYAMLNodeCreator(object);
        }
        return super.getNodeCreatorFor(object);
    }

    public Node map(String string, Map map, Object object) throws IOException {
        if (null == object) {
            return this.map(string, map, false);
        }
        return this.map(string, map, true);
    }

    public Node seq(String string, List list, Object object) throws IOException {
        if (list instanceof RubyArray) {
            list = ((RubyArray)list).getList();
        }
        if (null == object) {
            return this.seq(string, list, false);
        }
        return this.seq(string, list, true);
    }

    public Node scalar(String string, String string2, String string3) throws IOException {
        return this.scalar(string, ByteList.create((CharSequence)string2), string3);
    }

    public Node scalar(String string, ByteList byteList, String string2) throws IOException {
        if (null == string2 || string2.length() == 0) {
            return this.scalar(string, byteList, '\u0000');
        }
        return this.scalar(string, byteList, string2.charAt(0));
    }

    public Node representMapping(String string, Map map, boolean bl) throws IOException {
        Iterator iterator;
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        Iterator iterator2 = iterator = map instanceof RubyHash ? ((RubyHash)map).directEntrySet().iterator() : map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(this.representData(entry.getKey()), this.representData(entry.getValue()));
        }
        return new MappingNode(string, hashMap, bl);
    }

    protected boolean ignoreAliases(Object object) {
        return object instanceof IRubyObject && ((IRubyObject)object).isNil() || super.ignoreAliases(object);
    }

    public static class IRubyObjectYAMLNodeCreator
    implements YAMLNodeCreator {
        private final IRubyObject data;
        private final RubyClass outClass;

        public IRubyObjectYAMLNodeCreator(Object object) {
            this.data = (IRubyObject)object;
            this.outClass = (RubyClass)((RubyModule)this.data.getRuntime().getModule("YAML").getConstant("JvYAML")).getConstant("Node");
        }

        public String taguri() {
            return this.data.callMethod(this.data.getRuntime().getCurrentContext(), "taguri").toString();
        }

        public Node toYamlNode(Representer representer) throws IOException {
            if (this.data.getMetaClass().searchMethod("to_yaml") == this.data.getRuntime().getObjectToYamlMethod() || this.data.getMetaClass().searchMethod("to_yaml").isUndefined()) {
                IRubyObject iRubyObject = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml_node", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                if (iRubyObject instanceof Node) {
                    return (Node)iRubyObject;
                }
                if (iRubyObject instanceof IRubyObject) {
                    return (Node)JavaEmbedUtils.rubyToJava(this.data.getRuntime(), iRubyObject, Node.class);
                }
            } else {
                IRubyObject iRubyObject = this.data.callMethod(this.data.getRuntime().getCurrentContext(), "to_yaml", JavaEmbedUtils.javaToRuby(this.data.getRuntime(), representer));
                if (!this.outClass.isInstance(iRubyObject)) {
                    throw iRubyObject.getRuntime().newTypeError("wrong argument type " + iRubyObject.getMetaClass().getRealClass() + " (expected YAML::JvYAML::Node)");
                }
                IRubyObject iRubyObject2 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "value");
                IRubyObject iRubyObject3 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "style");
                IRubyObject iRubyObject4 = iRubyObject.callMethod(this.data.getRuntime().getCurrentContext(), "type_id");
                String string = null;
                if (!iRubyObject3.isNil()) {
                    string = iRubyObject3.toString();
                }
                String string2 = iRubyObject4.toString();
                if (iRubyObject2 instanceof RubyHash) {
                    return ((JRubyRepresenter)representer).map(string2, (RubyHash)iRubyObject2, string);
                }
                if (iRubyObject2 instanceof RubyArray) {
                    return ((JRubyRepresenter)representer).seq(string2, (RubyArray)iRubyObject2, string);
                }
                return ((JRubyRepresenter)representer).scalar(string2, ((RubyString)iRubyObject2).getByteList(), string);
            }
            return null;
        }
    }
}

