/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionsExportModel {
    private static final Logger LOGGER = Logger.getLogger(OptionsExportModel.class.getName());
    private static final String OPTIONS_EXPORT_FOLDER = "OptionsExport";
    private static final String GROUP_PATTERN = "([^/]*)";
    private File source;
    private List<Category> categories;
    List<String> relativePaths;

    public OptionsExportModel(File file) {
        this.source = file;
    }

    List<Category> getCategories() {
        if (this.categories == null) {
            this.loadCategories();
        }
        return this.categories;
    }

    State getState() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Category category : this.getCategories()) {
            if (!category.isApplicable()) continue;
            ++n3;
            if (category.getState() == State.ENABLED) {
                ++n;
                continue;
            }
            if (category.getState() != State.DISABLED) continue;
            ++n2;
        }
        if (n == n3) {
            return State.ENABLED;
        }
        if (n2 == n3) {
            return State.DISABLED;
        }
        return State.PARTIAL;
    }

    void setState(State state) {
        for (Category category : this.getCategories()) {
            category.setState(state);
        }
    }

    void doImport(File file) {
        try {
            if (this.source.isFile()) {
                this.extractZipFile(file);
            } else {
                this.copy(file);
            }
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.import.error"));
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    void doExport(File file) {
        try {
            this.createZipFile(file);
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.export.zip.error", (Object)file));
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void copy(File file) throws IOException {
        LOGGER.fine("Copying from: " + this.source + "\nto:" + file);
        List<String> list = this.getApplicablePaths(this.getIncludePatterns(), this.getExcludePatterns());
        if (!(list.isEmpty() || file.exists() || file.mkdirs())) {
            throw new IOException("Cannot create folder: " + file.getAbsolutePath());
        }
        for (String string : list) {
            LOGGER.fine("Path=" + string);
            OptionsExportModel.copyFile(new File(this.source, string), new File(file, string));
        }
    }

    private void extractZipFile(File file) throws IOException {
        LOGGER.fine("Extracting from:" + this.source + " to:" + file);
        List<String> list = this.getApplicablePaths(this.getIncludePatterns(), this.getExcludePatterns());
        OptionsExportModel.extractZipFile(this.source, file, list);
    }

    private void createZipFile(File file) throws IOException {
        LOGGER.fine("Creating file:" + file + " from:" + this.source);
        List<String> list = this.getApplicablePaths(this.getIncludePatterns(), this.getExcludePatterns());
        OptionsExportModel.createZipFile(file, this.source, list);
    }

    private Set<Pattern> getIncludePatterns() {
        HashSet<Pattern> hashSet = new HashSet<Pattern>();
        for (Category category : this.getCategories()) {
            for (Item item : category.getItems()) {
                String string;
                if (!item.isEnabled() || (string = item.getInclude()) == null || string.length() <= 0) continue;
                hashSet.add(Pattern.compile(string));
            }
        }
        return hashSet;
    }

    private Set<Pattern> getExcludePatterns() {
        HashSet<Pattern> hashSet = new HashSet<Pattern>();
        for (Category category : this.getCategories()) {
            for (Item item : category.getItems()) {
                String string;
                if (!item.isEnabled() || (string = item.getExclude()) == null || string.length() <= 0) continue;
                hashSet.add(Pattern.compile(string));
            }
        }
        return hashSet;
    }

    public String toString() {
        return this.getClass().getName() + " source=" + this.source;
    }

    private void loadCategories() {
        FileObject[] fileObjectArray = FileUtil.getConfigFile((String)OPTIONS_EXPORT_FOLDER).getChildren();
        List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
        this.categories = new ArrayList<Category>(list.size());
        for (FileObject fileObject : list) {
            String string = (String)fileObject.getAttribute("displayName");
            this.categories.add(new Category(fileObject, string));
        }
    }

    private List<String> getApplicablePaths(Set<Pattern> set, Set<Pattern> set2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getRelativePaths()) {
            if (!OptionsExportModel.include(string, set, set2)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> getRelativePaths() {
        if (this.relativePaths == null) {
            if (this.source.isFile()) {
                try {
                    this.relativePaths = OptionsExportModel.listZipFile(this.source);
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.invalid.zipfile", (Object)this.source));
                    Exceptions.printStackTrace((Throwable)iOException);
                    this.relativePaths = Collections.emptyList();
                }
            } else {
                this.relativePaths = OptionsExportModel.getRelativePaths(this.source);
            }
            LOGGER.fine("relativePaths=" + this.relativePaths);
        }
        return this.relativePaths;
    }

    private static List<String> getRelativePaths(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        OptionsExportModel.getRelativePaths(file, file, arrayList);
        return arrayList;
    }

    private static void getRelativePaths(File file, File file2, List<String> list) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file3 : fileArray) {
                OptionsExportModel.getRelativePaths(file3, file2, list);
            }
        } else {
            list.add(OptionsExportModel.getRelativePath(file2, file));
        }
    }

    private static String getRelativePath(File file, File file2) {
        String string = file2.getAbsolutePath().substring(file.getAbsolutePath().length());
        if ((string = string.replace('\\', '/')).startsWith("/") && !string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private static boolean include(String string, Set<Pattern> set, Set<Pattern> set2) {
        Matcher matcher;
        boolean bl = false;
        for (Pattern pattern : set) {
            matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            bl = true;
            break;
        }
        if (bl) {
            for (Pattern pattern : set2) {
                matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                return false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        OptionsExportModel.ensureParent(file2);
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static void ensureParent(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("Cannot create folder: " + file2.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipFile(File file, File file2, List<String> list) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!list.contains(zipEntry.getName())) continue;
            LOGGER.fine("Extracting:" + zipEntry.getName());
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                File file3 = new File(file2, zipEntry.getName());
                OptionsExportModel.ensureParent(file3);
                fileOutputStream = new FileOutputStream(file3);
                FileUtil.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream == null) continue;
                fileOutputStream.close();
            }
        }
    }

    private static List<String> listZipFile(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().getName();
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(File file, File file2, List<String> list) throws IOException {
        OptionsExportModel.ensureParent(file);
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            for (String string : list) {
                LOGGER.fine("Adding to zip: " + string);
                zipOutputStream.putNextEntry(new ZipEntry(string));
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(new File(file2, string));
                    FileUtil.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                zipOutputStream.closeEntry();
            }
            OptionsExportModel.createProductInfo(zipOutputStream);
            zipOutputStream.close();
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static void createProductInfo(ZipOutputStream zipOutputStream) throws IOException {
        String string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
        String string2 = System.getProperty("os.name", "unknown") + ", " + System.getProperty("os.version", "unknown") + ", " + System.getProperty("os.arch", "unknown");
        String string3 = System.getProperty("java.version", "unknown") + ", " + System.getProperty("java.vm.name", "unknown") + ", " + System.getProperty("java.vm.version", "");
        zipOutputStream.putNextEntry(new ZipEntry("build.info"));
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        printWriter.println("ProductVersion=" + string);
        printWriter.println("OS=" + string2);
        printWriter.println("Java=" + string3);
        printWriter.println("Userdir=" + System.getProperty("netbeans.user"));
        printWriter.flush();
        zipOutputStream.closeEntry();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Category {
        private static final String INCLUDE = "include";
        private static final String EXCLUDE = "exclude";
        private static final String DISPLAY_NAME = "displayName";
        private FileObject categoryFO;
        private String displayName;
        private List<Item> items;
        private State state = State.DISABLED;

        public Category(FileObject fileObject, String string) {
            this.categoryFO = fileObject;
            this.displayName = string;
        }

        private void addItem(String string, String string2, String string3) {
            this.items.add(new Item(string, string2, string3));
        }

        private void resolveGroups(String string, String string2, String string3) {
            Object object;
            LOGGER.fine("resolveGroups include=" + string2);
            List list = OptionsExportModel.this.getApplicablePaths(Collections.singleton(Pattern.compile(string2)), Collections.singleton(Pattern.compile(string3)));
            HashSet<String> hashSet = new HashSet<String>();
            Pattern pattern = Pattern.compile(string2);
            for (String string4 : list) {
                String string5;
                object = pattern.matcher(string4);
                ((Matcher)object).matches();
                if (((Matcher)object).groupCount() != 1 || (string5 = ((Matcher)object).group(1)) == null) continue;
                hashSet.add(string5);
            }
            LOGGER.fine("GROUPS=" + hashSet);
            for (String string4 : hashSet) {
                object = string4;
                if (string.contains("{")) {
                    object = MessageFormat.format(string, string4);
                }
                this.addItem((String)object, string2.replace(OptionsExportModel.GROUP_PATTERN, string4), string3);
            }
        }

        public List<Item> getItems() {
            if (this.items == null) {
                FileObject[] fileObjectArray;
                this.items = new ArrayList<Item>();
                for (FileObject fileObject : fileObjectArray = this.categoryFO.getChildren()) {
                    String string;
                    String string2 = (String)fileObject.getAttribute(DISPLAY_NAME);
                    assert (string2 != null) : "Display name of export option item not defined in layer.";
                    String string3 = (String)fileObject.getAttribute(INCLUDE);
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string = (String)fileObject.getAttribute(EXCLUDE)) == null) {
                        string = "";
                    }
                    if (string3.contains(OptionsExportModel.GROUP_PATTERN)) {
                        this.resolveGroups(string2, string3, string);
                        continue;
                    }
                    this.addItem(string2, string3, string);
                }
            }
            return this.items;
        }

        public String getName() {
            return this.categoryFO.getNameExt();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setState(State state) {
            this.state = state;
            this.updateItems(state);
        }

        public State getState() {
            return this.state;
        }

        public boolean isApplicable() {
            for (Item item : this.getItems()) {
                if (!item.isApplicable()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getDisplayName() + ", state=" + (Object)((Object)this.getState());
        }

        private void updateItems(State state) {
            for (Item item : this.getItems()) {
                if (state == State.PARTIAL || !item.isApplicable()) continue;
                item.setEnabled(state.toBoolean());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ENABLED(Boolean.TRUE),
        DISABLED(Boolean.FALSE),
        PARTIAL(null);

        private final Boolean bool;

        private State(Boolean bl) {
            this.bool = bl;
        }

        public Boolean toBoolean() {
            return this.bool;
        }

        public static State valueOf(Boolean bl) {
            if (bl == null) {
                return PARTIAL;
            }
            return bl != false ? ENABLED : DISABLED;
        }
    }

    class Item {
        private String displayName;
        private String include;
        private String exclude;
        private boolean enabled = false;
        private boolean applicable = false;
        private boolean applicableInitialized = false;

        public Item(String string, String string2, String string3) {
            this.displayName = string;
            this.include = string2;
            this.exclude = string3;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getInclude() {
            return this.include;
        }

        public String getExclude() {
            return this.exclude;
        }

        public boolean isApplicable() {
            if (!this.applicableInitialized) {
                List list = OptionsExportModel.this.getApplicablePaths(Collections.singleton(Pattern.compile(this.include)), Collections.singleton(Pattern.compile(this.exclude)));
                LOGGER.fine("    applicablePaths=" + list);
                this.applicable = !list.isEmpty();
                this.applicableInitialized = true;
            }
            return this.applicable;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public String toString() {
            return this.getDisplayName() + ", enabled=" + this.isEnabled();
        }
    }
}

